
if exist('REVS','var') && REVS.verbose  disp(['Loading ' mfilename]); end

controls = class_REVS_CVM_control( engine );

controls.start_stop_off_delay_secs = 0;
controls.start_stop_enable = false;
controls.start_stop_warmup_condition = '(@cycle_pos_secs >= 100) && (@cycle_pos_secs <= 3406)';

controls.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

controls.shift_inertia_est_kgm2 =	engine.inertia_kgm2 + ...
                                    accessories.air_conditioner.inertia_kgm2 + ...
                                    accessories.fan.inertia_kgm2 + ...
                                    accessories.power_steering.inertia_kgm2 + ...
                                    accessories.generic_loss.inertia_kgm2;

if isa(transmission, 'class_REVS_AT_transmission')								
    controls.shift_inertia_est_kgm2 = controls.shift_inertia_est_kgm2 + transmission.torque_converter.pump_inertia_kgm2;
end
