
if exist('REVS','var') && REVS.verbose  disp(['Loading ' mfilename]); end

engine.fast_torque_fuel_adjust_norm = 1;

controls = class_REVS_P0_control(engine);

controls.P0_controls_variant = 'MTE_48V';

controls.start_stop_warmup_condition = '(@cycle_pos_secs >= 100) && (@cycle_pos_secs <= 3406)';
controls.start_stop_off_delay_secs = 0;

controls.regen_vspeed_limit_mps   = [3 5];
controls.regen_vspeed_derate_norm = [0 1];

controls.regen_soc_limit_norm  = [0.7 0.8];
controls.regen_soc_derate_norm = [1   0];

controls.motor_vspeed_limit_mps   = [0 60] * unit_convert.mph2mps;
controls.motor_vspeed_derate_norm = [1 1];

controls.motor_soc_limit_norm  = [0.45 0.5];
controls.motor_soc_derate_norm = [0     1];

controls.motor_min_power_threshold_W = 0;
controls.regen_min_power_threshold_W = 0;

controls.charge_depleting_min_soc_norm  = 0.4;
controls.charge_sustaining_max_soc_norm = 0.45;

controls.ev_mode_min_soc_norm    = 0.55;
controls.ev_mode_soc_limit_norm  = [controls.ev_mode_min_soc_norm controls.ev_mode_min_soc_norm + 0.025];
controls.ev_mode_soc_derate_norm = [0 1];
