function [battery] = battery_base_A123_48V_8Ah()

% based on A123 8Ah 0.4kWh LFP battery 

battery = class_REVS_battery;

battery.cell.chemistry                  = enum_battery_type.LiFePO4_Energy;
battery.cell.capacity_nominal_Ah        = 8;

battery.num_parallel_cells              = 1;
battery.num_series_cells                = 14;
battery.use_average_open_circuit_Volts  = false;

battery.initial_soc_norm   = 0.43;

battery.cell.powerlimit_discharge_map_W.axis_1.signal      = 'temp_degC';
battery.cell.powerlimit_discharge_map_W.axis_1.breakpoints = [-20	-10	0	10	20	30	40	50	60];
battery.cell.powerlimit_discharge_map_W.axis_2.signal      = 'soc_norm';
battery.cell.powerlimit_discharge_map_W.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9];
battery.cell.powerlimit_discharge_map_W.table              = [71	100	114     136     157     171     186     214     229
                                                              150	214	279     321     364     400     421     457     479
                                                              214	343	450     536     579     607     636     664     714
                                                              293	521	679     800     879     914     943     964     979
                                                              393	771	964     1000	1014	1021	1029	1036	1050
                                                              436	936	1021	1043	1057	1064	1071	1079	1086
                                                              414	957	1050	1071	1086	1086	1093	1100	1107
                                                              421	971	1064	1086	1100	1100	1107	1114	1129
                                                              443	986	1071	1093	1107	1107	1121	1129	1136];
                                                       
battery.cell.powerlimit_charge_map_W.axis_1.signal      = 'temp_degC';
battery.cell.powerlimit_charge_map_W.axis_1.breakpoints = [-20	-10	0	10	20	30	40	50	60];
battery.cell.powerlimit_charge_map_W.axis_2.signal      = 'soc_norm';
battery.cell.powerlimit_charge_map_W.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9];
battery.cell.powerlimit_charge_map_W.table              = [86	79      64      64      57      57      57      50      50
                                                          171	157     136     129     129     121     121     107     93
                                                          407	357     321     307     300     300     286     236     193
                                                          714	621     579     557     557     550     507     407     286
                                                          1221	1129	1071	1100	1079	1029	907     843     471
                                                          1271	1286	1300	1307	1307	1314	1164	1100	529
                                                          1257	1271	1286	1293	1300	1300	1300	1171	750
                                                          1250	1264	1279	1286	1293	1293	1293	1300	929
                                                          1243	1257	1271	1286	1286	1286	1286	1300	957];

battery.cell.open_circuit_voltage_map_discharge_V.axis_1.signal      = 'temp_degC';
battery.cell.open_circuit_voltage_map_discharge_V.axis_1.breakpoints = [-30	-20 -10 0 10 20 30 45];
battery.cell.open_circuit_voltage_map_discharge_V.axis_2.signal      = 'soc_norm';
battery.cell.open_circuit_voltage_map_discharge_V.axis_2.breakpoints = [0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.975  1.0];
battery.cell.open_circuit_voltage_map_discharge_V.table              =  [2.5	3.061	3.217	3.245	3.251	3.264	3.271	3.289	3.297	3.302	3.309	3.65
                                                                         2.5	3.174	3.22	3.25	3.26	3.27	3.28	3.29	3.3     3.31	3.32	3.65
                                                                         2.5	3.177	3.222	3.251	3.266	3.277	3.282	3.291	3.307	3.325	3.325	3.65
                                                                         2.5	3.18	3.223	3.254	3.271	3.282	3.284	3.293	3.313	3.329	3.332	3.65
                                                                         2.5	3.196	3.227	3.255	3.278	3.288	3.29	3.295	3.328	3.333	3.335	3.65
                                                                         2.5	3.207	3.233	3.256	3.285	3.294	3.296	3.303	3.335	3.337	3.338	3.65
                                                                         2.5	3.208	3.238	3.256	3.287	3.296	3.298	3.304	3.335	3.338	3.339	3.65
                                                                         2.5	3.209	3.239	3.256	3.287	3.299	3.301	3.336	3.335	3.339	3.34	3.65];

battery.cell.open_circuit_voltage_map_charge_V.axis_1.signal      = 'temp_degC';
battery.cell.open_circuit_voltage_map_charge_V.axis_1.breakpoints = [-30	-20 -10 0 10 20 30 45];
battery.cell.open_circuit_voltage_map_charge_V.axis_2.signal      = 'soc_norm';
battery.cell.open_circuit_voltage_map_charge_V.axis_2.breakpoints = [0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.975  1.0];
battery.cell.open_circuit_voltage_map_charge_V.table              = [2.5	3.2     3.245	3.25	3.255	3.271	3.279	3.296	3.304	3.306	3.353	3.65
                                                                     2.5	3.201	3.252	3.261	3.274	3.278	3.285	3.3     3.315	3.321	3.357	3.65
                                                                     2.5	3.2045	3.26	3.265	3.285	3.287	3.289	3.321	3.331	3.333	3.36	3.65
                                                                     2.5	3.208	3.2605	3.269	3.289	3.291	3.293	3.323	3.335	3.335	3.36	3.65
                                                                     2.5	3.215	3.261	3.274	3.294	3.295	3.298	3.3249	3.338	3.338	3.36	3.65
                                                                     2.5	3.222	3.267	3.277	3.299	3.3     3.303	3.33	3.339	3.34	3.3595	3.65
                                                                     2.5	3.223	3.269	3.279	3.301	3.302	3.304	3.331	3.34	3.341	3.359	3.65
                                                                     2.5	3.227	3.269	3.279	3.303	3.305	3.307	3.328	3.34	3.342	3.357	3.65];

%% UC Davis first order battery model
battery.cell.transient_R_discharge_short_term_Ohms.axis_1.signal            = 'pack_curr_A';
battery.cell.transient_R_discharge_short_term_Ohms.axis_1.breakpoints       = [5    10    25    50   100   200];
battery.cell.transient_R_discharge_short_term_Ohms.axis_2.signal            = 'soc_norm';
battery.cell.transient_R_discharge_short_term_Ohms.axis_2.breakpoints       = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.transient_R_discharge_short_term_Ohms.table                    = flipud([  0.000542 0.000457 0.000372 0.000408 0.000444 0.000364 0.000286 0.000376 0.000467 0.000522 0.000577;
                                                                                        0.000514 0.000484 0.000471 0.000458 0.000479 0.0005 0.000466 0.000431 0.000536 0.000599 0.000661;
                                                                                        0.00055 0.000536 0.000521 0.000504 0.000487 0.000475 0.000463 0.000429 0.000532 0.000595 0.000658;
                                                                                        0.000617 0.00057 0.000523 0.000483 0.000443 0.000421 0.0004 0.000371 0.00046 0.000514 0.000569;
                                                                                        0.000607 0.000514 0.000421 0.000432 0.000443 0.000471 0.0005 0.000463 0.000575 0.000643 0.000711;
                                                                                        0.000586 0.000529 0.000471 0.000457 0.000443 0.000421 0.0004 0.000371 0.00046 0.000514 0.000569]);

battery.cell.transient_R_charge_short_term_Ohms.axis_1.signal               = 'pack_curr_A';
battery.cell.transient_R_charge_short_term_Ohms.axis_1.breakpoints          = [-200 -100 -50 -25 -10 -5];
battery.cell.transient_R_charge_short_term_Ohms.axis_2.signal               = 'soc_norm';
battery.cell.transient_R_charge_short_term_Ohms.axis_2.breakpoints          = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.transient_R_charge_short_term_Ohms.table                       = [0.000421 0.000338 0.000255 0.000297 0.00034 0.00052 0.000701 0.000664 0.000627 0.000589 0.000528;
                                                                               0.000466 0.000441 0.000501 0.000536 0.000572 0.00053 0.000488 0.000371 0.00035 0.000329 0.000294;
                                                                               0.000446 0.000516 0.000587 0.000626 0.000664 0.00061 0.000556 0.000603 0.000547 0.000491 0.000333;
                                                                               0.00042 0.000396 0.000451 0.00048 0.000546 0.000611 0.000613 0.000614 0.000363 0.000367 0.000371;
                                                                               0.00053 0.0005 0.000529 0.000557 0.000596 0.000636 0.000682 0.00067 0.000657 0.000629 0.000587;
                                                                               0.000561 0.000529 0.000621 0.000714 0.000714 0.000714 0.000707 0.0007 0.000671 0.000643 0.0006];

battery.cell.transient_R_discharge_long_term_Ohms.axis_1.signal             = 'pack_curr_A';
battery.cell.transient_R_discharge_long_term_Ohms.axis_1.breakpoints        = [5    10    25    50   100   200];
battery.cell.transient_R_discharge_long_term_Ohms.axis_2.signal             = 'soc_norm';
battery.cell.transient_R_discharge_long_term_Ohms.axis_2.breakpoints        = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.transient_R_discharge_long_term_Ohms.table                     = flipud([0.000359 0.000299 0.000239 0.000266 0.000292 0.000236 0.000179 0.000244 0.00031 0.000181 0.000406;
                                                                                      0.000334 0.000312 0.000301 0.000289 0.000311 0.000334 0.000306 0.000277 0.000274 0.000204 0.000358;
                                                                                      0.000379 0.000361 0.000344 0.000336 0.000329 0.000316 0.000304 0.000279 0.000272 0.000206 0.000356;
                                                                                      0.00038 0.000361 0.000343 0.000333 0.000323 0.000319 0.000314 0.000269 0.000281 0.000199 0.000368;
                                                                                      0.000386 0.000364 0.000343 0.000325 0.000307 0.0003 0.000293 0.000289 0.000262 0.000214 0.000343;
                                                                                      0.000429 0.0004 0.000371 0.000343 0.000314 0.000271 0.000229 0.000371 0.000204 0.000274 0.000268]);

battery.cell.transient_R_charge_long_term_Ohms.axis_1.signal                = 'pack_curr_A';
battery.cell.transient_R_charge_long_term_Ohms.axis_1.breakpoints           = [-200 -100 -50 -25 -10 -5];
battery.cell.transient_R_charge_long_term_Ohms.axis_2.signal                = 'soc_norm';
battery.cell.transient_R_charge_long_term_Ohms.axis_2.breakpoints           = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.transient_R_charge_long_term_Ohms.table                        = [0.000274 0.000219 0.000162 0.000189 0.000216 0.000187 0.000171 0.000245 0.000443 0.000409 0.000444;
                                                                               0.000249 0.000287 0.000326 0.000356 0.000386 0.000356 0.000325 0.000465 0.000432 0.0004 0.000434;
                                                                               0.000289 0.000334 0.000379 0.000407 0.000436 0.000402 0.000369 0.000387 0.000406 0.000443 0.00048;
                                                                               0.00028 0.000299 0.000317 0.000387 0.000391 0.000394 0.000409 0.000466 0.000523 0.000504 0.000486;
                                                                               0.000341 0.000364 0.000379 0.000393 0.000396 0.0004 0.000457 0.000514 0.000479 0.000443 0.000429;
                                                                               0.000335 0.000357 0.000343 0.000329 0.000357 0.000386 0.000486 0.000586 0.000493 0.0004 0.000479];

%%

battery.cell.resistance_map_discharge_Ohms.axis_1.signal      = 'pack_curr_A';
battery.cell.resistance_map_discharge_Ohms.axis_1.breakpoints = [5    10    25    50   100   200];
battery.cell.resistance_map_discharge_Ohms.axis_2.signal      = 'soc_norm';
battery.cell.resistance_map_discharge_Ohms.axis_2.breakpoints = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.resistance_map_discharge_Ohms.table              = [0.000625 0.000636 0.000500 0.000557 0.000614 0.000596 0.000577 0.000644 0.000462 0.000396 0.000329;
                                                                 0.000605 0.000657 0.000586 0.000589 0.000593 0.000575 0.000557 0.000621 0.000446 0.000382 0.000318;
                                                                 0.000641 0.000600 0.000457 0.000523 0.000589 0.000577 0.000566 0.000631 0.000453 0.000388 0.000322;
                                                                 0.000624 0.000572 0.000413 0.000434 0.000456 0.000444 0.000431 0.000481 0.000346 0.000296 0.000246;
                                                                 0.000616 0.000604 0.000592 0.000446 0.000397 0.000349 0.000394 0.000440 0.000316 0.000270 0.000225;
                                                                 0.000374 0.000555 0.000546 0.000536 0.000336 0.000464 0.000591 0.000461 0.000331 0.000284 0.000236];

battery.cell.resistance_map_charge_Ohms.axis_1.signal       = 'pack_curr_A';
battery.cell.resistance_map_charge_Ohms.axis_1.breakpoints  = [-200 -100 -50 -25 -10 -5]; % charge amps are negative
battery.cell.resistance_map_charge_Ohms.axis_2.signal       = 'soc_norm';
battery.cell.resistance_map_charge_Ohms.axis_2.breakpoints  = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.resistance_map_charge_Ohms.table               = [0.000456 0.000601 0.000657 0.000713 0.000680 0.000690 0.000701 0.000664 0.000627 0.000589 0.000553;
                                                               0.000354 0.000379 0.000415 0.000419 0.000423 0.000525 0.000626 0.000371 0.000350 0.000329 0.000309;
                                                               0.000494 0.000423 0.000407 0.000391 0.000430 0.000538 0.000646 0.000648 0.000650 0.000491 0.000333;
                                                               0.000591 0.000506 0.000557 0.000609 0.000631 0.000654 0.000654 0.000654 0.000363 0.000367 0.000371;
                                                               0.000593 0.000507 0.000504 0.000500 0.000561 0.000621 0.000568 0.000514 0.000586 0.000657 0.000621;
                                                               0.000584 0.000500 0.000464 0.000429 0.000493 0.000557 0.000529 0.000500 0.000571 0.000643 0.000600];

battery.cell.transient_C_discharge_short_term_Farads.axis_1.signal      = 'pack_curr_A';
battery.cell.transient_C_discharge_short_term_Farads.axis_1.breakpoints = [5    10    25    50   100   200];
battery.cell.transient_C_discharge_short_term_Farads.axis_2.signal      = 'soc_norm';
battery.cell.transient_C_discharge_short_term_Farads.axis_2.breakpoints = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.transient_C_discharge_short_term_Farads.table              = flipud([ 223.98	380.70	537.43	381.53	225.62	425.31	625.00	427.18	229.3577982	229.03	166.52
                                                                                   434.46	501.47	453.55	405.62	324.24	242.86	303.55	364.2384106	195.56	195.29	141.99
                                                                                   467.53	418.70	369.86	382.88	395.89	390.85	385.8024691	462.94	248.56	248.21	180.46
                                                                                   486.11	454.80	423.50	477.88	532.26	560.77	589.2857143	707.11	379.65	379.12	275.65
                                                                                   482.35	563.21	644.07	580.10	516.13	536.64	557.1428571	668.54	358.95	358.44	260.61
                                                                                   439.02	499.82	560.61	578.69	596.77	637.67	678.5714286	814.24	437.18	436.56	317.41]);

battery.cell.transient_C_charge_short_term_Farads.axis_1.signal        = 'pack_curr_A';
battery.cell.transient_C_charge_short_term_Farads.axis_1.breakpoints   = [-200 -100 -50 -25 -10 -5];
battery.cell.transient_C_charge_short_term_Farads.axis_2.signal        = 'soc_norm';
battery.cell.transient_C_charge_short_term_Farads.axis_2.breakpoints   = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.transient_C_charge_short_term_Farads.table                = [  254.67	421.45	588.24	567.51	546.79	488.35	429.91	496.91	563.9097744	550.42	536.93
                                                                            178.76	140.13	185.45	198.84	212.23	333.06	453.88	230.46	261.37	255.20	249.02
                                                                            416.67	317.82	218.98	243.90	268.82	378.62	488.43	463.62	438.80	382.23	325.6704981
                                                                            595.24	543.15	491.07	464.53	481.78	455.61	471.99	488.37	274.82	305.68	336.5384615
                                                                            485.32	442.86	420.15	397.44	412.20	426.97	404.66	382.35	422.88	463.41	481.71
                                                                            444.28	405.41	402.70	400.00	385.00	370.00	348.27	326.53	391.04	455.56	452.78];

battery.cell.transient_C_discharge_long_term_Farads.axis_1.signal      = 'pack_curr_A';
battery.cell.transient_C_discharge_long_term_Farads.axis_1.breakpoints = [5    10    25    50   100   200];
battery.cell.transient_C_discharge_long_term_Farads.axis_2.signal      = 'soc_norm';
battery.cell.transient_C_discharge_long_term_Farads.axis_2.breakpoints = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.transient_C_discharge_long_term_Farads.table              = flipud([1611.94	1850.75	2089.55	2071.67	2053.79	2461.16	2868.53	2390.48	1912.442396	1742.04	1571.64;
                                                                                 1435.08	1464.53	1621.15	1777.78	1743.59	1709.40	1834.08	1958.762887	1567.06	1427.43	1287.80;
                                                                                 1169.81	1311.05	1452.28	1487.01	1521.74	1617.68	1713.615023	1830.11	1464.13	1333.67	1203.22;
                                                                                 1052.63	1224.23	1395.83	1405.88	1415.93	1435.24	1454.545455	1553.43	1242.78	1132.04	1021.31;
                                                                                 1055.56	1142.36	1229.17	1370.40	1511.63	1463.13	1414.634146	1510.80	1208.68	1100.98	993.29;
                                                                                 1033.33	1093.59	1153.85	1258.74	1363.64	1603.69	1843.75	1969.09	1575.32	1434.95	1294.59]);

battery.cell.transient_C_charge_long_term_Farads.axis_1.signal         = 'pack_curr_A';
battery.cell.transient_C_charge_long_term_Farads.axis_1.breakpoints    = [-200 -100 -50 -25 -10 -5];
battery.cell.transient_C_charge_long_term_Farads.axis_2.signal         = 'soc_norm';
battery.cell.transient_C_charge_long_term_Farads.axis_2.breakpoints    = [0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8];
battery.cell.transient_C_charge_long_term_Farads.table                 = [  2109.38	2681.06	3252.75	2770.65	2288.56	2193.84	2099.13	1986.16	1873.198847	1810.04	1717.32
                                                                            1841.23	1842.11	1690.76	1524.10	1497.23	1473.89	1450.55	1152.07	1114.50	1076.923077	1021.76
                                                                            1757.43	1624.00	1490.57	1343.64	1196.72	1170.07	1143.41	1091.07	1038.73	988.12	937.5
                                                                            1581.63	1511.54	1441.44	1376.23	1302.50	1068.84	1015.19	961.54	915.30	913.53	911.7647059
                                                                            1374.65	1313.73	1256.86	1200.00	1135.71	1071.43	945.44	819.44	885.53	951.61	941.32
                                                                            1423.07	1360.00	1299.57	1239.13	1184.38	1129.63	967.25	804.88	902.44	1000.00	897.44];

%%
battery.charge_efficiency_map_norm.axis_1.signal                       = 'soc_norm';
battery.charge_efficiency_map_norm.axis_1.breakpoints                  = [0.00 0.50 0.85 0.90 1.00];
battery.charge_efficiency_map_norm.table                               = [0.99 0.99 0.99 0.98 0.97];

%%
battery.cell.temperature_power_derate_index_temp_degC  = [-30 -20 -10 0 10 20 30 40 50 55];
battery.cell.temperature_power_discharge_derate_norm   = [0.1139 0.3454 0.5528 0.7314 0.8763 0.9828 1.046 1.0611 1.0233 0.1139];
battery.cell.temperature_power_charge_derate_norm      = [0.027 0.09675 0.1665 0.4031 0.6776 0.9351 1.1206 1.179 1.0554 0.027];
battery.use_second_order_model                         = true;

battery.discharge_derate_soc_norm  = [0.25 0.28];
battery.charge_derate_soc_norm     = [0.92 0.99];
battery.thermal.initial_temp_degC  = 22.25;

battery.thermal.pack_mass_kg                           = 8;    % 68Ah AGM battery weight 45 lb 
battery.thermal.specific_heat_capacity_JpkgK           = 795;  % VRLA-AGM 792, Vented 1080 J/Kg-K - Handbook for Stationary Lead-Acid Batteries
battery.thermal.heat_transfer_coefficient_Wpm2K        = 14.9; % 0.25 ABS plastics, 0.19 W/m.k Polycarbonate conductivity
battery.thermal.pack_heat_transfer_area_m2             = 0.19; % unit area m^2

end