function [battery] = battery_lead_acid_flooded_41Ah()

% based on data in a paper from Christopher Suozzo, 2008
% was used as baseline battery for ALPHA modeling but now has new 
% reduced charge efficiency 9/15/16
% vehicle models should be updated to use this battery instead of previous

battery = class_REVS_battery;

battery.cell.chemistry             = enum_battery_type.lead_acid;
battery.cell.capacity_nominal_Ah   = 41;

battery.num_parallel_cells              = 1;
battery.num_series_cells                = 6;
battery.use_average_open_circuit_Volts  = true;
battery.use_second_order_model          = false;
battery.voltage_transient_cal_norm      = 1.0; % was 1.0846 from original ALPHA 1.0 param file... possible cut and paste from NiMH file...??

battery.initial_soc_norm                = 0.99;

battery.cell.powerlimit_discharge_map_W.axis_1.signal             = 'soc_norm';
battery.cell.powerlimit_discharge_map_W.axis_1.breakpoints        = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.powerlimit_discharge_map_W.table                     = [2310 2322 2349 2373 2409 2436 2460 2496 2508 2505];
                                                       
battery.cell.powerlimit_charge_map_W.axis_1.signal                = 'soc_norm';
battery.cell.powerlimit_charge_map_W.axis_1.breakpoints           = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.powerlimit_charge_map_W.table                        = [3153 3132 3027 2925 2883 2838 2676 2514 2235 2094];
                                                       
battery.open_circuit_voltage_map_discharge_V.axis_1.signal        = 'soc_norm';
battery.open_circuit_voltage_map_discharge_V.axis_1.breakpoints   = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768 0.867 1];
battery.open_circuit_voltage_map_discharge_V.table                = [11.85, 11.93, 12.07, 12.2, 12.34, 12.46, 12.58, 12.65, 12.73, 12.88, 13.23];

battery.open_circuit_voltage_map_charge_V.axis_1.signal           = 'soc_norm';
battery.open_circuit_voltage_map_charge_V.axis_1.breakpoints      = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768 0.867 1];
battery.open_circuit_voltage_map_charge_V.table                   = [11.85, 11.93, 12.07, 12.2, 12.34, 12.46, 12.58, 12.65, 12.73, 12.88, 13.23];

battery.transient_R_discharge_short_term_Ohms.axis_1.signal       = 'soc_norm';
battery.transient_R_discharge_short_term_Ohms.axis_1.breakpoints  = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.transient_R_discharge_short_term_Ohms.table               = [0.0473, 0.0326, 0.0264, 0.0248, 0.0239, 0.0256, 0.0296, 0.0320, 0.0325];

battery.transient_R_charge_short_term_Ohms.axis_1.signal          = 'soc_norm';
battery.transient_R_charge_short_term_Ohms.axis_1.breakpoints     = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.transient_R_charge_short_term_Ohms.table                  = [0.0473, 0.0326, 0.0264, 0.0248, 0.0239, 0.0256, 0.0296, 0.0320, 0.0325];

battery.transient_R_discharge_long_term_Ohms.axis_1.signal        = 'soc_norm';
battery.transient_R_discharge_long_term_Ohms.axis_1.breakpoints   = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.transient_R_discharge_long_term_Ohms.table                = [0.0473, 0.0326, 0.0264, 0.0248, 0.0239, 0.0256, 0.0296, 0.0320, 0.0325];

battery.transient_R_charge_long_term_Ohms.axis_1.signal           = 'soc_norm';
battery.transient_R_charge_long_term_Ohms.axis_1.breakpoints      = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.transient_R_charge_long_term_Ohms.table                   = [0.0473, 0.0326, 0.0264, 0.0248, 0.0239, 0.0256, 0.0296, 0.0320, 0.0325];

battery.resistance_map_discharge_Ohms.axis_1.signal               = 'soc_norm';
battery.resistance_map_discharge_Ohms.axis_1.breakpoints          = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.resistance_map_discharge_Ohms.table                       = [0.0313, 0.0209, 0.0147, 0.0126, 0.0105, 0.0103, 0.0099, 0.0102, 0.0095];

battery.resistance_map_charge_Ohms.axis_1.signal                  = 'soc_norm';
battery.resistance_map_charge_Ohms.axis_1.breakpoints             = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.resistance_map_charge_Ohms.table                          = [0.0313, 0.0209, 0.0147, 0.0126, 0.0105, 0.0103, 0.0099, 0.0102, 0.0095];

battery.transient_C_discharge_short_term_Farads.axis_1.signal      = 'soc_norm';
battery.transient_C_discharge_short_term_Farads.axis_1.breakpoints = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.transient_C_discharge_short_term_Farads.table              = [217.8, 308.1, 369.9, 420.3, 480.1, 505.5, 495.3, 504.8, 538.2];

battery.transient_C_charge_short_term_Farads.axis_1.signal        = 'soc_norm';
battery.transient_C_charge_short_term_Farads.axis_1.breakpoints   = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.transient_C_charge_short_term_Farads.table                = [217.8, 308.1, 369.9, 420.3, 480.1, 505.5, 495.3, 504.8, 538.2];

battery.transient_C_discharge_long_term_Farads.axis_1.signal      = 'soc_norm';
battery.transient_C_discharge_long_term_Farads.axis_1.breakpoints = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.transient_C_discharge_long_term_Farads.table              = [217.8, 308.1, 369.9, 420.3, 480.1, 505.5, 495.3, 504.8, 538.2];

battery.transient_C_charge_long_term_Farads.axis_1.signal         = 'soc_norm';
battery.transient_C_charge_long_term_Farads.axis_1.breakpoints    = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.transient_C_charge_long_term_Farads.table                 = [217.8, 308.1, 369.9, 420.3, 480.1, 505.5, 495.3, 504.8, 538.2];

battery.charge_efficiency_map_norm.axis_1.signal                  = 'soc_norm';
battery.charge_efficiency_map_norm.axis_1.breakpoints             = [0 0.8 0.85 0.9 1];
battery.charge_efficiency_map_norm.table                          = 0.7071*[0.99 0.99 0.99 0.98 0.97];

%%
battery.temperature_power_derate_index_temp_degC  = [-30 -20 -10 0 10 20 30 40 50 55];
battery.temperature_power_discharge_derate_norm   = [0.1139 0.3454 0.5528 0.7314 0.8763 0.9828 1.046 1.0611 1.0233 0.1139];
battery.temperature_power_charge_derate_norm      = [0.027 0.09675 0.1665 0.4031 0.6776 0.9351 1.1206 1.179 1.0554 0.027];

battery.discharge_derate_soc_norm  = [0.25 0.28];
battery.charge_derate_soc_norm     = [0.92 0.95];
battery.thermal.initial_temp_degC  = 20.0;

battery.thermal.pack_mass_kg                           = 3.9 * battery.num_cells;
battery.thermal.specific_heat_capacity_JpkgK           = 3960;
battery.thermal.heat_transfer_coefficient_Wpm2K        = 10.5 * 0.3; % Base * hrate_cal
battery.thermal.pack_heat_transfer_area_m2             = 0.3078 * battery.num_cells;

end