
if exist('REVS','var') && REVS.verbose  disp(['Loading ' mfilename]); end

electric = class_REVS_electric(engine);
electric.name = mfilename;

electric.matrix_vintage = enum_matrix_vintage.past;

electric.battery = battery_lead_acid_flooded_41Ah();

%% Starter and Alternator Specs
electric.starter.min_voltage_V              = 6;
electric.starter.cranking_speed_radps       = 300 * unit_convert.rpm2radps;
electric.starter.efficiency_norm            = 0.5;
electric.starter.inertia_kgm2               = 0.0;
electric.starter.max_torque_Nm              = 75;

electric.alternator.regen_enable            = false;
electric.alternator.target_voltage_V        = interp1(electric.battery.open_circuit_voltage_map_charge_V.axis_1.breakpoints, electric.battery.open_circuit_voltage_map_charge_V.table(1,:), electric.battery.initial_soc_norm);
electric.alternator.inertia_kgm2            = 0;
electric.alternator.efficiency_norm         = 0.65;
electric.alternator.max_current_A           = 200;
