% ALPHA ENGINE DEFINITION
% Generated 29-Sep-2021 15:01:54

% SUGGESTED CITATION:
% 2018 Toyota 2.5L A25A-FKS Engine Tier 3 Fuel - ALPHA Map Package. Version 2021-09. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2021.


% Constructor
engine = class_REVS_engine();
engine.name =  '2018 Toyota 2.5L A25A-FKS Engine Tier 3 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.487; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  13; 
engine.bore_mm =  87.5; 
engine.stroke_mm =  103.4; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     84.508842381565429	;     104.06526760511444	;     105.06526760511444	;     120.99844105301089	;     139.00670110402751	;     157.05114274611151	;     181.15851237259469	;     211.38998280647132	;     265.49125312822645	;     313.85974433895962	;     423.00797082335708	;     470.84970760835927	;     523.59877559829886	;     691.15038378975441	;     725.70790297924214	;     760.26542216872997		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     108.20000000000000	;     133.43199071616763	;     158.37904191616764	;     180.67999999999998	;     186.56054054054047	;     194.83088235294122	;     198.77272727272725	;     212.66820512820510	;     220.42264150943393	;     219.29032258064515	;     233.80952380952388	;     236.01546391752564	;     249.47051199999999	;     219.02191368246190	;     187.73306887068165	;    0.00000000000000000		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     138.85839528866885	;     265.46457922833753	;     373.95424553230504	;     518.78166686279451	;     760.26542216872997		]; 
engine.closed_throttle_torque_Nm = [	    -15.809481808158766	;    -22.899999999999999	;    -25.899999999999999	;    -30.600000000000001	;    -42.299999999999997	;    -54.630871003307611		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     40.762164680327558	;     81.524329360655116	;     117.50576634052098	;     138.86333881584747	;     156.96349128441210	;     181.06021860244829	;     211.23458327916586	;     265.46934230094655	;     313.74723459107747	;     374.05468341626522	;     422.28847961695163	;     470.53860674269447	;     518.79567960255429	;     567.04234327756308	;     603.42091616524067	;     681.84316916698526	;     760.26542216872997		]; 
engine.fuel_map_torque_Nm = [	    -57.362414553472995	;    -42.783707276736493	;    -28.204999999999998	;    -12.619166666666665	;     2.9666666666666668	;     12.718421052631580	;     28.766666666666666	;     40.812500000000000	;     54.439999999999998	;     63.635277777777773	;     72.830555555555549	;     88.879999999999995	;     103.90000000000001	;     114.67222222222222	;     128.53333333333333	;     135.84999999999999	;     149.44604316546761	;     159.71467160604487	;     169.98330004662211	;     180.67999999999998	;     185.18837837837836	;     196.89281344454776	;     209.67081272319996	;     225.33823245652508	;     243.64113502826254	;     261.94403760000000		]; 
engine.fuel_map_gps = [
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	;
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.075515823001003915	   0.14439250308777890	   0.29189302870451861	   0.43854519736568676	;
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.046866010552755751	   0.12523324215082329	   0.22927203923803322	   0.36583678363543837	   0.50193197946879131	   0.60182076309357624	   0.81070322184829169	    1.0169708830177011	;
   0.00000000000000000	  0.029288895106228174	  0.062116988866782588	  0.086155784694228854	  0.099122134959208852	   0.11005373212602988	   0.12483409874561904	   0.14708759620070472	   0.20063173479794921	   0.26929336864280556	   0.37987296857710717	   0.49734995425784922	   0.63818127213299747	   0.79748412111714262	   0.96623269687979096	    1.0946449503935722	    1.3693014875051721	    1.6379127019145594	;
 0.0082328238214928792	  0.078209434195317867	   0.14863342218663028	   0.20659089468477626	   0.23560923982870383	   0.25987658153117538	   0.29282907134937891	   0.33755865107291549	   0.43274883485682997	   0.54080605809719351	   0.70878724231819568	   0.86764303432343937	    1.0456727663530132	    1.2399798436964371	    1.4450247648881671	    1.6016517215703581	    1.9367847655327022	    2.2641130813830435	;
  0.014524687213696545	  0.098082799451069805	   0.18197376871558735	   0.25469861798458160	   0.29894301035406429	   0.33658574635718935	   0.38621049580389549	   0.44899433265722855	   0.57347507197277980	   0.70681277520394448	   0.91157315050746823	    1.0964037460961551	    1.2949686489095729	    1.5151855859236949	    1.7492859551972821	    1.9252302208995458	    2.2962821966729403	    2.6600113905158893	;
  0.023598569201266833	   0.13166107653730103	   0.24119641255322063	   0.33715119540382366	   0.39833703810309168	   0.45222031264038909	   0.52488692296936701	   0.61584125365987796	   0.79721777785773762	   0.97117853818790023	    1.2377441834446301	    1.4684089965309819	    1.6929441515314219	    1.9606854189687972	    2.2552909166428701	    2.4630166372593627	    2.8945841023260015	    3.3217861325606002	;
  0.032922426550410694	   0.16170928712804170	   0.28937997244803920	   0.40555341236081544	   0.47933786396504147	   0.54305022137974979	   0.62916264175191039	   0.73957684439909455	   0.95433575726676900	    1.1684055287858770	    1.4675479096940744	    1.7271312099964493	    2.0016594158427035	    2.2932501548668038	    2.6176489655756310	    2.8559458166826799	    3.3484948679370605	    3.8340839486780278	;
  0.045184904436814728	   0.20306670211274822	   0.36243989514066399	   0.49722949379773879	   0.58101172708211613	   0.65331572181961994	   0.75247237507263498	   0.88228696985547017	    1.1396211830782528	    1.3925837766494054	    1.7400510050372049	    2.0408873367137810	    2.3542789232800967	    2.6859194028640756	    3.0359219575628100	    3.3017226300334990	    3.8692399744282646	    4.4336290664320828	;
  0.055461070755563779	   0.22769337093984546	   0.39875440929097061	   0.54992970037234767	   0.64397976189200989	   0.72500995810137103	   0.83582672135135061	   0.98158256168243052	    1.2745961323145545	    1.5383740447307601	    1.9066550220765330	    2.2527103690441992	    2.5918720297448212	    2.9470816058694944	    3.3231295511987269	    3.6083920768983799	    4.2285731760069023	    4.8526884498213487	;
  0.066643910866760095	   0.25316570231515617	   0.43873122458845537	   0.60320778402426756	   0.70671011442539589	   0.79517551795371999	   0.91821511892547025	    1.0820890601334940	    1.4088041166245440	    1.6735784595137115	    2.0814990587896496	    2.4703301552461099	    2.8259888205502421	    3.2045946352743950	    3.6115183852030053	    3.9186325066270440	    4.5950365394510957	    5.2829927843619053	;
  0.090097769659157986	   0.30526431643493857	   0.51619811957915196	   0.69622430032522820	   0.81369153170434105	   0.91865110030675068	    1.0632325063707015	    1.2544910294375011	    1.6175188376293559	    1.9254271491268624	    2.3963341804946476	    2.8189018003995376	    3.2301489045058260	    3.6605068793498146	    4.1165666772923117	    4.4709984114341657	    5.2643067836963455	    6.0764737272833749	;
   0.12452281503791973	   0.36369892517199404	   0.60063803857529208	   0.79614028134625880	   0.92466130608891983	    1.0393665213867676	    1.1990400842123154	    1.4088985066807509	    1.8087909238879849	    2.1720235627975084	    2.6772933338174916	    3.1278090960200586	    3.5946536515666345	    4.0823681073153395	    4.6124548853342775	    5.0249165950866557	    5.9467229610357428	    6.8886702315712283	;
   0.16785990366051856	   0.40858631207557017	   0.65081823807010997	   0.86602589061044111	    1.0056535152584294	    1.1287757059395658	    1.2994335595156599	    1.5240716884461780	    1.9563020230704589	    2.3413552330778558	    2.8752177211101726	    3.3611042989740465	    3.8680625484506024	    4.3905938510619809	    4.9888819031574778	    5.4480206446930302	    6.4676556258815934	    7.5069341314275722	;
   0.26015113557085262	   0.49229445302036651	   0.73351955685135095	   0.96554949839646365	    1.1143750333960174	    1.2458574773530851	    1.4272641143548397	    1.6651039234298204	    2.1273287805057426	    2.5544409901929455	    3.1304403474852531	    3.6685217503960148	    4.2336872348887553	    4.8403056386361332	    5.5059068917908407	    6.0248688639555432	    7.1753533581510043	    8.3428848038068626	;
   0.32907188657813424	   0.55902663545225151	   0.79886133269313941	    1.0338736533196646	    1.1825279616732718	    1.3150911868438835	    1.4994375901709116	    1.7474594273736288	    2.2245286202704713	    2.6708096177239282	    3.2624371863785995	    3.8207600514003390	    4.4212867450815940	    5.0785093103470560	    5.7922359879097609	    6.3449688960560442	    7.5625940820673714	    8.7977890467116211	;
   0.49138878910479850	   0.73022091250939414	   0.96865552215557627	    1.2047960476780033	    1.3558088713007792	    1.4859769505691824	    1.6655875553076691	    1.9228089347456994	    2.4262326882770231	    2.8930401763036144	    3.5234387907810722	    4.1102386650552987	    4.7684137091161860	    5.5130419795289543	    6.3452520357243598	    6.9642355618091907	    8.3044624436025796	    9.6646946648021181	;
   0.62732199501601371	   0.90123978779855929	    1.1780685167834464	    1.4115127267812908	    1.5511886959286243	    1.6768934554325106	    1.8569046366588382	    2.1019829030088921	    2.5912902531826800	    3.0734473889519425	    3.7399192936525325	    4.3641134487254352	    5.0562992953074088	    5.8418015440533591	    6.7664840456204072	    7.4375545594291692	    8.8805188236315740	    10.332869594323183	;
   0.76211781566392112	    1.0700455795450143	    1.3656230237894817	    1.6003934482195750	    1.7463262371147097	    1.8812969271445732	    2.0800039423844012	    2.3244097631985139	    2.7858803160209167	    3.2680451631017102	    3.9832947381472907	    4.6559035409419023	    5.3847618096341883	    6.2238561502057799	    7.1861454228937713	    7.9146750932845853	    9.4667103922044387	    11.005301944715132	;
   0.88647195718638760	    1.2270157816142251	    1.5649567905316497	    1.8532290383846985	    1.9966396578347618	    2.1280443517159777	    2.3293963293007827	    2.5807438852531703	    3.0413073436811175	    3.5235630114991494	    4.2537155767472337	    4.9989656251203378	    5.7839279987957255	    6.6826154497419239	    7.6769875561191618	    8.4432011606256463	    10.088525440179696	    11.703537421794914	;
   0.93470783239568112	    1.2871695283400084	    1.6363051326196749	    1.9246467255303032	    2.0814359817764188	    2.2239012815366639	    2.4291547718911972	    2.6945599314101889	    3.1683375257950894	    3.6569135592958952	    4.3711837429504543	    5.1427598883720771	    5.9530263928031442	    6.8833192975259117	    7.8968312358907982	    8.6769074790384089	    10.353252822689948	    11.995972400265947	;
    1.0475793194043899	    1.4255030384833587	    1.7945470174476092	    2.1081467789484809	    2.2979934517018727	    2.4659640332051866	    2.7116071789372329	    3.0233363784800575	    3.5693651977078522	    4.0932044989530425	    4.7042448410560613	    5.4903833257380041	    6.3914042165952409	    7.4256275341580489	    8.5034018386747956	    9.3153055773783393	    11.047548931641636	    12.748644063784015	;
    1.1459333794348772	    1.5656403986001999	    1.9892151128025246	    2.3846047936826209	    2.6374725844360274	    2.8614415079082498	    3.1748282209913588	    3.5859235894656853	    4.2107457659986647	    4.8164295623815345	    5.1922409435678363	    5.9762100273941208	    6.9577425387443377	    8.0859763471037400	    9.2234205015812343	    10.053393657377708	    11.810221008312338	    13.551693421745139	;
    1.2653410353642549	    1.7727030429992912	    2.2914980490580454	    2.7683671077396315	    3.0576287950320142	    3.3040167458701144	    3.6308181820540888	    4.0257851328724845	    4.6053038496912473	    5.0650386504820215	    5.9947775639187864	    6.8214227431186494	    7.7639502304705585	    8.9621785182122533	    10.083984532842280	    10.943207364530419	    12.723084441071405	    14.508632810645937	;
    1.4584248541873837	    2.0488573330808921	    2.6396884092657231	    3.1575129659895520	    3.4607734840054736	    3.7153411325823198	    4.0497645188448779	    4.4588553590588429	    5.1663498456455423	    5.8437913975647131	    6.8682816339596924	    7.7374273219136578	    8.5918387806776195	    9.7270711819446998	    10.912625117159598	    11.807360324707666	    13.705887742075948	    15.594466046719344	;
    1.6844471628657263	    2.3195333672157048	    2.9510216268355118	    3.5032860454916923	    3.8296195562697690	    4.1059033807685603	    4.4739657286267507	    4.9376534731885586	    5.7950514360765535	    6.6052280827816565	    7.6794132493209926	    8.5904053611808813	    9.5574595721308029	    10.608736540945893	    11.742596780653745	    12.630313245500837	    14.627909931167780	    16.658351561772189	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 26781');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	      61.784655520599259	    61.784655520599259		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
