
if exist('REVS','var') && REVS.verbose disp(['Loading ' mfilename]); end

controls = class_REVS_P2_control();

controls.start_stop_warmup_condition = '(@cycle_pos_secs >= 0)'; 
controls.start_stop_off_delay_secs = 0;

controls.hot_soak_warmup_start_condition = '( (sim_config.controls_hot_soak_start_enable==1 && (@cycle_pos_secs < 1370 || @cycle_pos_secs > 1505)) || ( sim_config.controls_hot_soak_start_enable==0 && @cycle_pos_secs >= 0) )';% && (@cycle_pos_secs < 1370 || @cycle_pos_secs > 1505))';

controls.battery_hyst_soc_norm = 0.01;

controls.battery_min_soc_norm = 0.115;
controls.battery_loadlevel_soc_norm = 0.1525;

min_bsfc_curve = engine.min_bsfc_curves();
controls.engine_min_bsfc_speed_radps = min_bsfc_curve.speed_radps;
controls.engine_min_bsfc_torque_Nm = min_bsfc_curve.torque_Nm;

controls.regen_speed_limit_mps  = [4.5 10 11] * unit_convert.mph2mps;
controls.regen_speed_limit_norm = [0 0.99 1];

controls.regen_torque_limit_soc_norm  = [0.95 1.0];
controls.regen_torque_limit_norm = [1   0];

controls.motor_torque_limit_soc_norm  = [0.10 0.11];
controls.motor_torque_limit_norm      = [0    1];

controls.motor_creep_speed_mps = [0 0.05 0.1 4.5] * unit_convert.mph2mps;
controls.motor_creep_torque_norm = [0 0 0.08 0];

controls.max_EV_speed_mps = 80 * unit_convert.mph2mps;

controls.engine_min_on_time_secs = 3;
controls.engine_off_delay_secs = 1;
controls.engine_min_off_time_secs = 10;

% P2 clutch
electric.disconnect_clutch = class_REVS_clutch();
electric.disconnect_clutch.engage_duration_secs = 0.1;
electric.disconnect_clutch.torque_capacity_Nm = 1000;
