
if exist('REVS','var') && REVS.verbose  disp(['Loading ' mfilename]); end

transmission = class_REVS_AT_core_transmission;
transmission.variant =  'automatic transmission system'; 
transmission.matrix_vintage = enum_matrix_vintage.present;
transmission.name =  'TRX12_FWD_P2_Hybrid'; 
transmission.rated_torque_Nm =  279; 
transmission.gear = class_REVS_gearbox;
transmission.gear.type = enum_transmission_type.automatic;
transmission.gear.number = [      0.0000000000000000     1.0000000000000000     2.0000000000000000     3.0000000000000000     4.0000000000000000     5.0000000000000000     6.0000000000000000  ]; 
transmission.gear.ratio = [      0.0000000000000000     4.6390000000000002     2.8260000000000001     1.8410000000000000     1.3859999999999999     1.0000000000000000    0.77200000000000002  ]; 
transmission.gear.inertia_kgm2 = [      0.0000000000000000   0.014736905713208593   0.014736905713208593   0.014736905713208593   0.014736905713208593   0.014736905713208593   0.014736905713208593  ]; 
transmission.gear.efficiency_norm = class_REVS_dynamic_lookup;
transmission.gear.efficiency_norm.axis_1.signal =  'trans_temp_degC'; 
transmission.gear.efficiency_norm.axis_1.breakpoints = [      5.0000000000000000     40.000000000000000  ]; 
transmission.gear.efficiency_norm.axis_2.signal =  'gb_spd_in_radps'; 
transmission.gear.efficiency_norm.axis_2.breakpoints = [      52.359877559829883     78.539816339744831     104.71975511965977     130.89969389957471     157.07963267948966     183.25957145940458     209.43951023931953     261.79938779914943     314.15926535897933     418.87902047863906     523.59877559829886  ]; 
transmission.gear.efficiency_norm.axis_3.signal =  'gb_sync_trq_out_Nm'; 
transmission.gear.efficiency_norm.axis_3.breakpoints = [      25.000000000000000     50.000000000000000     75.000000000000000     100.00000000000000     150.00000000000000     200.00000000000000     250.00000000000000  ]; 
transmission.gear.efficiency_norm.axis_4.signal =  'gb_cmd_gear'; 
transmission.gear.efficiency_norm.axis_4.breakpoints = [      0.0000000000000000     1.0000000000000000     2.0000000000000000     3.0000000000000000     4.0000000000000000     5.0000000000000000     6.0000000000000000  ]; 
transmission.gear.efficiency_norm.table = [];
transmission.gear.efficiency_norm.table(:,:,1,1) = [
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ;
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,2,1) = [
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ;
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,3,1) = [
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ;
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,4,1) = [
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ;
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,5,1) = [
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ;
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,6,1) = [
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ;
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,7,1) = [
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ;
    1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,1,2) = [
   0.71889999999999998    0.73760000000000003    0.74580000000000002    0.75660000000000005    0.75810000000000000    0.74819999999999998    0.75529999999999997    0.75949999999999995    0.76339999999999997    0.75600000000000001    0.74429999999999996 ;
   0.93879999999999997    0.96170000000000000    0.96589999999999998    0.97219999999999995    0.97589999999999999    0.97609999999999997    0.97740000000000005    0.97980000000000000    0.97299999999999998    0.97509999999999997    0.96870000000000001 ]; 
transmission.gear.efficiency_norm.table(:,:,2,2) = [
   0.83130000000000004    0.84470000000000001    0.85060000000000002    0.85489999999999999    0.85499999999999998    0.85150000000000003    0.85509999999999997    0.85680000000000001    0.86460000000000004    0.85870000000000002    0.85189999999999999 ;
   0.93269999999999997    0.94969999999999999    0.95530000000000004    0.96260000000000001    0.96340000000000003    0.96360000000000001    0.96460000000000001    0.96660000000000001    0.96430000000000005    0.96679999999999999    0.96589999999999998 ]; 
transmission.gear.efficiency_norm.table(:,:,3,2) = [
   0.86550000000000005    0.87670000000000003    0.88249999999999995    0.88570000000000004    0.88460000000000005    0.88219999999999998    0.88770000000000004    0.88910000000000000    0.89270000000000005    0.88560000000000005    0.88729999999999998 ;
   0.92679999999999996    0.94540000000000002    0.94930000000000003    0.95589999999999997    0.95740000000000003    0.95860000000000001    0.95920000000000005    0.96120000000000005    0.95879999999999999    0.96120000000000005    0.96130000000000004 ]; 
transmission.gear.efficiency_norm.table(:,:,4,2) = [
   0.88000000000000000    0.89129999999999998    0.89790000000000003    0.90059999999999996    0.90149999999999997    0.90320000000000000    0.90100000000000002    0.90420000000000000    0.90890000000000004    0.90280000000000005    0.90380000000000005 ;
   0.92469999999999997    0.94069999999999998    0.94610000000000005    0.95360000000000000    0.95269999999999999    0.95460000000000000    0.95540000000000003    0.95840000000000003    0.95669999999999999    0.95820000000000005    0.95750000000000002 ]; 
transmission.gear.efficiency_norm.table(:,:,5,2) = [
   0.89239999999999997    0.90149999999999997    0.90739999999999998    0.91100000000000003    0.91320000000000001    0.91500000000000004    0.91569999999999996    0.91679999999999995    0.92210000000000003    0.92120000000000002    0.92100000000000004 ;
   0.92110000000000003    0.93230000000000002    0.93889999999999996    0.94630000000000003    0.94669999999999999    0.94850000000000001    0.95060000000000000    0.95220000000000005    0.95060000000000000    0.95209999999999995    0.95350000000000001 ]; 
transmission.gear.efficiency_norm.table(:,:,6,2) = [
   0.91149999999999998    0.92020000000000002    0.92420000000000002    0.92820000000000003    0.93110000000000004    0.93289999999999995    0.93650000000000000    0.93550000000000000    0.94189999999999996    0.94689999999999996    0.94689999999999996 ;
   0.92369999999999997    0.93340000000000001    0.94189999999999996    0.94950000000000001    0.95120000000000005    0.95320000000000005    0.95689999999999997    0.95750000000000002    0.95620000000000005    0.95830000000000004    0.96330000000000005 ]; 
transmission.gear.efficiency_norm.table(:,:,7,2) = [
   0.93340000000000001    0.94230000000000003    0.94379999999999997    0.94810000000000005    0.95160000000000000    0.95330000000000004    0.95960000000000001    0.95679999999999998    0.96430000000000005    0.97540000000000004    0.97629999999999995 ;
   0.92889999999999995    0.93840000000000001    0.94889999999999997    0.95679999999999998    0.96009999999999995    0.96220000000000006    0.96770000000000000    0.96750000000000003    0.96650000000000003    0.96950000000000003    0.97870000000000001 ]; 
transmission.gear.efficiency_norm.table(:,:,1,3) = [
   0.74750000000000005    0.75460000000000005    0.74639999999999995    0.75760000000000005    0.75990000000000002    0.74660000000000004    0.75729999999999997    0.76759999999999995    0.78039999999999998    0.76300000000000001    0.74880000000000002 ;
   0.93659999999999999    0.95889999999999997    0.96230000000000004    0.96699999999999997    0.97330000000000005    0.97030000000000005    0.96819999999999995    0.97460000000000002    0.96379999999999999    0.97099999999999997    0.96350000000000002 ]; 
transmission.gear.efficiency_norm.table(:,:,2,3) = [
   0.84640000000000004    0.84550000000000003    0.85299999999999998    0.85729999999999995    0.85970000000000002    0.85350000000000004    0.85870000000000002    0.86029999999999995    0.86880000000000002    0.85819999999999996    0.85709999999999997 ;
   0.93179999999999996    0.94879999999999998    0.95409999999999995    0.96160000000000001    0.96079999999999999    0.96209999999999996    0.96319999999999995    0.96519999999999995    0.96220000000000006    0.96579999999999999    0.96370000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,3,3) = [
   0.87609999999999999    0.88190000000000002    0.88460000000000005    0.88580000000000003    0.88500000000000001    0.88210000000000000    0.88780000000000003    0.88890000000000002    0.89449999999999996    0.88360000000000005    0.88690000000000002 ;
   0.92610000000000003    0.94499999999999995    0.94860000000000000    0.95520000000000005    0.95699999999999996    0.95789999999999997    0.95899999999999996    0.96050000000000002    0.95840000000000003    0.96170000000000000    0.96050000000000002 ]; 
transmission.gear.efficiency_norm.table(:,:,4,3) = [
   0.88849999999999996    0.89449999999999996    0.89790000000000003    0.90069999999999995    0.90139999999999998    0.90290000000000004    0.90380000000000005    0.90410000000000001    0.90920000000000001    0.90280000000000005    0.90339999999999998 ;
   0.92400000000000004    0.94030000000000002    0.94550000000000001    0.95299999999999996    0.95179999999999998    0.95420000000000005    0.95530000000000004    0.95820000000000005    0.95679999999999998    0.95820000000000005    0.95699999999999996 ]; 
transmission.gear.efficiency_norm.table(:,:,5,3) = [
   0.89859999999999995    0.90169999999999995    0.90759999999999996    0.91130000000000000    0.91510000000000002    0.91490000000000005    0.91600000000000004    0.91669999999999996    0.92240000000000000    0.92120000000000002    0.92230000000000001 ;
   0.92110000000000003    0.93210000000000004    0.93869999999999998    0.94610000000000005    0.94630000000000003    0.94820000000000004    0.94840000000000002    0.95189999999999997    0.95079999999999998    0.95209999999999995    0.95320000000000005 ]; 
transmission.gear.efficiency_norm.table(:,:,6,3) = [
   0.89480000000000004    0.90510000000000002    0.90980000000000005    0.91479999999999995    0.91530000000000000    0.91839999999999999    0.92130000000000001    0.92359999999999998    0.92849999999999999    0.92669999999999997    0.92789999999999995 ;
   0.91100000000000003    0.92730000000000001    0.93030000000000002    0.93520000000000003    0.94140000000000001    0.94259999999999999    0.94369999999999998    0.94579999999999997    0.94479999999999997    0.94750000000000001    0.94960000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,7,3) = [
   0.89100000000000001    0.90990000000000004    0.91420000000000001    0.92069999999999996    0.91800000000000004    0.92430000000000001    0.92930000000000001    0.93330000000000002    0.93769999999999998    0.93559999999999999    0.93740000000000001 ;
   0.90259999999999996    0.92479999999999996    0.92510000000000003    0.92830000000000001    0.94069999999999998    0.94120000000000004    0.94320000000000004    0.94420000000000004    0.94320000000000004    0.94799999999999995    0.95169999999999999 ]; 
transmission.gear.efficiency_norm.table(:,:,1,4) = [
   0.77420000000000000    0.77270000000000005    0.76710000000000000    0.76919999999999999    0.75570000000000004    0.76180000000000003    0.76000000000000001    0.77639999999999998    0.73860000000000003    0.75590000000000002    0.77839999999999998 ;
   0.95750000000000002    0.95909999999999995    0.95809999999999995    0.95809999999999995    0.95770000000000000    0.95650000000000002    0.95589999999999997    0.95169999999999999    0.96409999999999996    0.97150000000000003    0.96460000000000001 ]; 
transmission.gear.efficiency_norm.table(:,:,2,4) = [
   0.86829999999999996    0.86929999999999996    0.86570000000000003    0.87119999999999997    0.86529999999999996    0.86399999999999999    0.86839999999999995    0.86680000000000001    0.86350000000000005    0.86860000000000004    0.87250000000000005 ;
   0.95469999999999999    0.95820000000000005    0.95970000000000000    0.96020000000000005    0.96040000000000003    0.96170000000000000    0.96379999999999999    0.95899999999999996    0.96130000000000004    0.96779999999999999    0.96689999999999998 ]; 
transmission.gear.efficiency_norm.table(:,:,3,4) = [
   0.89749999999999996    0.89990000000000003    0.89659999999999995    0.90100000000000002    0.90039999999999998    0.89939999999999998    0.89859999999999995    0.90029999999999999    0.89570000000000005    0.89700000000000002    0.89900000000000002 ;
   0.94979999999999998    0.95599999999999996    0.95820000000000005    0.95850000000000002    0.95950000000000002    0.96099999999999997    0.96370000000000000    0.96140000000000003    0.96419999999999995    0.96709999999999996    0.96670000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,4,4) = [
   0.90420000000000000    0.91390000000000005    0.91039999999999999    0.91610000000000003    0.91659999999999997    0.91490000000000005    0.91469999999999996    0.91849999999999998    0.91010000000000002    0.91439999999999999    0.91330000000000000 ;
   0.94820000000000004    0.95309999999999995    0.95640000000000003    0.95840000000000003    0.95940000000000003    0.96040000000000003    0.96189999999999998    0.96199999999999997    0.96470000000000000    0.96819999999999995    0.96599999999999997 ]; 
transmission.gear.efficiency_norm.table(:,:,5,4) = [
   0.91779999999999995    0.92410000000000003    0.92420000000000002    0.93020000000000003    0.93179999999999996    0.93120000000000003    0.93110000000000004    0.93320000000000003    0.93169999999999997    0.93179999999999996    0.93300000000000005 ;
   0.94479999999999997    0.94930000000000003    0.95209999999999995    0.95509999999999995    0.95579999999999998    0.95879999999999999    0.95999999999999996    0.96050000000000002    0.96230000000000004    0.96479999999999999    0.96470000000000000 ]; 
transmission.gear.efficiency_norm.table(:,:,6,4) = [
   0.92210000000000003    0.92910000000000004    0.93100000000000005    0.93559999999999999    0.93700000000000006    0.93830000000000002    0.93759999999999999    0.94010000000000005    0.94030000000000002    0.93940000000000001    0.93969999999999998 ;
   0.94199999999999995    0.94740000000000002    0.95240000000000002    0.95450000000000002    0.95520000000000005    0.95920000000000005    0.95979999999999999    0.96120000000000005    0.96389999999999998    0.96460000000000001    0.96509999999999996 ]; 
transmission.gear.efficiency_norm.table(:,:,7,4) = [
   0.92449999999999999    0.93089999999999995    0.93369999999999997    0.93779999999999997    0.94020000000000004    0.94030000000000002    0.94140000000000001    0.94430000000000003    0.94440000000000002    0.94510000000000005    0.94399999999999995 ;
   0.94020000000000004    0.94520000000000004    0.95060000000000000    0.95260000000000000    0.95430000000000004    0.95679999999999998    0.95899999999999996    0.96109999999999995    0.96299999999999997    0.96519999999999995    0.96450000000000002 ]; 
transmission.gear.efficiency_norm.table(:,:,1,5) = [
   0.76310000000000000    0.77539999999999998    0.76149999999999995    0.77110000000000001    0.77249999999999996    0.76549999999999996    0.76410000000000000    0.78439999999999999    0.73990000000000000    0.79649999999999999    0.91949999999999998 ;
   0.96570000000000000    0.96960000000000002    0.96860000000000002    0.96970000000000001    0.96640000000000004    0.96060000000000001    0.96579999999999999    0.97729999999999995    0.99509999999999998    0.99529999999999996    0.98740000000000006 ]; 
transmission.gear.efficiency_norm.table(:,:,2,5) = [
   0.86639999999999995    0.87390000000000001    0.86829999999999996    0.87390000000000001    0.87619999999999998    0.87170000000000003    0.86729999999999996    0.88049999999999995    0.88170000000000004    0.87919999999999998    0.87860000000000005 ;
   0.96470000000000000    0.96930000000000005    0.97009999999999996    0.97099999999999997    0.97240000000000004    0.96830000000000005    0.97099999999999997    0.97560000000000002    0.99509999999999998    0.99529999999999996    0.99650000000000005 ]; 
transmission.gear.efficiency_norm.table(:,:,3,5) = [
   0.90269999999999995    0.90710000000000002    0.90190000000000003    0.90669999999999995    0.90590000000000004    0.90520000000000000    0.90029999999999999    0.90820000000000001    0.90649999999999997    0.90410000000000001    0.90849999999999997 ;
   0.96350000000000002    0.96689999999999998    0.96840000000000004    0.96950000000000003    0.97040000000000004    0.96909999999999996    0.97030000000000005    0.97470000000000001    0.98750000000000004    0.98619999999999997    0.98839999999999995 ]; 
transmission.gear.efficiency_norm.table(:,:,4,5) = [
   0.91300000000000003    0.91830000000000001    0.91900000000000004    0.92330000000000001    0.92390000000000005    0.92110000000000003    0.92279999999999995    0.92689999999999995    0.92230000000000001    0.92169999999999996    0.92579999999999996 ;
   0.96150000000000002    0.96350000000000002    0.96679999999999999    0.96830000000000005    0.96980000000000000    0.96879999999999999    0.97009999999999996    0.97430000000000005    0.98290000000000000    0.98560000000000003    0.98829999999999996 ]; 
transmission.gear.efficiency_norm.table(:,:,5,5) = [
   0.92949999999999999    0.93410000000000004    0.93540000000000001    0.93910000000000005    0.94059999999999999    0.93930000000000002    0.93879999999999997    0.94169999999999998    0.94120000000000004    0.93859999999999999    0.94140000000000001 ;
   0.96020000000000005    0.96230000000000004    0.96489999999999998    0.96699999999999997    0.96740000000000004    0.96750000000000003    0.96950000000000003    0.97230000000000005    0.97760000000000002    0.97819999999999996    0.98270000000000002 ]; 
transmission.gear.efficiency_norm.table(:,:,6,5) = [
   0.93799999999999994    0.94159999999999999    0.94310000000000005    0.94669999999999999    0.94840000000000002    0.94760000000000000    0.94750000000000001    0.94920000000000004    0.94910000000000005    0.94789999999999996    0.94889999999999997 ;
   0.96070000000000000    0.96260000000000001    0.96550000000000002    0.96770000000000000    0.96919999999999995    0.96940000000000004    0.97080000000000000    0.97260000000000002    0.97570000000000001    0.97989999999999999    0.98070000000000002 ]; 
transmission.gear.efficiency_norm.table(:,:,7,5) = [
   0.94189999999999996    0.94660000000000000    0.94699999999999995    0.95009999999999994    0.95199999999999996    0.95169999999999999    0.95089999999999997    0.95350000000000001    0.95299999999999996    0.95260000000000000    0.95430000000000004 ;
   0.95989999999999998    0.96309999999999996    0.96450000000000002    0.96660000000000001    0.96830000000000005    0.96899999999999997    0.96930000000000005    0.97209999999999996    0.97370000000000001    0.97850000000000004    0.98009999999999997 ]; 
transmission.gear.efficiency_norm.table(:,:,1,6) = [
   0.77310000000000001    0.80140000000000000    0.76339999999999997    0.77520000000000000    0.78010000000000002    0.80420000000000003    0.78700000000000003    0.77890000000000004    0.76529999999999998    0.78520000000000001    0.80520000000000003 ;
   0.98540000000000005    0.97929999999999995    0.97480000000000000    0.97319999999999995    0.96630000000000005    0.99129999999999996    0.97989999999999999    0.99209999999999998    0.97640000000000005    0.99199999999999999    0.92430000000000001 ]; 
transmission.gear.efficiency_norm.table(:,:,2,6) = [
   0.86099999999999999    0.89100000000000001    0.86990000000000001    0.87419999999999998    0.88049999999999995    0.89110000000000000    0.87460000000000004    0.87939999999999996    0.88249999999999995    0.89259999999999995    0.90259999999999996 ;
   0.98029999999999995    0.97960000000000003    0.98060000000000003    0.97989999999999999    0.97719999999999996    0.98980000000000001    0.98950000000000005    0.98709999999999998    0.99050000000000005    0.99070000000000003    0.94940000000000002 ]; 
transmission.gear.efficiency_norm.table(:,:,3,6) = [
   0.90849999999999997    0.92110000000000003    0.90810000000000002    0.91000000000000003    0.92130000000000001    0.92230000000000001    0.91700000000000004    0.91639999999999999    0.91559999999999997    0.91990000000000005    0.92420000000000002 ;
   0.97789999999999999    0.97919999999999996    0.97970000000000002    0.98080000000000001    0.98009999999999997    0.98819999999999997    0.99399999999999999    0.98660000000000003    0.98960000000000004    0.98809999999999998    0.95899999999999996 ]; 
transmission.gear.efficiency_norm.table(:,:,4,6) = [
   0.92330000000000001    0.93030000000000002    0.92559999999999998    0.92840000000000000    0.93300000000000005    0.93430000000000002    0.93069999999999997    0.93179999999999996    0.93049999999999999    0.93530000000000002    0.93999999999999995 ;
   0.97819999999999996    0.97870000000000001    0.97899999999999998    0.98029999999999995    0.98060000000000003    0.98660000000000003    0.98340000000000005    0.98670000000000002    0.98770000000000002    0.98990000000000000    0.97130000000000005 ]; 
transmission.gear.efficiency_norm.table(:,:,5,6) = [
   0.93979999999999997    0.94630000000000003    0.94420000000000004    0.94640000000000002    0.94940000000000002    0.94940000000000002    0.94950000000000001    0.95030000000000003    0.93940000000000001    0.95069999999999999    0.96199999999999997 ;
   0.97640000000000005    0.97629999999999995    0.97750000000000004    0.97919999999999996    0.98050000000000004    0.98470000000000002    0.98140000000000005    0.98580000000000001    0.98690000000000000    0.98609999999999998    0.97140000000000004 ]; 
transmission.gear.efficiency_norm.table(:,:,6,6) = [
   0.94099999999999995    0.95369999999999999    0.95320000000000005    0.95489999999999997    0.95740000000000003    0.95789999999999997    0.95999999999999996    0.95669999999999999    0.95820000000000005    0.95950000000000002    0.96089999999999998 ;
   0.96860000000000002    0.97680000000000000    0.97889999999999999    0.98050000000000004    0.98060000000000003    0.98499999999999999    0.98619999999999997    0.98360000000000003    0.99190000000000000    0.98629999999999995    0.97030000000000005 ]; 
transmission.gear.efficiency_norm.table(:,:,7,6) = [
   0.94630000000000003    0.95889999999999997    0.95830000000000004    0.96009999999999995    0.96289999999999998    0.96270000000000000    0.96070000000000000    0.96279999999999999    0.96670000000000000    0.96350000000000002    0.96020000000000005 ;
   0.96840000000000004    0.97750000000000004    0.97870000000000001    0.98060000000000003    0.98150000000000004    0.98470000000000002    0.98160000000000003    0.98429999999999995    0.99460000000000004    0.98509999999999998    0.96719999999999995 ]; 
transmission.gear.efficiency_norm.table(:,:,1,7) = [
   0.77700000000000002    0.77120000000000000    0.76729999999999998    0.77920000000000000    0.76410000000000000    0.77669999999999995    0.76160000000000005    0.76600000000000001    0.76710000000000000    0.76780000000000004    0.76900000000000002 ;
   0.96870000000000001    0.96260000000000001    0.96389999999999998    0.96670000000000000    0.95389999999999997    0.96279999999999999    0.95640000000000003    0.96150000000000002    0.98829999999999996    0.92600000000000005    0.86439999999999995 ]; 
transmission.gear.efficiency_norm.table(:,:,2,7) = [
   0.87409999999999999    0.86980000000000002    0.86619999999999997    0.87319999999999998    0.86950000000000005    0.87629999999999997    0.86490000000000000    0.86339999999999995    0.85409999999999997    0.84460000000000002    0.83540000000000003 ;
   0.97019999999999995    0.96899999999999997    0.96899999999999997    0.97019999999999995    0.97280000000000000    0.97109999999999996    0.96879999999999999    0.96960000000000002    0.97929999999999995    0.94440000000000002    0.90990000000000004 ]; 
transmission.gear.efficiency_norm.table(:,:,3,7) = [
   0.90569999999999995    0.90349999999999997    0.90169999999999995    0.90600000000000003    0.90559999999999996    0.90790000000000004    0.90739999999999998    0.90280000000000005    0.88970000000000005    0.87660000000000005    0.86350000000000005 ;
   0.97009999999999996    0.96989999999999998    0.97019999999999995    0.97130000000000005    0.97219999999999995    0.97230000000000005    0.97330000000000005    0.97070000000000001    0.97699999999999998    0.95350000000000001    0.93030000000000002 ]; 
transmission.gear.efficiency_norm.table(:,:,4,7) = [
   0.92069999999999996    0.91820000000000002    0.91820000000000002    0.92149999999999999    0.91979999999999995    0.92300000000000004    0.91879999999999995    0.91130000000000000    0.91349999999999998    0.91559999999999997    0.91769999999999996 ;
   0.96879999999999999    0.96960000000000002    0.97070000000000001    0.97230000000000005    0.97199999999999998    0.97219999999999995    0.97670000000000001    0.97250000000000003    0.97240000000000004    0.94989999999999997    0.92769999999999997 ]; 
transmission.gear.efficiency_norm.table(:,:,5,7) = [
   0.93149999999999999    0.93559999999999999    0.93589999999999995    0.93789999999999996    0.93750000000000000    0.94010000000000005    0.93650000000000000    0.93420000000000003    0.92930000000000001    0.92440000000000000    0.91949999999999998 ;
   0.96370000000000000    0.96809999999999996    0.96999999999999997    0.97160000000000002    0.97209999999999996    0.97299999999999998    0.97550000000000003    0.97219999999999995    0.97419999999999995    0.96140000000000003    0.94869999999999999 ]; 
transmission.gear.efficiency_norm.table(:,:,6,7) = [
   0.93779999999999997    0.94350000000000001    0.94440000000000002    0.94510000000000005    0.94610000000000005    0.94850000000000001    0.94450000000000001    0.94430000000000003    0.94250000000000000    0.94079999999999997    0.93899999999999995 ;
   0.96199999999999997    0.96879999999999999    0.97070000000000001    0.97089999999999999    0.97270000000000001    0.97350000000000003    0.97430000000000005    0.97440000000000004    0.97640000000000005    0.96730000000000005    0.95830000000000004 ]; 
transmission.gear.efficiency_norm.table(:,:,7,7) = [
   0.93940000000000001    0.94820000000000004    0.94850000000000001    0.94960000000000000    0.95140000000000002    0.95050000000000001    0.95069999999999999    0.94850000000000001    0.94799999999999995    0.94740000000000002    0.94679999999999997 ;
   0.95879999999999999    0.96850000000000003    0.96970000000000001    0.97050000000000003    0.97299999999999998    0.97070000000000001    0.97499999999999998    0.97319999999999995    0.97560000000000002    0.96919999999999995    0.96270000000000000 ]; 
transmission.gear.common_input_inertia_kgm2 =  0.0073684528566042963; 
transmission.gear.common_output_inertia_kgm2 =  0.0073684528566042963; 
transmission.gear.input_torque_loss_Nm = class_REVS_dynamic_lookup;
transmission.gear.input_torque_loss_Nm.axis_1.signal =  'gb_cmd_gear'; 
transmission.gear.input_torque_loss_Nm.axis_1.breakpoints = [      0.0000000000000000     1.0000000000000000     2.0000000000000000     3.0000000000000000     4.0000000000000000     5.0000000000000000     6.0000000000000000  ]; 
transmission.gear.input_torque_loss_Nm.axis_2.signal =  'gb_spd_in_radps'; 
transmission.gear.input_torque_loss_Nm.axis_2.breakpoints = [      52.359877559829883     78.539816339744831     104.71975511965977     130.89969389957471     157.07963267948966     183.25957145940458     209.43951023931953     261.79938779914943     314.15926535897933     418.87902047863906     523.59877559829886  ]; 
transmission.gear.input_torque_loss_Nm.axis_3.signal =  'ctrl.gb_line_press_bar'; 
transmission.gear.input_torque_loss_Nm.axis_3.breakpoints = [      5.0000000000000000     10.000000000000000  ]; 
transmission.gear.input_torque_loss_Nm.axis_4.signal =  'trans_temp_degC'; 
transmission.gear.input_torque_loss_Nm.axis_4.breakpoints = [      0.0000000000000000     46.000000000000000  ]; 
transmission.gear.input_torque_loss_Nm.table = [];
transmission.gear.input_torque_loss_Nm.table(:,:,1,1) = [
   0.84816000000000036     1.0155600000000002    0.91512000000000038    0.69192000000000020    0.60264000000000006    0.59706000000000026    0.61380000000000035    0.70307999999999993    0.74771999999999994     1.1550600000000002     1.5903000000000005 ;
   0.84816000000000036     1.0155600000000002    0.91512000000000038    0.69192000000000020    0.60264000000000006    0.59706000000000026    0.61380000000000035    0.70307999999999993    0.74771999999999994     1.1550600000000002     1.5903000000000005 ;
    0.0000000000000000    0.47430000000000033    0.46871999999999997    0.63053999999999999    0.76446000000000014    0.84816000000000036    0.93744000000000038     1.1104200000000002     1.3057200000000000     1.6963200000000003     2.2487400000000002 ;
    1.1327400000000003     1.4229000000000001     1.3447800000000003     1.3336200000000005     1.4452199999999999     1.3671000000000002     1.4117400000000002     1.5512400000000002     1.7911800000000002     2.4886800000000000     3.3982200000000007 ;
    1.1606400000000001     1.7688600000000005     1.8358200000000002     1.8079199999999997     1.8971999999999998     2.0869199999999997     2.2599000000000000     3.0522600000000000     3.5767800000000007     6.8745600000000007     9.3744000000000014 ;
    2.1148200000000004     2.1148200000000004     1.5791400000000007     1.4284800000000004     1.4508000000000005     1.7353800000000004     1.9251000000000003     2.2766400000000009     2.8011600000000003     3.9618000000000007     5.1224400000000001 ;
    2.0701800000000001     2.3826600000000004     2.6002800000000010     2.8458000000000006     3.2252400000000003     3.5265599999999999     3.9394800000000001     4.8825000000000003     6.3109799999999998     7.7394600000000011     9.1679400000000015 ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,2,1) = [
    2.2710599999999999     2.8458000000000006     2.4049800000000001     2.2543200000000003     2.0925000000000007     2.0646000000000004     2.0255400000000003     2.0701800000000001     2.1873600000000009     2.4328800000000004     2.9016000000000002 ;
    2.2710599999999999     2.8458000000000006     2.4049800000000001     2.2543200000000003     2.0925000000000007     2.0646000000000004     2.0255400000000003     2.0701800000000001     2.1873600000000009     2.4328800000000004     2.9016000000000002 ;
  0.072539999999999952     1.1662200000000000     1.8079199999999997     1.9864800000000000     2.0534400000000006     2.0255400000000003     2.1761999999999997     2.3826600000000004     2.6616600000000004     2.8625400000000001     3.3424199999999997 ;
    1.0769400000000005     2.2208399999999999     2.5444800000000001     2.7230400000000001     2.7342000000000000     2.7565200000000005     2.8123200000000002     3.2475600000000000     3.4707600000000003     3.9618000000000007     5.1615000000000002 ;
    1.1662200000000000     2.6170200000000006     3.1080600000000000     3.3535800000000009     3.6158399999999999     3.7776600000000005     4.0455000000000005     5.0945400000000003     5.9929199999999998     8.6099399999999999     11.522700000000000 ;
    1.7856000000000003     3.2364000000000002     3.1806000000000005     3.0857400000000004     3.1750200000000004     3.4261200000000001     3.5991000000000004     4.0455000000000005     4.8322800000000008     6.0877800000000004     7.3432800000000009 ;
    1.9753200000000002     3.3870600000000000     4.1459400000000004     4.5811800000000007     4.8657599999999999     5.3289000000000009     5.7083400000000006     6.6569400000000005     7.8008400000000009     8.9391600000000011     10.083060000000001 ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,1,2) = [
  0.011160000000000010    0.20646000000000034    0.20087999999999995    0.25668000000000024    0.32922000000000018    0.42966000000000004    0.47430000000000011    0.56916000000000011    0.66402000000000005    0.90396000000000043     1.4787000000000001 ;
  0.011160000000000010    0.20646000000000034    0.20087999999999995    0.25668000000000024    0.32922000000000018    0.42966000000000004    0.47430000000000011    0.56916000000000011    0.66402000000000005    0.90396000000000043     1.4787000000000001 ;
    0.0000000000000000     0.0000000000000000   0.055800000000000058    0.13950000000000026    0.24551999999999999    0.30132000000000031    0.36828000000000038    0.53568000000000027    0.67518000000000034    0.96534000000000009     1.4731200000000002 ;
    0.0000000000000000    0.16182000000000027    0.35712000000000010    0.45755999999999997    0.49104000000000025    0.57473999999999992    0.65286000000000022    0.87048000000000014     1.1271600000000002     1.5958800000000002     2.4328800000000008 ;
  0.050220000000000174    0.42408000000000018    0.59148000000000012    0.90396000000000043     1.0378800000000001     1.1104200000000000     1.2945599999999999     1.7800200000000002     2.4663600000000003     4.2463800000000012     6.2942400000000012 ;
    0.0000000000000000    0.49104000000000025    0.60264000000000040    0.75888000000000000    0.75330000000000008    0.89838000000000007     1.0881000000000005     1.5177600000000002     1.9697400000000000     2.8513800000000011     3.7386000000000008 ;
  0.078120000000000078    0.63612000000000013    0.96534000000000009     1.4452200000000004     1.6851600000000002     2.0088000000000004     2.4217200000000001     3.4484400000000011     4.6704600000000012     5.8869000000000007     7.1089200000000003 ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,2,2) = [
    0.0000000000000000     1.0936800000000004     1.2834000000000003     1.3782600000000003     1.4452200000000004     1.5345000000000004     1.6237800000000004     1.7632800000000004     1.7856000000000005     2.0255400000000003     2.5221600000000008 ;
    0.0000000000000000     1.0936800000000004     1.2834000000000003     1.3782600000000003     1.4452200000000004     1.5345000000000004     1.6237800000000004     1.7632800000000004     1.7856000000000005     2.0255400000000003     2.5221600000000008 ;
    0.0000000000000000     0.0000000000000000    0.53568000000000027     1.1997000000000000     1.3447800000000005     1.4340600000000001     1.4898600000000004     1.6461000000000006     1.6014600000000005     2.0980800000000004     2.6337600000000005 ;
    0.0000000000000000    0.14508000000000015    0.89280000000000015     1.4898600000000004     1.5345000000000004     1.6014600000000005     1.7688600000000003     1.9362600000000003     2.2096800000000005     2.9016000000000011     3.7609200000000005 ;
    0.0000000000000000    0.31248000000000004    0.97650000000000037     1.8190800000000003     2.3324400000000001     2.4663600000000003     2.6839800000000005     3.3312600000000008     4.2742800000000001     6.2049600000000007     8.5095000000000010 ;
    0.0000000000000000    0.49104000000000025     1.2443400000000000     1.8246600000000002     2.0478600000000005     2.3045400000000007     2.3994000000000004     2.8234800000000004     3.2587200000000003     4.4193600000000002     4.4193600000000002 ;
  0.066960000000000061    0.59148000000000012     1.4061600000000001     2.3826600000000009     2.9239200000000003     3.3312600000000008     3.7609200000000005     4.7597400000000007     5.9929200000000007     5.9817600000000013     5.9817600000000013 ]; 
transmission.gear.output_torque_loss_Nm = class_REVS_dynamic_lookup;
transmission.gear.output_torque_loss_Nm.axis_1.signal =  'gb_spd_out_radps'; 
transmission.gear.output_torque_loss_Nm.axis_1.breakpoints = [      0.0000000000000000    0.10471975511965977  ]; 
transmission.gear.output_torque_loss_Nm.table = [      0.0000000000000000     0.0000000000000000  ]; 
transmission.gear.shift_duration_secs =  0.5; 
transmission.gear.inertia_brake_capacity_Nm =  0; 
transmission.control = class_REVS_AT_control;
transmission.control.line_press_rate_limit_barps =  35; 
transmission.control.line_pressure_map_bar = class_REVS_dynamic_lookup;
transmission.control.line_pressure_map_bar.axis_1.signal =  'ctrl.gear_num'; 
transmission.control.line_pressure_map_bar.axis_1.breakpoints = [      0.0000000000000000     1.0000000000000000     2.0000000000000000     3.0000000000000000     4.0000000000000000     5.0000000000000000     6.0000000000000000  ]; 
transmission.control.line_pressure_map_bar.axis_2.signal =  'eng_load_Nm'; 
transmission.control.line_pressure_map_bar.axis_2.breakpoints = [     -22.320000000000000     0.0000000000000000     22.320000000000000     55.800000000000004     111.60000000000001     167.40000000000001     223.20000000000002     279.00000000000000  ]; 
transmission.control.line_pressure_map_bar.axis_3.signal =  'driver_brk_norm'; 
transmission.control.line_pressure_map_bar.axis_3.breakpoints = [      0.0000000000000000   0.010000000000000000  ]; 
transmission.control.line_pressure_map_bar.table = [];
transmission.control.line_pressure_map_bar.table(:,:,1) = [
    5.0000000000000000     5.0000000000000000     5.0000000000000000     5.0000000000000000     5.0000000000000000     5.0000000000000000     5.0000000000000000     5.0000000000000000 ;
    22.000000000000000     22.000000000000000     22.500000000000000     23.000000000000000     23.500000000000000     24.000000000000000     24.500000000000000     25.000000000000000 ;
    4.5000000000000000     4.5000000000000000     5.0000000000000000     6.0000000000000000     8.5000000000000000     12.000000000000000     16.500000000000000     22.000000000000000 ;
    4.5000000000000000     4.5000000000000000     5.0000000000000000     6.0000000000000000     7.0000000000000000     8.5000000000000000     10.500000000000000     13.000000000000000 ;
    5.0000000000000000     5.0000000000000000     5.0000000000000000     5.0000000000000000     6.0000000000000000     7.5000000000000000     10.500000000000000     13.500000000000000 ;
    5.0000000000000000     5.0000000000000000     5.0000000000000000     8.5000000000000000     13.500000000000000     19.500000000000000     25.000000000000000     25.000000000000000 ;
    5.0000000000000000     5.0000000000000000     5.0000000000000000     5.0000000000000000     6.0000000000000000     7.5000000000000000     10.500000000000000     13.500000000000000 ]; 
transmission.control.line_pressure_map_bar.table(:,:,2) = [
    3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000 ;
    3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000 ;
    3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000 ;
    3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000 ;
    3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000 ;
    3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000 ;
    3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000     3.5000000000000000 ]; 
transmission.control.auto_neutral_enable =    true ; 
transmission.control.auto_neutral_delay_secs =  0; 
transmission.control.auto_neutral_warmup_condition =  '1'; 
transmission.control.auto_neutral_warmup_temp_degC =  50; 
transmission.control.auto_neutral_warmup_duration_secs =  100; 
transmission.control.variant = '';
transmission.thermal.temperature_degC =  46; 
transmission.thermal.variant =  'constant temperature'; 
transmission.gear_strategy = class_REVS_ALPHAshift;
transmission.gear_strategy.launch_gear_num =  1; 
transmission.gear_strategy.restrict_skip_shifts =    true ; 
transmission.gear_strategy.restrict_shift_parity =   false ; 
transmission.gear_strategy.min_speed_radps = [      0.0000000000000000     62.831853071795862     146.60765716752368     146.60765716752368     146.60765716752368     146.60765716752368     146.60765716752368  ]; 
transmission.gear_strategy.min_speed_shift_increment = [      1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000  ]; 
transmission.gear_strategy.max_speed_radps = [      0.0000000000000000     628.31853071795865     628.31853071795865     628.31853071795865     628.31853071795865     628.31853071795865     628.31853071795865  ]; 
transmission.gear_strategy.max_speed_shift_increment = [      1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000  ]; 
transmission.gear_strategy.downshift_delay_secs = [     0.10000000000000001    0.10000000000000001    0.10000000000000001    0.10000000000000001    0.10000000000000001    0.10000000000000001    0.10000000000000001  ]; 
transmission.gear_strategy.downshift_commit_secs = [      1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000     1.0000000000000000  ]; 
transmission.gear_strategy.downshift_max_speed_radps = [      0.0000000000000000     534.07075111026484     534.07075111026484     534.07075111026484     534.07075111026484     534.07075111026484     534.07075111026484  ]; 
transmission.gear_strategy.disable_cost_saving_downshifts =    true ; 
transmission.gear_strategy.upshift_min_speed_radps = [      0.0000000000000000     62.831853071795862     188.49555921538757     188.49555921538757     188.49555921538757     188.49555921538757     188.49555921538757  ]; 
transmission.gear_strategy.upshift_delay_secs = [      0.0000000000000000    0.10000000000000001    0.10000000000000001    0.12000000000000000    0.12000000000000000    0.12000000000000000    0.12000000000000000  ]; 
transmission.gear_strategy.upshift_commit_secs = [      1.3000000000000000     1.3000000000000000     1.3000000000000000     1.3000000000000000     1.3000000000000000     1.3000000000000000     1.3000000000000000  ]; 
transmission.gear_strategy.upshift_min_torque_reserve_ratio = [      1.1000000000000001     1.1000000000000001     1.1000000000000001     1.1000000000000001     1.1000000000000001     1.1000000000000001     1.1000000000000001  ]; 
transmission.gear_strategy.kickdown_trigger_ratio = [      1.5000000000000000     1.5000000000000000     1.5000000000000000     1.5000000000000000     1.5000000000000000     1.5000000000000000     1.5000000000000000  ]; 
transmission.gear_strategy.kickdown_delay_secs = [     0.50000000000000000    0.50000000000000000    0.50000000000000000    0.50000000000000000    0.50000000000000000    0.50000000000000000    0.50000000000000000  ]; 
transmission.gear_strategy.kickdown_min_gear =  1; 
transmission.gear_strategy.kickdown_max_increment =  3; 
transmission.gear_strategy.use_engine_speed_mask = [      0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000  ]; 
transmission.gear_strategy.max_input_torque_curve_Nm = [      0.0000000000000000 ;     108.20000000000000 ;     133.43199071616763 ;     158.37904191616764 ;     180.67999999999998 ;     186.56054054054047 ;     194.83088235294122 ;     198.77272727272725 ;     212.66820512820510 ;     220.42264150943393 ;     219.29032258064515 ;     233.80952380952388 ;     236.01546391752564 ;     249.47051199999999 ;     219.02191368246190 ;     187.73306887068165 ;     0.0000000000000000  ]; 
transmission.gear_strategy.max_input_torque_speeds_radps = [      0.0000000000000000 ;     84.508842381565429 ;     104.06526760511444 ;     105.06526760511444 ;     120.99844105301089 ;     139.00670110402751 ;     157.05114274611151 ;     181.15851237259469 ;     211.38998280647132 ;     265.49125312822645 ;     313.85974433895962 ;     423.00797082335708 ;     470.84970760835927 ;     523.59877559829886 ;     691.15038378975441 ;     725.70790297924214 ;     760.26542216872997  ]; 
transmission.gear_strategy.required_cost_benefit_ratio = [      1.0000000000000000     1.0300000000000000     1.0300000000000000     1.0200000000000000     1.0200000000000000     1.0200000000000000     1.0200000000000000  ]; 
transmission.gear_strategy.cost_map_speed_radps = [      0.0000000000000000 ;     40.762164680327558 ;     81.524329360655116 ;     117.50576634052098 ;     138.86333881584747 ;     156.96349128441210 ;     181.06021860244829 ;     211.23458327916586 ;     265.46934230094655 ;     313.74723459107747 ;     374.05468341626522 ;     422.28847961695163 ;     470.53860674269447 ;     518.79567960255429 ;     567.04234327756308 ;     603.42091616524067 ;     681.84316916698526 ;     760.26542216872997  ]; 
transmission.gear_strategy.cost_map_torque_Nm = [     -57.362414553472995 ;    -42.783707276736493 ;    -28.204999999999998 ;    -12.619166666666665 ;     2.9666666666666668 ;     12.718421052631580 ;     28.766666666666666 ;     40.812500000000000 ;     54.439999999999998 ;     63.635277777777773 ;     72.830555555555549 ;     88.879999999999995 ;     103.90000000000001 ;     114.67222222222222 ;     128.53333333333333 ;     135.84999999999999 ;     149.44604316546761 ;     159.71467160604487 ;     169.98330004662211 ;     180.67999999999998 ;     185.18837837837836 ;     196.89281344454776 ;     209.67081272319996 ;     225.33823245652508 ;     243.64113502826254 ;     261.94403760000000  ]; 
transmission.gear_strategy.cost_map = [
    0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000 ;
    0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     1.5103164600200782     2.8878500617555778     5.8378605740903717     8.7709039473137338 ;
    0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000     0.0000000000000000    0.93732021105511498     2.5046648430164655     4.5854407847606637     7.3167356727087673     10.038639589375826     12.036415261871523     16.214064436965831     20.339417660354020 ;
    0.0000000000000000    0.58577790212456349     1.2423397773356517     1.7231156938845771     1.9824426991841770     2.2010746425205974     2.4966819749123808     2.9417519240140941     4.0126346959589840     5.3858673728561106     7.5974593715421435     9.9469990851569836     12.763625442659949     15.949682422342851     19.324653937595819     21.892899007871442     27.386029750103440     32.758254038291184 ;
  0.087032843015990166    0.82678672060496250     1.5712700260058117     2.1839642503576244     2.4907300857811867     2.7472709503254755     3.0956263792181189     3.5684826645775520     4.5747804430263566     5.7171014195144716     7.4929052449017552     9.1722404897152554     11.054271984116777     13.108378536862071     15.275999613693266     16.931772848801987     20.474613341574319     23.934946581515479 ;
  0.060223124771205658    0.40667675539896325    0.75451049769327572     1.0560466070122951     1.2394953465886573     1.3955719046372221     1.6013290017574027     1.8616470922473540     2.3777765610006072     2.9306293020100145     3.7796189875486319     4.5459746312816911     5.3692762791160344     6.2823528830671487     7.2529938022364187     7.9825044147729702     9.5209822563151754     11.029097942488299 ;
  0.048917484545464740    0.27292030384651156    0.49997615037018101    0.69888086222473789    0.82571302264580293    0.93740768629074034     1.0880383350144884     1.2765776073724631     1.6525530846858341     2.0131564217945601     2.5657204658679573     3.0438656590404483     3.5093046812527748     4.0643056730649336     4.6749935396287574     5.1055882778642987     6.0001846672754580     6.8857319448905052 ;
  0.049620316154632055    0.24372644404406771    0.43615028496468145    0.61124560512331039    0.72245271223893615    0.81847927070156890    0.94826695561490604     1.1146820172424501     1.4383642688286762     1.7610078542175995     2.2118719329387031     2.6031130041198907     3.0168788711830858     3.4563611990116270     3.9452914886095498     4.3044498596512355     5.0468143268475805     5.7786888036790387 ;
  0.055845118031959233    0.25097505658565805    0.44794824678505274    0.61453797714534975    0.71808646894950834    0.80744872766457176    0.92999883756492674     1.0904398401138178     1.4084854283518864     1.7211280259567117     2.1505711911777179     2.5223821014845660     2.9097103554701933     3.3195928584295920     3.7521694948584807     4.0806789851874186     4.7820874196619991     5.4796295712223264 ;
  0.067019147283104513    0.27514462585223720    0.48185475184641952    0.66453494464692742    0.77818502098157805    0.87610189456788989     1.0100128500635022     1.1861441796148948     1.5402217222698507     1.8589709011338034     2.3040015636517279     2.7221747786758037     3.1320176645345668     3.5612528483194095     4.0156691134615752     4.3603802949040560     5.1098070163342779     5.8639877937259470 ;
  0.078778076840616856    0.29926075602414121    0.51861305366828214    0.71303662319168060    0.83538410297606125    0.93995681286434729     1.0853988046941794     1.2791100344938604     1.6653116167613817     1.9782946523945772     2.4604872472871189     2.9201146250367387     3.3405297132265095     3.7880700447696851     4.2690842893304266     4.6321161033659477     5.4316761558912194     6.2448917853418795 ;
   0.10260100678200648    0.34762709797735974    0.58783305034250866    0.79284220275041639    0.92661084373882108     1.0461360822741537     1.2107816432046581     1.4285818961579635     1.8419885626188071     2.1926265737005908     2.7288833057133752     3.2100923678215074     3.6784099197111062     4.1684904362732658     4.6878395233673711     5.0914572033167920     5.9948562329554917     6.9197309152293203 ;
   0.13823210815771772    0.40374022339529542    0.66676506057701679    0.88379105022849624     1.0264615495049398     1.1537951929218342     1.3310479574028484     1.5640106650290044     2.0079290895362587     2.4111516910560233     2.9720489500457958     3.4721640779328231     3.9904057116085823     4.5318149094058482     5.1202613945722506     5.5781329232238122     6.6014252190134952     7.6470758248071196 ;
   0.18589484082983462    0.45248499368942513    0.72074241755717428    0.95907206890295194     1.1137013430378844     1.2500518325840886     1.4390452362205459     1.6878185782230797     2.1664879179797984     2.5929114034245702     3.1841322970007728     3.7222227288648919     4.2836487814164865     4.8623210623442592     5.5248894291152411     6.0333582261019103     7.1625432095266399     8.3134822256544023 ;
   0.28721822883549802    0.54351460181706779    0.80983766406687596     1.0660088650926005     1.2303187631611618     1.3754811303883709     1.5757619896831698     1.8383475384995966     2.3486639915943415     2.8202145466637565     3.4561430228122862     4.0502084193527441     4.6741758262170947     5.3439090684765223     6.0787619555196262     6.6517186645151458     7.9219038512929609     9.2109096178647345 ;
   0.36272249908960513    0.61619222589149569    0.88055221621524549     1.1395966977749321     1.3034522698420234     1.4495712981834050     1.6527688086370464     1.9261531489234480     2.4520070335734103     2.9439243479808930     3.5960512509023794     4.2114677393949886     4.8734037843337985     5.5978333726832323     6.3845451360139966     6.9938000433738248     8.3359385499995096     9.6974435059455981 ;
   0.54001578079698465    0.80248232146571852     1.0645120110963604     1.3240205979733957     1.4899773915900660     1.6330266807059788     1.8304112428038879     2.1130868087400927     2.6663285133997157     3.1793304697280211     3.8721122497734326     4.5169808330698817     5.2402877505254777     6.0586031573197934     6.9731672931890376     7.6534043672747520     9.1262578024035133     10.621096271010963 ;
   0.68784497083119678    0.98818989366758836     1.2917265949576271     1.5476931115032171     1.7008447843080488     1.8386773285536655     2.0360556871695654     2.3047786943464619     2.8412935984654983     3.3699684474651668     4.1007404457224368     4.7851558078494483     5.5441225860504755     6.4054087766657197     7.4193030978783341     8.1551173713515297     9.7372964119500125     11.329767553468866 ;
   0.83376415672229354     1.1706400663348280     1.4940046085111980     1.7508456912482149     1.9104975536906224     2.0581567754566708     2.2755441446942091     2.5429264429436969     3.0477796276064364     3.5752725674968886     4.3577624221190980     5.0936028653417784     5.8909807605651023     6.8089579694664026     7.8617116087008654     8.6587300142493699     10.356671429094586     12.039905257189247 ;
   0.96753948109155274     1.3392259089641549     1.7080714948361653     2.0227061303029141     2.1792315964509177     2.3226531996952646     2.5424187391800053     2.8167519336915050     3.3194337455239502     3.8457915110590104     4.6427162511715290     5.4561191335085724     6.3128660182186449     7.2937380953363116     8.3790451532942196     9.2153287010135063     11.011117261228893     12.773821475368047 ;
    1.0191813693338228     1.4034965333456235     1.7841850125904524     2.0985852661385018     2.2695442367808942     2.4248847338430126     2.6486878583165914     2.9380788150752819     3.4546737131487157     3.9874044484532289     4.7662262777146420     5.6075330531383800     6.4910268004784610     7.5053942462789189     8.6105015850410407     9.4610766483078788     11.288920476726672     13.080099635046434 ;
    1.1393392636800725     1.5503662129973603     1.9517356248121651     2.2928043293392779     2.4992801200888892     2.6819636411407437     2.9491232495850279     3.2881575452187297     3.8820143170389314     4.4517379386418403     5.1163007460159804     5.9712989554091731     6.9512423919914372     8.0760557701160867     9.2482348688974305     10.131255171703264     12.015229808471732     13.865327876851691 ;
    1.2428466248988421     1.6980488745036315     2.1574459157159809     2.5862742745198743     2.8605274605458235     3.1034377602326630     3.4433280414945315     3.8891903406378110     4.5668546335209852     5.2237619857281441     5.6313562796794283     6.4816267642856467     7.5461689015970661     8.7698190770616833     10.003458530954221     10.903623718521224     12.809028502799231     14.697779760273530 ;
    1.3676948005826781     1.9160974528809731     2.4768579218169684     2.9923010425957144     3.3049611829535874     3.5712795191723146     3.9245160084663695     4.3514319385901468     4.9778280750318915     5.4747509433457680     6.4796966791337454     7.3732094017278733     8.3919781824987982     9.6871314678608229     10.899680662576685     11.828406252435945     13.752258048296365     15.682239889557808 ;
    1.5701713588631969     2.2058435808768184     2.8419449412507456     3.3994459229086735     3.7259426760978762     4.0000156456724598     4.3600630086448176     4.8004989478932290     5.5622026285474035     6.2915506776246373     7.3945387554839446     8.3302795733851625     9.2501572053274703     10.472372664015777     11.748765361327019     12.712056402771372     14.756051584428622     16.789335338752565 ;
    1.8063776545476955     2.4874352463439191     3.1646344523705219     3.7568751158087847     4.1068306233455960     4.4031135450601182     4.7978184757391427     5.2950707487276762     6.2145323711276710     7.0833545123663866     8.2352957097276054     9.2122309503280224     10.249286404429814     11.376661169915165     12.592597083810984     13.544571845041110     15.686766682217456     17.864183980452747 ]; 
transmission.tcc_strategy = [];

