% 9.8 kWh battery pack, 360V, 27.3 Ah

function [battery] = battery_9p8_kWh_NCM()

% based on Kokam NCM battery

battery = class_REVS_battery;

battery.cell.chemistry             = enum_battery_type.LiFePO4_Energy;
battery.cell.capacity_nominal_Ah   = 6.821;

battery.num_parallel_cells              = 4;
battery.num_series_cells                = 100;
battery.use_average_open_circuit_Volts  = true;

battery.initial_soc_norm   = 0.87;

battery.cell.powerlimit_discharge_map_W.axis_1.signal = 'temp_degC';
battery.cell.powerlimit_discharge_map_W.axis_1.breakpoints = [-30 -20 -10 0 10 20 30 40];
battery.cell.powerlimit_discharge_map_W.axis_2.signal = 'soc_norm';
battery.cell.powerlimit_discharge_map_W.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.powerlimit_discharge_map_W.table  = [67 79 85 93 110 118 131 135 136 140;
                                                           118 132 145 190 224 264 300 332 348 363;
                                                           187 223 308 391 486 536 573 573 580.5 588;
                                                           308 386 445 534 587 608 630 648 658 671;
                                                           643 681 690 696 702 718 732 738.5 745 745;
                                                           730.81 774 782.5 791 803 812 820 832 833.5 835;
                                                           770.47 816 821 826 835 841 847 858 860 860;
                                                           789 836 841 846 851 855 866 877 880 880];
                                                       
battery.cell.powerlimit_charge_map_W.axis_1.signal = 'temp_degC';
battery.cell.powerlimit_charge_map_W.axis_1.breakpoints = [-30 -20 -10 0 10 20 30 40];
battery.cell.powerlimit_charge_map_W.axis_2.signal = 'soc_norm';
battery.cell.powerlimit_charge_map_W.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.powerlimit_charge_map_W.table     = [15 15 15 15 15 15 0 0 0 0;
                                                           37 37 37 37 37 37 37 37 37 37;
                                                           190 183 180.5 179.25 178 175 172 164 157 157;
                                                           439 404 387 370 368 367 366 343 334 321;
                                                           729 689 668 634 633 632 559 466 372 372;
                                                           1051 1044 990 978 972 966 931 838 745 698;
                                                           1117 1117 1117 1117 1117 1024 931 838 745 698;
                                                           1117 1117 1117 1117 1117 1024 931 838 745 698];
                                                       
battery.cell.open_circuit_voltage_map_discharge_V.axis_1.signal        = 'soc_norm';
battery.cell.open_circuit_voltage_map_discharge_V.axis_1.breakpoints   = [0 0.1 0.3 0.5 0.7 0.9 1.0];
battery.cell.open_circuit_voltage_map_discharge_V.table                = [3.0 3.47 3.58 3.66 3.76 3.96 4.08];

battery.cell.open_circuit_voltage_map_charge_V.axis_1.signal           = 'soc_norm';
battery.cell.open_circuit_voltage_map_charge_V.axis_1.breakpoints      = [0 0.1 0.3 0.5 0.7 0.9 1.0];
battery.cell.open_circuit_voltage_map_charge_V.table                   = [3.12 3.50 3.62 3.68 3.79 3.97 4.1];

%%
battery.cell.transient_R_discharge_short_term_Ohms.axis_1.signal            = 'soc_norm';
battery.cell.transient_R_discharge_short_term_Ohms.axis_1.breakpoints       = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_R_discharge_short_term_Ohms.table                    = [4.19 1.99 1.54 1.94 1.96]/1000;

battery.cell.transient_R_charge_short_term_Ohms.axis_1.signal               = 'soc_norm';
battery.cell.transient_R_charge_short_term_Ohms.axis_1.breakpoints          = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_R_charge_short_term_Ohms.table                       = [2.30 1.91 1.91 2.40 2.26]/1000;

battery.cell.transient_R_discharge_long_term_Ohms.axis_1.signal             = 'soc_norm';
battery.cell.transient_R_discharge_long_term_Ohms.axis_1.breakpoints        = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_R_discharge_long_term_Ohms.table                     = [4.19 1.99 1.54 1.94 1.96]/1000;

battery.cell.transient_R_charge_long_term_Ohms.axis_1.signal                = 'soc_norm';
battery.cell.transient_R_charge_long_term_Ohms.axis_1.breakpoints           = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_R_charge_long_term_Ohms.table                        = [2.30 1.91 1.91 2.40 2.26]/1000;

%%
battery.cell.resistance_map_discharge_Ohms.axis_1.signal                = 'soc_norm';
battery.cell.resistance_map_discharge_Ohms.axis_1.breakpoints           = [0.1  0.3  0.5  0.7  0.9];
battery.cell.resistance_map_discharge_Ohms.table                        = [3.70 2.95 2.59 2.48 2.43]/1000;

battery.cell.resistance_map_charge_Ohms.axis_1.signal                   = 'soc_norm';
battery.cell.resistance_map_charge_Ohms.axis_1.breakpoints              = [0.1  0.3  0.5  0.7  0.9];
battery.cell.resistance_map_charge_Ohms.table                           = [2.85 2.71 2.58 2.59 2.69]/1000;

battery.cell.transient_C_discharge_short_term_Farads.axis_1.signal      = 'soc_norm';
battery.cell.transient_C_discharge_short_term_Farads.axis_1.breakpoints = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_C_discharge_short_term_Farads.table              = [16 30 30 34 35] ./ battery.cell.transient_R_discharge_short_term_Ohms.table;

battery.cell.transient_C_charge_short_term_Farads.axis_1.signal        = 'soc_norm';
battery.cell.transient_C_charge_short_term_Farads.axis_1.breakpoints   = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_C_charge_short_term_Farads.table                = [31 36 40 49 52] ./ battery.cell.transient_R_charge_short_term_Ohms.table;

battery.cell.transient_C_discharge_long_term_Farads.axis_1.signal      = 'soc_norm';
battery.cell.transient_C_discharge_long_term_Farads.axis_1.breakpoints = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_C_discharge_long_term_Farads.table              = [16 30 30 34 35] ./ battery.cell.transient_R_discharge_long_term_Ohms.table;

battery.cell.transient_C_charge_long_term_Farads.axis_1.signal         = 'soc_norm';
battery.cell.transient_C_charge_long_term_Farads.axis_1.breakpoints    = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_C_charge_long_term_Farads.table                 = [31 36 40 49 52] ./ battery.cell.transient_R_charge_long_term_Ohms.table;

battery.charge_efficiency_map_norm.axis_1.signal                       = 'soc_norm';
battery.charge_efficiency_map_norm.axis_1.breakpoints                  = [0 0.8 0.85 0.9 1];
battery.charge_efficiency_map_norm.table                               = [0.99 0.99 0.99 0.98 0.97];

%%
battery.cell.temperature_power_derate_index_temp_degC  = [-30 -20 -10 0 10 20 30 40 50 55];
battery.cell.temperature_power_discharge_derate_norm   = [0.1139 0.3454 0.5528 0.7314 0.8763 0.9828 1.046 1.0611 1.0233 0.1139];
battery.cell.temperature_power_charge_derate_norm      = [0.027 0.09675 0.1665 0.4031 0.6776 0.9351 1.1206 1.179 1.0554 0.027];
battery.use_second_order_model                         = false;

battery.discharge_derate_soc_norm  = [0.10 0.18]; 
battery.charge_derate_soc_norm     = [0.97 1];
battery.thermal.initial_temp_degC  = 22.25;

battery.thermal.pack_mass_kg                           = 0.5 * battery.num_cells;
battery.thermal.specific_heat_capacity_JpkgK           = 1011.8;     % lithium-polymer = 1011.8 for 6Ah, NREL A.A. Pesaran & M. Keyser thermal characteristics of selected EV & HEV batteries
battery.thermal.heat_transfer_coefficient_Wpm2K        = 10.5 * 0.3; % Base * hrate_cal
battery.thermal.pack_heat_transfer_area_m2             =  8.698186 * battery.num_cells;

end