
if exist('REVS','var') && REVS.verbose  disp(['Loading ' mfilename]); end

controls = class_REVS_PS_control();

controls.hybrid_system_enable = true;
controls.owc_variant = false;

controls.max_battery_power_W = 99000;

controls.start_stop_enable           =  true;
controls.start_stop_warmup_condition ='( (sim_config.controls_cold_start_enable==1 && @cycle_pos_secs >= 350 ) || ( sim_config.controls_cold_start_enable==0 && @cycle_pos_secs >= 0) )';% && (@cycle_pos_secs < 1370 || @cycle_pos_secs > 1505))';
controls.stop_delay_secs             = 0;
controls.start_stop_off_delay_secs 	 = 0;
controls.hot_soak_warmup_start_condition = '( (sim_config.controls_hot_soak_start_enable==1 && (@cycle_pos_secs < -5 || @cycle_pos_secs > 200)) || ( sim_config.controls_hot_soak_start_enable==0 && @cycle_pos_secs >= 0) )';% && (@cycle_pos_secs < 1370 || @cycle_pos_secs > 1505))';


%% Based on Traction Limit

controls.launch_clutch_control                               = class_REVS_launch_clutch_control(engine);
controls.launch_clutch_control.engage_Ki                     = 0.02;
controls.launch_clutch_control.engage_Kp                     = 0.01;
controls.launch_clutch_control.engage_modulation_max_gear    = 1;
controls.launch_clutch_control.engage_speed_radps            = interp1([0,1], [engine.idle_speed_radps.table(1) * 1.1 , max(engine.full_throttle_speed_radps)], [0.05, 0.15]);
controls.launch_clutch_control.engage_pedal_norm             = 0.05;

[controls.min_bsfc_speed_radps, ~, controls.min_bsfc_power_W] = REVS_calc_engine_min_bsfc(engine,'increment', 2.5);

controls.engine_strategy.min_speed_radps = class_REVS_dynamic_lookup;
controls.engine_strategy.min_speed_radps.axis_1.signal         = 'veh_spd_mps';
controls.engine_strategy.min_speed_radps.axis_1.breakpoints    = [0,    45  ] * unit_convert.mph2mps;
controls.engine_strategy.min_speed_radps.table                 = [1100, 1000]  * unit_convert.rpm2radps;


controls.max_wheel_torque_Nm = (electric.MG2.max_torque_Nm * electric.MG2.gear.ratio + electric.MG1.max_torque_Nm * (1 + transmission.planetary.R/transmission.planetary.S)) * vehicle.drive_axle1.final_drive.gear_ratio;
controls.max_wheel_power_W   = engine.max_power_W;
controls.max_wheel_torque_vspeed_mps = [0:1:45];
controls.max_wheel_torque_table = min(controls.max_wheel_torque_Nm, controls.max_wheel_power_W ./ max(eps,controls.max_wheel_torque_vspeed_mps ./ vehicle.drive_axle1.tire.radius_m));

tmp.max_wheel_power_adj_norm = max(controls.max_wheel_torque_table)/2.7708e+03; 

controls.regen_torque_limit_Nm = class_REVS_dynamic_lookup;
controls.regen_torque_limit_Nm.axis_1.signal         = 'veh_spd_mps';
controls.regen_torque_limit_Nm.axis_1.breakpoints    =  [0, 0.75 , 2.75, 14.5, 15.5, 16:0.5:34 35.5] ;
controls.regen_torque_limit_Nm.table                 = -[0, 0,     63,   75,   75, 73.9115555718762,71.6718114636375,69.5638170088246,67.5762793800011,65.6991605083344,63.9235075216226,62.2413099552642,60.6453789307702,59.1292444575010,57.6870677634156,56.3135661500009,55.0039483325590,53.7538585977281,52.5593284066675,51.4167343108704,50.3227612404263,49.2743703812508,48.2687709857151,47.3033955660008,46.3758780058831,45.4840341980777,44.6258448735856,43.7994403388896,43.0030868781825,42.2351746125007,41.4942066368428,40.7787892810351,40.0876233610176,39.4194963050006,38.7732750540990,38.1478996500006,37.5423774333339,36.9557777859381,36.3872273584621,35.8359057318188,35.3010414671648,34.7819085044123, 0].*vehicle.ETW_kg./1644.3;

%% Based on Battery Pack Size

tmp.base.cs_soc_band_init = [0.117 0.14];
tmp.base.battery_cap_init = 8.8; 
tmp.base.battery_cap_hev_init = 0.828;
tmp.base.usable_cap_init = tmp.base.battery_cap_init*diff(tmp.base.cs_soc_band_init);

tmp.base.soc_cs_low = min(tmp.base.cs_soc_band_init );
tmp.base.soc_cs_high = max(tmp.base.cs_soc_band_init);
tmp.base.soc_cs_range = tmp.base.soc_cs_high - tmp.base.soc_cs_low;

tmp.target.battery_cap = (mean([electric.propulsion_battery.min_voltage_V, electric.propulsion_battery.max_voltage_V])*electric.propulsion_battery.capacity_nominal_Ah/1000);

if  tmp.target.battery_cap > 4
    tmp.target.usable_cap_init = tmp.base.usable_cap_init *vehicle.ETW_kg /1.6443e+03;
else
    tmp.target.usable_cap_init = tmp.base.usable_cap_init*tmp.target.battery_cap/tmp.base.battery_cap_hev_init; 
end

tmp.target.diff_cs_soc_band = tmp.target.usable_cap_init/tmp.target.battery_cap;

controls.charge_sustain_soc_band(1) = max(0.1,electric.propulsion_battery.initial_soc_norm  );
controls.charge_sustain_soc_band(2) = min(0.95,electric.propulsion_battery.initial_soc_norm + tmp.target.diff_cs_soc_band );

if diff(controls.charge_sustain_soc_band)*(1+eps) < tmp.target.diff_cs_soc_band
    controls.charge_sustain_soc_band(2) = controls.charge_sustain_soc_band(2) + (-diff(controls.charge_sustain_soc_band) + tmp.target.diff_cs_soc_band) ;
    controls.charge_sustain_soc_band(2) = min(0.95,controls.charge_sustain_soc_band(2));
end

tmp.target.soc_cs_low = min(controls.charge_sustain_soc_band );
tmp.target.soc_cs_high = max(controls.charge_sustain_soc_band);
tmp.soc_cs_range = tmp.target.soc_cs_high - tmp.target.soc_cs_low;
%%
controls.battery_charge_request_W = class_REVS_dynamic_lookup;
controls.battery_charge_request_W.axis_1.signal = 'powertrain.electric.energy_storage.primary_batt.batt_SoC_norm';
controls.battery_charge_request_W.axis_1.breakpoints = [0    tmp.target.soc_cs_low (tmp.soc_cs_range*0.44 + tmp.target.soc_cs_low) (tmp.soc_cs_range*0.57 + tmp.target.soc_cs_low)...
    tmp.target.soc_cs_high (tmp.target.soc_cs_high+tmp.soc_cs_range/2.1) (tmp.target.soc_cs_high+tmp.soc_cs_range/2) 1.0];
controls.battery_charge_request_W.axis_2.signal = 'veh_spd_mps';
controls.battery_charge_request_W.axis_2.breakpoints = [0 0.1 14 100];
controls.battery_charge_request_W.table = [ 0 0 0 0 0  0  0  0   ;
    [10000 10000 10000 10000 0     0 -5000  -5000]/3 ;
    10000 10000 10000 10000 0      0 -5000  -5000 ;
    10000 10000 10000 10000 0      0 -5000  -5000]'./1.1.*tmp.target.battery_cap/tmp.base.battery_cap_init;%

controls.engine_start_power_kW = class_REVS_dynamic_lookup;
controls.engine_start_power_kW.axis_1.signal = 'powertrain.electric.energy_storage.primary_batt.batt_SoC_norm';
controls.engine_start_power_kW.axis_1.breakpoints = [0 tmp.target.soc_cs_low (tmp.soc_cs_range*0.35 + tmp.target.soc_cs_low) (tmp.soc_cs_range*0.57 + tmp.target.soc_cs_low)...
    (tmp.target.soc_cs_low + tmp.soc_cs_range*0.75) tmp.target.soc_cs_high (tmp.target.soc_cs_high+tmp.soc_cs_range/4) 1];
controls.engine_start_power_kW.axis_2.signal = 'veh_spd_mps';
controls.engine_start_power_kW.axis_2.breakpoints = [0 0.1 9.6 100];
controls.engine_start_power_kW.table =[ [9.85 9.85 12 12.5 12.5 12.5 12.5 12.5] + 10;
    [9.85 9.85 12 12.5 12.5 12.5 12.5 12.5] + 6 ;
    [9.85 9.85 12 12.5 12.5 12.5 12.5 12.5] - 0.5 ;
    [9.85 9.85 12 12.5 12.5 12.5 12.5 12.5] - 0.5 ]'.* tmp.max_wheel_power_adj_norm;

controls.engine_stop_power_kW = class_REVS_dynamic_lookup;
controls.engine_stop_power_kW.axis_1.signal = 'powertrain.electric.energy_storage.primary_batt.batt_SoC_norm';
controls.engine_stop_power_kW.axis_1.breakpoints =[ 0 tmp.target.soc_cs_low (tmp.soc_cs_range*0.35 + tmp.target.soc_cs_low) (tmp.soc_cs_range*0.45 + tmp.target.soc_cs_low) (tmp.soc_cs_range*0.57 + tmp.target.soc_cs_low) tmp.target.soc_cs_high (tmp.target.soc_cs_high+tmp.soc_cs_range/4) (tmp.target.soc_cs_high+tmp.soc_cs_range/3) 1];
controls.engine_stop_power_kW.axis_2.signal = 'veh_spd_mps';
controls.engine_stop_power_kW.axis_2.breakpoints = [0 0.1 9 100];
controls.engine_stop_power_kW.table =[ [7-5 7-4.5 2.75+0.35 2.75+0.50 7-4 7-1 7+1.5 7+2 7+3]+5;
    [7-5 7-4.5 2.75+0.35 2.75+0.50 7-4 7-1 7+1.5 7+2 7+3]+2;
    [7-5 7-4.5 2.75+0.35 2.75+0.50 7-4 7-1 7+1.5 7+2 7+3]-0.25;
    [7-5 7-4.5 2.75+0.35 2.75+0.50 7-4 7-1 7+1.5 7+2 7+3]-0.25 ]'.* tmp.max_wheel_power_adj_norm;;

%%
controls.drive_motor_torque_limit_soc_norm = [0.05 0.08];
controls.drive_motor_torque_limit_norm     = [0    1];

controls.drive_regen_speed_limit_mps       = [0.5 4.0] * unit_convert.mph2mps;
controls.drive_regen_speed_limit_norm      = [0.0 1.0];

controls.drive_regen_torque_limit_soc_norm = [0.80 0.85];
controls.drive_regen_torque_limit_norm     = [1    0   ];

controls.engine_cruise_activate_mps        = 150* unit_convert.mph2mps;
controls.engine_start_min_mps              = 5.2;

%%

[tmp.max_trq_spd_radps, tmp.max_trq_Nm] = engine.get_max_torque_curve();
[tmp.min_trq_spd_radps, tmp.min_trq_Nm] = engine.get_min_torque_curve();

controls.engine_torque_range_speed_radps = unique( [tmp.max_trq_spd_radps(:);tmp.min_trq_spd_radps(:)])';

controls.engine_max_torque_Nm = interp1(tmp.max_trq_spd_radps, tmp.max_trq_Nm, controls.engine_torque_range_speed_radps, 'linear','extrap');
controls.engine_min_torque_Nm = interp1(tmp.min_trq_spd_radps, tmp.min_trq_Nm, controls.engine_torque_range_speed_radps, 'linear','extrap');

controls.engine_max_torque_Nm = max(controls.engine_max_torque_Nm, controls.engine_min_torque_Nm);

controls.engine_idle_speed_radps = engine.nominal_idle_speed_radps;

tmp.min_bsfc_curves = engine.min_bsfc_curves();
controls.min_bsfc_speed_radps = tmp.min_bsfc_curves.speed_radps;
controls.min_bsfc_torque_Nm = tmp.min_bsfc_curves.torque_Nm;
controls.min_bsfc_power_W = tmp.min_bsfc_curves.power_W;

%%
clear tmp