
if exist('REVS','var') && REVS.verbose  disp(['Loading ' mfilename]); end

electric = class_REVS_electric();

electric.name = mfilename;
electric.low_voltage_DCDC.output_voltage_V = 13.23;
electric.low_voltage_DCDC.rated_power_W    = 290;
electric.low_voltage_DCDC.power_loss_map_norm.axis_1.signal = 'powertrain.electric.energy_storage.boost_dcdc_conv.DCDC_load_norm';

electric.accessory_battery = battery_lead_acid_flooded_41Ah();

electric.high_voltage_DCDC.output_voltage_V = 650;
electric.high_voltage_DCDC.rated_power_W    = 30000;

%https://www.osti.gov/pages/servlets/purl/1429088
%https://www.energy.gov/sites/prod/files/2016/03/f30/FY%202015%20Electric%20Drive%20Technologies%20Annual%20Report.pdf
electric.high_voltage_DCDC.power_loss_map_norm                 = class_REVS_dynamic_lookup;   
electric.high_voltage_DCDC.power_loss_map_norm.axis_1.signal = 'powertrain.electric.energy_storage.boost_dcdc_conv.DCDC_load_norm';
electric.high_voltage_DCDC.power_loss_map_norm.axis_1.breakpoints = [0, 0.0520833333333333,0.0596316333333333,0.0664251333333333,0.0792572333333333,0.0913345333333333,0.104166666666667,0.120772933333333,0.145682366666667,0.205314000000000,0.268719800000000,0.320048300000000,0.354770533333333,0.421950466666667,0.488375600000000,0.541213766666667,0.628019333333333,0.678593000000000,0.728411833333333,0.782004833333333,0.828804333333333,0.899758466666667,0.951841800000000,0.989583333333333, 1 ]; % output power divided by rated_power_W

electric.high_voltage_DCDC.power_loss_map_norm.axis_2.signal = 'veh_spd_mps';
electric.high_voltage_DCDC.power_loss_map_norm.axis_2.breakpoints = [0 20 200];

electric.high_voltage_DCDC.power_loss_map_norm.table              = [0, 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0247071757936734,0.0266364609518400,0.0283486554825467,0.0312885158353300,0.0328283669111580,0.0344121171875000,0.0344121171875000;
    0, 0,0,0,0,0,0,0,0,0,0,0,0.0129436468096320,0.0149135945130627,0.0168437374648360,0.0185118272149213,0.0213019384919734,0.0228239326806000,0.0247071757936734,0.0266364609518400,0.0283486554825467,0.0312885158353300,0.0328283669111580,0.0344121171875000,0.0344121171875000;...
    0, 0.00518853906250000,0.00529460923938000,0.00531085480858200,0.00564778405694900,0.00589660953268400,0.00605700729166667,0.00624806330987866,0.00676852075805033,0.00866122652477999,0.0104934759436240,0.0119048846223450,0.0129436468096320,0.0149135945130627,0.0168437374648360,0.0185118272149213,0.0213019384919734,0.0228239326806000,0.0247071757936734,0.0266364609518400,0.0283486554825467,0.0312885158353300,0.0328283669111580,0.0344121171875000,0.0344121171875000]'; % multiply by rated_power_W for actual power loss
