function [battery] = battery_base_Samsung_LI_Power_mod2()

% based partially on Suozzo lead acid data;
% - Jan 2022 - Modified for data below 0.20 SOC;Prius Prime runs at ~0.11

battery = class_REVS_battery;

battery.cell.chemistry             = enum_battery_type.LiFePO4_Power;
battery.cell.capacity_nominal_Ah   = 6.5;

battery.num_parallel_cells              = 1;
battery.num_series_cells                = 60;
battery.use_average_open_circuit_Volts  = true;

battery.initial_soc_norm   = 0.576;

battery.cell.powerlimit_discharge_map_W.axis_1.signal = 'temp_degC';
battery.cell.powerlimit_discharge_map_W.axis_1.breakpoints = [-30 -25 -15 -10 0 10 25 35 45];
battery.cell.powerlimit_discharge_map_W.axis_2.signal = 'soc_norm';
battery.cell.powerlimit_discharge_map_W.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8];
battery.cell.powerlimit_discharge_map_W.table  = [67 67 67 71 75 80 84 95;
                                                   100 100 113 125 137 149 161 174;
                                                   167 167 204 232 260 288 316 331;
                                                   200 200 250 286 321 357 393 410;
                                                   320 320 388 431 474 518 561 595;
                                                   460 460 588 651 715 776 837 858;
                                                   600 600 787 872 956 1035 1113 1120;
                                                   705 705 930 1034 1139 1206 1273 1285;
                                                   810 810 1073 1197 1321 1377 1433 1450];
                                                       
battery.cell.powerlimit_charge_map_W.axis_1.signal = 'temp_degC';
battery.cell.powerlimit_charge_map_W.axis_1.breakpoints = [-30 -25 -15 -10 0 10 25 35 45];
battery.cell.powerlimit_charge_map_W.axis_2.signal = 'soc_norm';
battery.cell.powerlimit_charge_map_W.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8];
battery.cell.powerlimit_charge_map_W.table     = [67 67 61 52.5 44 36 28 12;
                                                   119 119 110.25 100.25 90.25 78.75 67.25 46.5;
                                                   223 223 208.75 195.75 182.75 164.25 145.75 115.5;
                                                   275 275 258 243.5 229 207 185 150;
                                                   510 510 492 454.5 417 338 259 200;
                                                   755 755 739 696.25 653.5 541 428.5 325;
                                                   1000 1000 986 938 890 744 598 450;
                                                   1225 1225 1170 1124.25 1078.5 892.5 706.5 525;
                                                   1450 1450 1354 1310.5 1267 1041 815 600];
                                                       
battery.cell.open_circuit_voltage_map_discharge_V.axis_1.signal        = 'soc_norm';
battery.cell.open_circuit_voltage_map_discharge_V.axis_1.breakpoints   = [0 0.1 0.2 0.3 0.4 0.5 0.55 0.6 0.7 0.8 0.9 1];
battery.cell.open_circuit_voltage_map_discharge_V.table                = [2.8 3.3 3.45 3.5 3.6 3.63 3.68 3.75 3.9 3.95 4.05 4.2] + 0.147 ;

battery.cell.open_circuit_voltage_map_charge_V.axis_1.signal           = 'soc_norm';
battery.cell.open_circuit_voltage_map_charge_V.axis_1.breakpoints      = [0 0.1 0.2 0.3 0.4 0.5 0.55 0.6 0.7 0.8 0.9 1];
battery.cell.open_circuit_voltage_map_charge_V.table                   = [2.8 3.3 3.45 3.5 3.6 3.63 3.68 3.75 3.9 3.95 4.05 4.2] + 0.147;

%% these come from Suozzo lead acid params...
battery.cell.transient_R_discharge_short_term_Ohms.axis_1.signal            = 'soc_norm';
battery.cell.transient_R_discharge_short_term_Ohms.axis_1.breakpoints       = [0.1 0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.cell.transient_R_discharge_short_term_Ohms.table                    = 0.75.*[0.00788333333333333/2 0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667];

battery.cell.transient_R_charge_short_term_Ohms.axis_1.signal               = 'soc_norm';
battery.cell.transient_R_charge_short_term_Ohms.axis_1.breakpoints          = [0.1 0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.cell.transient_R_charge_short_term_Ohms.table                       = 0.75.*[0.00788333333333333/2 0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667];

battery.cell.transient_R_discharge_long_term_Ohms.axis_1.signal             = 'soc_norm';
battery.cell.transient_R_discharge_long_term_Ohms.axis_1.breakpoints        = [0.1 0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.cell.transient_R_discharge_long_term_Ohms.table                     = 0.75.*[0.00788333333333333/2 0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667];

battery.cell.transient_R_charge_long_term_Ohms.axis_1.signal                = 'soc_norm';
battery.cell.transient_R_charge_long_term_Ohms.axis_1.breakpoints           = [0.1 0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.cell.transient_R_charge_long_term_Ohms.table                        = 0.75.*[0.00788333333333333/2 0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667];

%%
battery.cell.resistance_map_discharge_Ohms.axis_1.signal = 'temp_degC';
battery.cell.resistance_map_discharge_Ohms.axis_1.breakpoints = [-30 -25 -15 -10 0 10 25 35 45];
battery.cell.resistance_map_discharge_Ohms.axis_2.signal = 'soc_norm';
battery.cell.resistance_map_discharge_Ohms.axis_2.breakpoints = [0.1 0.3 0.4 0.5 0.6 0.7];
battery.cell.resistance_map_discharge_Ohms.table      = 0.75.*0.6*[0.049 0.049 0.04725 0.0455 0.04445 0.0434;
                                                          0.0364 0.0364 0.03525 0.0341 0.0338 0.0335;
                                                          0.0136 0.0136 0.01305 0.0125 0.0122 0.0119;
                                                          0.0094  0.0094 0.00865 0.0079 0.0076 0.0073;
                                                          0.006 0.006 0.0057 0.0054 0.00535 0.0053;
                                                          0.0045 0.0045 0.00425 0.004 0.00395 0.0039;
                                                          0.0029 0.0029 0.00275 0.0026 0.0026 0.0026;
                                                          0.0023 0.0023 0.00225 0.0022 0.0022 0.0022;
                                                          0.002 0.002 0.00195 0.0019 0.0019 0.0019];

battery.cell.resistance_map_charge_Ohms.axis_1.signal = 'temp_degC';
battery.cell.resistance_map_charge_Ohms.axis_1.breakpoints = [-30 -25 -15 -10 0 10 25 35 45];
battery.cell.resistance_map_charge_Ohms.axis_2.signal = 'soc_norm';
battery.cell.resistance_map_charge_Ohms.axis_2.breakpoints = [0.1 0.3 0.4 0.5 0.6 0.7];
battery.cell.resistance_map_charge_Ohms.table      = 0.75.*0.5*[0.0542 0.0542 0.05295 0.0517 0.05125 0.0508;
                                                       0.0413 0.0413 0.0404 0.0395 0.0391 0.0387;
                                                       0.0142 0.0142 0.0139 0.0136 0.01335 0.0131;
                                                       0.0102 0.0102 0.00995 0.0097 0.00945 0.0092;
                                                       0.0052 0.0052 0.00515 0.0051 0.0051 0.0051;
                                                       0.0041 0.0041 0.0039 0.0037 0.0037 0.0037;
                                                       0.0028 0.0028 0.00265 0.0025 0.0025 0.0025;
                                                       0.0024 0.0024 0.0022 0.002 0.002 0.002;
                                                       0.002 0.002 0.0019 0.0018 0.0018 0.0018];

battery.cell.transient_C_discharge_short_term_Farads.axis_1.signal      = 'soc_norm';
battery.cell.transient_C_discharge_short_term_Farads.axis_1.breakpoints = [0.1 0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.cell.transient_C_discharge_short_term_Farads.table              = 0.75.*[1306.8/2 1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2];

battery.cell.transient_C_charge_short_term_Farads.axis_1.signal        = 'soc_norm';
battery.cell.transient_C_charge_short_term_Farads.axis_1.breakpoints   = [0.1 0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.cell.transient_C_charge_short_term_Farads.table                = 0.75.*[1306.8/2 1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2];

battery.cell.transient_C_discharge_long_term_Farads.axis_1.signal      = 'soc_norm';
battery.cell.transient_C_discharge_long_term_Farads.axis_1.breakpoints = [0.1 0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.cell.transient_C_discharge_long_term_Farads.table              = 0.75.*[1306.8/2 1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2];

battery.cell.transient_C_charge_long_term_Farads.axis_1.signal         = 'soc_norm';
battery.cell.transient_C_charge_long_term_Farads.axis_1.breakpoints    = [0.1 0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
battery.cell.transient_C_charge_long_term_Farads.table                 = 0.75.*[1306.8/2 1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2];

battery.charge_efficiency_map_norm.axis_1.signal                       = 'soc_norm';
battery.charge_efficiency_map_norm.axis_1.breakpoints                  = [0 0.8 0.85 0.9 1];
battery.charge_efficiency_map_norm.table                               = [0.99 0.99 0.99 0.98 0.97];

%%
battery.cell.temperature_power_derate_index_temp_degC  = [-30 -20 -10 0 10 20 30 40 50 55];
battery.cell.temperature_power_discharge_derate_norm   = [0.0861 0.2161 0.3833 0.5706 0.7608 0.9368 1.0815 1.1779 1.2088 0.0861];
battery.cell.temperature_power_charge_derate_norm      = [0.029 0.04845 0.0679 0.2641 0.5232 0.8039 1.0649 1.265 1.3629 0.029];
battery.use_second_order_model                         = false;
battery.use_first_order_model                          = false;

% battery.discharge_derate_soc_norm  = [0.3 0.33];
battery.discharge_derate_soc_norm  = [0.05 0.1];
battery.charge_derate_soc_norm     = [0.92 0.95];
battery.thermal.initial_temp_degC  = 22.25;

battery.thermal.pack_mass_kg                           = 0.233 * battery.num_cells;
battery.thermal.specific_heat_capacity_JpkgK           = 795;     % lithium-polymer = 795 for 6AH, NREL A.A. Pesaran & M. Keyser thermal characteristics of selected EV & HEV batteries
battery.thermal.heat_transfer_coefficient_Wpm2K        = 10.5 * 0.3; % Base * hrate_cal
battery.thermal.pack_heat_transfer_area_m2             = 8.698186 * battery.num_cells;

end