% ALPHA ELECTRIC MOTOR DEFINITION
% Generated 22-Sep-2022 09:34:41

% SUGGESTED CITATION:
% 2010 Toyota Prius 60kW 650V MG2 EMOT - ALPHA Map Package. Version 2022-09. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2022.

% modifications:  electrical_source = 'boost', gear.efficiency_norm = 0.98

% Constructor
mg = class_REVS_emachine_geared();
mg.name =  '2010 Toyota Prius 60kW 650V MG2 EMOT'; 
mg.source_filename = mfilename;

% Physical Description
mg.electrical_source =  'boost'; 
mg.inertia_kgm2 =  0.010773666999999999;
mg.gear.ratio =  3.82;
mg.gear.efficiency_norm =  0.98;

% Capacity Limits
mg.max_speed_radps =  1413.7166941154069; 
mg.max_torque_Nm =  207; 
mg.max_motor_power_W =  60000; 
mg.max_generator_power_W =  60000; 
mg.positive_torque_limit_Nm = class_REVS_dynamic_lookup;
mg.positive_torque_limit_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.positive_torque_limit_Nm.axis_1.breakpoints = [	     0.0000000000000000	    104.71975511965977	    209.43951023931953	    314.15926535897933	    418.87902047863906	    523.59877559829886	    628.31853071795865	    733.03828583761833	    837.75804095727813	    942.47779607693792	    1047.1975511965977	    1151.9173063162575	    1256.6370614359173	    1361.3568165555769		]; 
mg.positive_torque_limit_Nm.axis_2.signal =  'emach_voltage_V'; 
mg.positive_torque_limit_Nm.axis_2.breakpoints =  650; 
mg.positive_torque_limit_Nm.table = [	     199.84252000000001	;     200.12598399999999	;     199.84252000000001	;     190.20472400000000	;     144.56692899999999	;     107.14960600000001	;     80.503936999999993	;     66.897638000000001	;     52.724409000000001	;     46.488188999999998	;     40.251969000000003	;     33.448819000000000	;     30.047243999999999	;     25.228345999999998		]; 
mg.negative_torque_limit_Nm = class_REVS_dynamic_lookup;
mg.negative_torque_limit_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.negative_torque_limit_Nm.axis_1.breakpoints = [	     0.0000000000000000	    104.71975511965977	    209.43951023931953	    314.15926535897933	    418.87902047863906	    523.59877559829886	    628.31853071795865	    733.03828583761833	    837.75804095727813	    942.47779607693792	    1047.1975511965977	    1151.9173063162575	    1256.6370614359173	    1361.3568165555769		]; 
mg.negative_torque_limit_Nm.axis_2.signal =  'emach_voltage_V'; 
mg.negative_torque_limit_Nm.axis_2.breakpoints =  650; 
mg.negative_torque_limit_Nm.table = [	    -199.84252000000001	;    -200.12598399999999	;    -199.84252000000001	;    -190.20472400000000	;    -144.56692899999999	;    -107.14960600000001	;    -80.503936999999993	;    -66.897638000000001	;    -52.724409000000001	;    -46.488188999999998	;    -40.251969000000003	;    -33.448819000000000	;    -30.047243999999999	;    -25.228345999999998		]; 

% Losses & Efficiency
mg.electric_power_W = class_REVS_dynamic_lookup;
mg.electric_power_W.axis_1.signal =  'emach_trq_Nm'; 
mg.electric_power_W.axis_1.breakpoints = [	    -200.00000000000000	   -190.00000000000000	   -180.00000000000000	   -170.00000000000000	   -160.00000000000000	   -150.00000000000000	   -140.00000000000000	   -130.00000000000000	   -120.00000000000000	   -110.00000000000000	   -100.00000000000000	   -90.000000000000000	   -80.000000000000000	   -69.999999999999986	   -60.000000000000000	   -50.000000000000000	   -40.000000000000000	   -30.000000000000000	   -20.000000000000000	   -10.000000000000000	    0.0000000000000000	    10.000000000000000	    20.000000000000000	    30.000000000000000	    40.000000000000000	    50.000000000000000	    60.000000000000000	    69.999999999999986	    80.000000000000000	    90.000000000000000	    100.00000000000000	    110.00000000000000	    120.00000000000000	    130.00000000000000	    140.00000000000000	    150.00000000000000	    160.00000000000000	    170.00000000000000	    180.00000000000000	    190.00000000000000	    200.00000000000000		]; 
mg.electric_power_W.axis_2.signal =  'emach_spd_radps'; 
mg.electric_power_W.axis_2.breakpoints = [	    -1361.3568165555766	   -1256.6370614359173	   -1151.9173063162575	   -1047.1975511965977	   -942.47779607693792	   -837.75804095727813	   -733.03828583761833	   -628.31853071795865	   -523.59877559829886	   -418.87902047863901	   -314.15926535897938	   -209.43951023931959	   -78.539816339744846	    0.0000000000000000	    78.539816339744846	    209.43951023931959	    314.15926535897938	    418.87902047863901	    523.59877559829886	    628.31853071795865	    733.03828583761833	    837.75804095727813	    942.47779607693792	    1047.1975511965977	    1151.9173063162575	    1256.6370614359173	    1361.3568165555766		]; 
mg.electric_power_W.table = [
    281386.85268410866	    260049.94887214541	    238724.83025275730	    217434.00634182047	    196208.83823964695	    175087.28963214086	    154114.15107280787	    133347.51585623840	    112870.51293447413	    92786.394015176280	    73087.967395654938	    53146.324231028593	    26375.932943094434	    11898.708603114646	   -4506.5951090462313	   -30066.558755541002	   -52062.933031743865	   -74314.684680306891	   -96161.459414104713	   -117595.70594531271	   -138725.83856697523	   -159639.14267873613	   -180396.61623991525	   -201045.28933169361	   -221625.02382427041	   -242168.74887297340	   -262700.09946947230	;
    267680.24959093751	    247388.07950838952	    227104.82147746821	    206848.46278997418	    186645.71625427160	    166530.55671176090	    146541.62896823644	    126719.03420439822	    107098.36211342856	    87701.643640807160	    68627.551802862872	    50367.034566433147	    23930.319701148113	    7560.4923713422641	   -5464.4227781250975	   -28691.302943460170	   -50306.104464316450	   -71066.652653582365	   -91488.442876437417	   -111675.08180002678	   -131649.70191710404	   -151449.67240551088	   -171117.09950498212	   -190692.56026160193	   -210211.72825884068	   -229702.65194548081	   -249184.21797791272	;
    253971.43868453504	    234724.20107242480	    215483.15446493699	    196261.68232360657	    177081.31533785438	    157971.33168379831	    138964.41673616637	    120086.78279777273	    101346.90152897587	    82733.364450412875	    64222.034806527248	    46573.969881558514	    21438.987575300453	    6964.3827313131687	   -6470.2552753003711	   -28380.510902672482	   -48491.632370609776	   -67696.325883684272	   -86793.701590347613	   -105758.41589726538	   -124578.48990110648	   -143262.81884524741	   -161838.92564764299	   -180341.12995175767	   -198800.17384251519	   -217238.66454380745	   -235670.65469024598	;
    240256.54258663129	    222054.60435560378	    203856.53635796977	    185671.06757417595	    167513.48169802959	    149406.84960645396	    131378.66942169797	    113449.53194890142	    95622.463453084521	    77924.539662414798	    60598.309988375266	    43463.799862489672	    19733.391011247102	    5646.0820984174288	   -6651.0654325916221	   -27352.679462788721	   -45856.278489810291	   -64158.571991270153	   -82070.586670268400	   -99846.999408862088	   -117516.23972162712	   -135081.48518683476	   -152564.35614988179	   -169993.72563912955	   -187393.81807534749	   -204780.68133703319	   -222163.48085365558	;
    226530.52410914964	    209374.23272950310	    192220.14801480764	    175072.56977525007	    157939.42324499809	    140835.55818962894	    123783.86556463838	    106809.77627395598	    89933.764646258802	    73171.055892520919	    56515.736651578547	    40071.273468748128	    17903.894543017006	    4799.1911247306543	   -6961.9704892684531	   -26621.322216311291	   -43702.715553587761	   -60562.710029846625	   -77309.945517670276	   -93938.212987836654	   -110463.49891186850	   -126907.30133487686	   -143296.32270598764	   -159654.59852847146	   -175997.72105618447	   -192334.01178500263	   -208667.98551562204	;
    212787.62102261622	    196677.11933822892	    180567.94234745417	    164460.68132586335	    148355.51849811742	    132257.19914550844	    116182.77420885963	    100165.50501317991	    84249.155481609108	    68447.954511655116	    52660.472276270069	    36911.597724121355	    16873.849614211344	    5104.7914954590751	   -6433.4514295496283	   -25645.471788263352	   -41310.478207802582	   -56934.946559943623	   -72545.010240787320	   -88034.167931933378	   -103417.35997576504	   -118740.53849157915	   -134038.62787063513	   -149329.53160079726	   -164618.23222742230	   -179904.92108640418	   -195190.21901709281	;
    199021.65770557834	    183956.90520045388	    168893.19308859672	    153828.59739787484	    138756.63955711041	    123671.03835767093	    108579.09295263398	    93515.690765505191	    78540.946387964534	    63709.785888730425	    48904.551710748165	    34009.569981190674	    15271.201992123984	    4512.9252551298714	   -6506.1651977765887	   -24399.090958434517	   -38813.929861741519	   -53323.003694202445	   -67804.854889349022	   -82135.943012273696	   -96373.940435130775	   -110581.96747918434	   -124796.65593911524	   -139025.66992565498	   -153262.41416973935	   -167500.08617163173	   -181736.66576059326	;
    185226.21037126382	    171207.36873184631	    157189.25060166110	    143168.65832969619	    129135.35320528170	    115073.30489035933	    100974.55185955265	    86864.839159549942	    72803.115056759634	    58887.436098453756	    45090.131904875299	    31387.054121909063	    13988.089519687232	    3661.6372744171258	   -6243.3670588704081	   -22859.222650774151	   -36378.805718048941	   -49799.451054180849	   -63095.802887349040	   -76238.807318808540	   -89331.423723194996	   -102435.54778023732	   -115578.21178895816	   -128751.05614771231	   -141937.24900153847	   -155126.03970423335	   -168314.07072223417	;
    171394.66032781004	    158422.84368606395	    145450.31849909533	    132473.16748625378	    119481.68210948861	    106455.05947916237	    93366.154988491646	    80218.427830928878	    67061.970633500881	    53940.841869027659	    41587.315303963165	    28643.886206357936	    12756.895247917539	    3863.4026179886723	   -5926.0548092638155	   -21446.039002196787	   -33616.498209147598	   -46406.355075266154	   -58390.229632005598	   -70337.009334142494	   -82292.955578137888	   -94310.665622369925	   -106393.77161996368	   -118513.77173379657	   -130648.82292974927	   -142788.73124286850	   -154929.38352847131	;
    157520.25334265415	    145598.39839869141	    133671.91945067918	    121735.51322378809	    109784.13734216288	    97801.048341233545	    85744.686176862611	    73574.607952037302	    61367.375682211001	    49188.829913543981	    37899.229589710936	    26250.172121339689	    11424.227520852015	    3356.6414788488992	   -5715.2896877178482	   -19665.928831559897	   -31048.723269253373	   -42808.947708711916	   -53635.779431094837	   -64432.490327260515	   -75268.212970677181	   -86223.337477570996	   -97255.398806078490	   -108320.75890985529	   -119401.83715110293	   -130493.33903517338	   -141589.69612349567	;
    143596.36792060730	    132729.70232307096	    121850.66104819333	    110951.16229107080	    100032.41801971055	    89090.284442049844	    78092.193052549381	    66932.661121049343	    55640.263958875228	    44569.957597169770	    34330.274353516397	    23711.575908208168	    10217.005071549424	    2691.9944805277241	   -5372.8070245207991	   -18037.944895441935	   -28355.861327398557	   -39071.743721092738	   -48915.471840832281	   -58526.004620079708	   -68276.045891534901	   -78195.599732089686	   -88173.909275076207	   -98176.777589678211	   -108199.85369422978	   -118244.41015513854	   -128301.96107725552	;
    129617.24881769039	    119812.55216570664	    109983.10200715257	    100117.77349426449	    90220.872344445525	    80301.571463091896	    70368.803788814039	    60293.877473684217	    49652.744544959380	    40120.402202132987	    30790.983854251612	    21255.608780897379	    9069.3878885849717	    2191.1837144246119	   -4967.7388316687029	   -16323.200419212215	   -25631.851411767500	   -35156.756966069261	   -44468.592325678794	   -52616.197570094941	   -61358.319758785845	   -70249.708520371321	   -79155.237414527248	   -88084.286026794565	   -97046.485907839320	   -106046.35806093477	   -115072.22139592898	;
    115579.45922333132	    106841.94022805580	    98064.059967169014	    89234.008976377314	    80349.173544819816	    71427.372683579728	    62509.532406913546	    53598.403666924809	    43927.068472046354	    35690.667615386781	    27314.018225812568	    19024.266435059704	    7951.7912814948113	    1830.4675983810955	   -4531.1490341486024	   -14372.599922435722	   -22842.400381769421	   -31220.958362340676	   -39746.777302472336	   -46765.915187474173	   -54583.269850110184	   -62393.577399234906	   -70199.726334557010	   -78044.688971045834	   -85947.175270338776	   -93904.440836031863	   -101904.08573061670	;
    101484.19959690335	    93810.305647251647	    86085.461838176619	    78297.619071638634	    70417.039804159285	    62485.933721267356	    54504.724324357288	    46393.155642632955	    38342.232207772111	    31260.486711382251	    23927.104885331439	    16449.276337708510	    6929.9251744000967	    1491.7002439808932	   -3994.0422116332807	   -12782.829564748419	   -19958.394449415518	   -27285.628391733324	   -34877.080480195160	   -41450.895733262441	   -47961.033477123055	   -54608.048470038666	   -61307.671942673311	   -68060.348571491195	   -74910.398526297475	   -81826.597386439855	   -88796.293598976685	;
    87340.231592531083	    80704.738725919873	    74037.511816969942	    67302.526291052680	    60419.860488334016	    53502.651829894996	    46488.913122458573	    39608.359019301883	    32882.844393072846	    26893.483081700062	    20538.932691405109	    14073.282804070339	    5929.8873435904497	    1214.8536893405110	   -3434.0156990186433	   -10984.112815162454	   -17075.710313179097	   -23283.962283087531	   -29875.662785864271	   -35694.402308041936	   -41350.350379445561	   -46866.454616355462	   -52483.915404712643	   -58137.646191576205	   -63946.441269081246	   -69826.382894401948	   -75739.645264178282	;
    73165.861704022245	    67505.042179729819	    61913.727816570834	    56229.174702811397	    50360.853099209591	    44518.038586117174	    38545.815009573256	    32999.184666583555	    27436.791158610795	    22509.689740965987	    17172.619100527034	    11757.579677196158	    4939.2024296694626	    1005.6905990398310	   -2864.1686236709111	   -9122.0911384742903	   -14170.074643742002	   -19299.925371046211	   -24860.243782284302	   -29753.505498678027	   -34663.318538303960	   -39126.258682697975	   -43725.078343716072	   -48297.115559699305	   -53062.109690017016	   -57925.004508465208	   -62714.918907723237	;
    58985.341414043032	    54191.822503661286	    49715.851337771004	    45021.841092261857	    40276.042616189676	    35517.958755152395	    30854.321353414849	    26463.837336062243	    22088.286427474963	    18121.161037259018	    13846.871733649214	    9457.5551031351260	    3972.0759862807422	    815.08068907980351	   -2269.5851542642981	   -7243.6069813323238	   -11221.844439104636	   -15320.860590126427	   -19742.398850211794	   -23735.090316007256	   -27712.102017599111	   -31402.302665586794	   -34993.334531309752	   -38597.266051246057	   -42255.575213273565	   -46142.825408900870	   -49696.650472812107	;
    44809.901254315671	    40789.195246342533	    37432.095429918569	    33568.637345691015	    30269.680933476808	    26767.789313761928	    23255.568277134917	    20003.671543945205	    16843.777852879735	    13754.658624896290	    10497.973766038123	    7176.6274517465390	    3018.7817183641769	    635.45541273491040	   -1660.4779006119220	   -5345.0710553842891	   -8297.9223652372020	   -11318.668203295194	   -14515.357953771658	   -17637.734518011988	   -20663.507888021868	   -23415.940739422578	   -26179.219478581032	   -29155.580185615196	   -31539.214137035346	   -34454.524269649250	   -36673.047901136510	;
    30591.283028876507	    27481.100395124377	    24919.192346346128	    22511.345102107847	    20421.641692313588	    18074.832994368324	    15732.477522278670	    13683.604922133303	    11471.591100182810	    9392.0223655546779	    7162.4155649152635	    4891.8910202535108	    2079.1052867868443	    473.93699989602032	   -1037.0719188033522	   -3450.5343485459171	   -5359.9935365571282	   -7312.4163557917873	   -9422.3791443383016	   -11393.274591196337	   -13535.468320949747	   -15369.505035161665	   -17198.865862225190	   -19298.187241847263	   -21063.457595303127	   -22666.964103992017	   -23694.782298458314	;
    16156.909951236370	    14450.894609133000	    12999.487149159984	    11718.257232233404	    10666.410115415765	    9544.8185806559995	    8248.5026256615038	    7211.3645034502124	    6037.1686924258738	    4945.7065179866722	    3804.3280142711869	    2610.5888882957097	    1144.5427800734444	    321.04927410627567	   -408.29631588765267	   -1552.3916271955563	   -2445.7205248743312	   -3394.0280759260936	   -4394.7477727179585	   -5308.5971510954296	   -6366.3571027265971	   -7151.9803299354026	   -8121.0641983906735	   -9163.3797056851781	   -9964.8432728652970	   -10587.620419846655	   -10943.059290591134	;
    1719.0028013250940	    1401.4172201311794	    1102.6963335142916	    944.57565388136175	    926.47491285783326	    944.22406394479799	    812.00180738106371	    720.73977434189828	    607.95542689716819	    509.30072312392213	    432.62148992685286	    332.86420660710496	    215.39084830523430	    156.34457205830103	    215.39084830523430	    332.86420660710496	    432.62148992685286	    509.30072312392213	    607.95542689716819	    720.73977434189828	    812.00180738106371	    944.22406394479799	    926.47491285783326	    944.57565388136175	    1102.6963335142916	    1401.4172201311794	    1719.0028013250940	;
   -10943.059290591134	   -10587.620419846655	   -9964.8432728652970	   -9163.3797056851781	   -8121.0641983906735	   -7151.9803299354026	   -6366.3571027265971	   -5308.5971510954296	   -4394.7477727179585	   -3394.0280759260936	   -2445.7205248743312	   -1552.3916271955563	   -408.29631588765267	    305.76121343454827	    1144.5427800734444	    2610.5888882957097	    3804.3280142711869	    4945.7065179866722	    6037.1686924258738	    7211.3645034502124	    8248.5026256615038	    9544.8185806559995	    10666.410115415765	    11718.257232233404	    12999.487149159984	    14450.894609133000	    16156.909951236370	;
   -23694.782298458314	   -22666.964103992017	   -21063.457595303127	   -19298.187241847263	   -17198.865862225190	   -15369.505035161665	   -13535.468320949747	   -11393.274591196337	   -9422.3791443383016	   -7312.4163557917873	   -5359.9935365571282	   -3450.5343485459171	   -1037.0719188033522	    451.36857132954316	    2079.1052867868443	    4891.8910202535108	    7162.4155649152635	    9392.0223655546779	    11471.591100182810	    13683.604922133303	    15732.477522278670	    18074.832994368324	    20421.641692313588	    22511.345102107847	    24919.192346346128	    27481.100395124377	    30591.283028876507	;
   -36673.047901136510	   -34454.524269649250	   -31539.214137035346	   -29155.580185615196	   -26179.219478581032	   -23415.940739422578	   -20663.507888021868	   -17637.734518011988	   -14515.357953771658	   -11318.668203295194	   -8297.9223652372020	   -5345.0710553842891	   -1660.4779006119220	    605.19563117610517	    3018.7817183641769	    7176.6274517465390	    10497.973766038123	    13754.658624896290	    16843.777852879735	    20003.671543945205	    23255.568277134917	    26767.789313761928	    30269.680933476808	    33568.637345691015	    37432.095429918569	    40789.195246342533	    44809.901254315671	;
   -49696.650472812107	   -46142.825408900870	   -42255.575213273565	   -38597.266051246057	   -34993.334531309752	   -31402.302665586794	   -27712.102017599111	   -23735.090316007256	   -19742.398850211794	   -15320.860590126427	   -11221.844439104636	   -7243.6069813323238	   -2269.5851542642981	    776.26732293314615	    3972.0759862807422	    9457.5551031351260	    13846.871733649214	    18121.161037259018	    22088.286427474963	    26463.837336062243	    30854.321353414849	    35517.958755152395	    40276.042616189676	    45021.841092261857	    49715.851337771004	    54191.822503661286	    58985.341414043032	;
   -62714.918907723237	   -57925.004508465208	   -53062.109690017016	   -48297.115559699305	   -43725.078343716072	   -39126.258682697975	   -34663.318538303960	   -29753.505498678027	   -24860.243782284302	   -19299.925371046211	   -14170.074643742002	   -9122.0911384742903	   -2864.1686236709111	    957.80057051412473	    4939.2024296694626	    11757.579677196158	    17172.619100527034	    22509.689740965987	    27436.791158610795	    32999.184666583555	    38545.815009573256	    44518.038586117174	    50360.853099209591	    56229.174702811397	    61913.727816570834	    67505.042179729819	    73165.861704022245	;
   -75739.645264178282	   -69826.382894401948	   -63946.441269081246	   -58137.646191576205	   -52483.915404712643	   -46866.454616355462	   -41350.350379445561	   -35694.402308041936	   -29875.662785864271	   -23283.962283087531	   -17075.710313179097	   -10984.112815162454	   -3434.0156990186433	    1157.0035136576294	    5929.8873435904497	    14073.282804070339	    20538.932691405109	    26893.483081700062	    32882.844393072846	    39608.359019301883	    46488.913122458573	    53502.651829894996	    60419.860488334016	    67302.526291052680	    74037.511816969942	    80704.738725919873	    87340.231592531083	;
   -88796.293598976685	   -81826.597386439855	   -74910.398526297475	   -68060.348571491195	   -61307.671942673311	   -54608.048470038666	   -47961.033477123055	   -41450.895733262441	   -34877.080480195160	   -27285.628391733324	   -19958.394449415518	   -12782.829564748419	   -3994.0422116332807	    1420.6668990294220	    6929.9251744000967	    16449.276337708510	    23927.104885331439	    31260.486711382251	    38342.232207772111	    46393.155642632955	    54504.724324357288	    62485.933721267356	    70417.039804159285	    78297.619071638634	    86085.461838176619	    93810.305647251647	    101484.19959690335	;
   -101904.08573061670	   -93904.440836031863	   -85947.175270338776	   -78044.688971045834	   -70199.726334557010	   -62393.577399234906	   -54583.269850110184	   -46765.915187474173	   -39746.777302472336	   -31220.958362340676	   -22842.400381769421	   -14372.599922435722	   -4531.1490341486024	    1743.3024746486624	    7951.7912814948113	    19024.266435059704	    27314.018225812568	    35690.667615386781	    43927.068472046354	    53598.403666924809	    62509.532406913546	    71427.372683579728	    80349.173544819816	    89234.008976377314	    98064.059967169014	    106841.94022805580	    115579.45922333132	;
   -115072.22139592898	   -106046.35806093477	   -97046.485907839320	   -88084.286026794565	   -79155.237414527248	   -70249.708520371321	   -61358.319758785845	   -52616.197570094941	   -44468.592325678794	   -35156.756966069261	   -25631.851411767500	   -16323.200419212215	   -4967.7388316687029	    2086.8416327853447	    9069.3878885849717	    21255.608780897379	    30790.983854251612	    40120.402202132987	    49652.744544959380	    60293.877473684217	    70368.803788814039	    80301.571463091896	    90220.872344445525	    100117.77349426449	    109983.10200715257	    119812.55216570664	    129617.24881769039	;
   -128301.96107725552	   -118244.41015513854	   -108199.85369422978	   -98176.777589678211	   -88173.909275076207	   -78195.599732089686	   -68276.045891534901	   -58526.004620079708	   -48915.471840832281	   -39071.743721092738	   -28355.861327398557	   -18037.944895441935	   -5372.8070245207991	    2563.8042671692610	    10217.005071549424	    23711.575908208168	    34330.274353516397	    44569.957597169770	    55640.263958875228	    66932.661121049343	    78092.193052549381	    89090.284442049844	    100032.41801971055	    110951.16229107080	    121850.66104819333	    132729.70232307096	    143596.36792060730	;
   -141589.69612349567	   -130493.33903517338	   -119401.83715110293	   -108320.75890985529	   -97255.398806078490	   -86223.337477570996	   -75268.212970677181	   -64432.490327260515	   -53635.779431094837	   -42808.947708711916	   -31048.723269253373	   -19665.928831559897	   -5715.2896877178482	    3196.8014084275228	    11424.227520852015	    26250.172121339689	    37899.229589710936	    49188.829913543981	    61367.375682211001	    73574.607952037302	    85744.686176862611	    97801.048341233545	    109784.13734216288	    121735.51322378809	    133671.91945067918	    145598.39839869141	    157520.25334265415	;
   -154929.38352847131	   -142788.73124286850	   -130648.82292974927	   -118513.77173379657	   -106393.77161996368	   -94310.665622369925	   -82292.955578137888	   -70337.009334142494	   -58390.229632005598	   -46406.355075266154	   -33616.498209147598	   -21446.039002196787	   -5926.0548092638155	    3679.4310647511165	    12756.895247917539	    28643.886206357936	    41587.315303963165	    53940.841869027659	    67061.970633500881	    80218.427830928878	    93366.154988491646	    106455.05947916237	    119481.68210948861	    132473.16748625378	    145450.31849909533	    158422.84368606395	    171394.66032781004	;
   -168314.07072223417	   -155126.03970423335	   -141937.24900153847	   -128751.05614771231	   -115578.21178895816	   -102435.54778023732	   -89331.423723194996	   -76238.807318808540	   -63095.802887349040	   -49799.451054180849	   -36378.805718048941	   -22859.222650774151	   -6243.3670588704081	    3487.2735946829766	    13988.089519687232	    31387.054121909063	    45090.131904875299	    58887.436098453756	    72803.115056759634	    86864.839159549942	    100974.55185955265	    115073.30489035933	    129135.35320528170	    143168.65832969619	    157189.25060166110	    171207.36873184631	    185226.21037126382	;
   -181736.66576059326	   -167500.08617163173	   -153262.41416973935	   -139025.66992565498	   -124796.65593911524	   -110581.96747918434	   -96373.940435130775	   -82135.943012273696	   -67804.854889349022	   -53323.003694202445	   -38813.929861741519	   -24399.090958434517	   -6506.1651977765887	    4298.0240525046393	    15271.201992123984	    34009.569981190674	    48904.551710748165	    63709.785888730425	    78540.946387964534	    93515.690765505191	    108579.09295263398	    123671.03835767093	    138756.63955711041	    153828.59739787484	    168893.19308859672	    183956.90520045388	    199021.65770557834	;
   -195190.21901709281	   -179904.92108640418	   -164618.23222742230	   -149329.53160079726	   -134038.62787063513	   -118740.53849157915	   -103417.35997576504	   -88034.167931933378	   -72545.010240787320	   -56934.946559943623	   -41310.478207802582	   -25645.471788263352	   -6433.4514295496283	    4861.7061861515003	    16873.849614211344	    36911.597724121355	    52660.472276270069	    68447.954511655116	    84249.155481609108	    100165.50501317991	    116182.77420885963	    132257.19914550844	    148355.51849811742	    164460.68132586335	    180567.94234745417	    196677.11933822892	    212787.62102261622	;
   -208667.98551562204	   -192334.01178500263	   -175997.72105618447	   -159654.59852847146	   -143296.32270598764	   -126907.30133487686	   -110463.49891186850	   -93938.212987836654	   -77309.945517670276	   -60562.710029846625	   -43702.715553587761	   -26621.322216311291	   -6961.9704892684531	    4570.6582140291948	    17903.894543017006	    40071.273468748128	    56515.736651578547	    73171.055892520919	    89933.764646258802	    106809.77627395598	    123783.86556463838	    140835.55818962894	    157939.42324499809	    175072.56977525007	    192220.14801480764	    209374.23272950310	    226530.52410914964	;
   -222163.48085365558	   -204780.68133703319	   -187393.81807534749	   -169993.72563912955	   -152564.35614988179	   -135081.48518683476	   -117516.23972162712	   -99846.999408862088	   -82070.586670268400	   -64158.571991270153	   -45856.278489810291	   -27352.679462788721	   -6651.0654325916221	    5377.2210461118366	    19733.391011247102	    43463.799862489672	    60598.309988375266	    77924.539662414798	    95622.463453084521	    113449.53194890142	    131378.66942169797	    149406.84960645396	    167513.48169802959	    185671.06757417595	    203856.53635796977	    222054.60435560378	    240256.54258663129	;
   -235670.65469024598	   -217238.66454380745	   -198800.17384251519	   -180341.12995175767	   -161838.92564764299	   -143262.81884524741	   -124578.48990110648	   -105758.41589726538	   -86793.701590347613	   -67696.325883684272	   -48491.632370609776	   -28380.510902672482	   -6470.2552753003711	    6632.7454583934941	    21438.987575300453	    46573.969881558514	    64222.034806527248	    82733.364450412875	    101346.90152897587	    120086.78279777273	    138964.41673616637	    157971.33168379831	    177081.31533785438	    196261.68232360657	    215483.15446493699	    234724.20107242480	    253971.43868453504	;
   -249184.21797791272	   -229702.65194548081	   -210211.72825884068	   -190692.56026160193	   -171117.09950498212	   -151449.67240551088	   -131649.70191710404	   -111675.08180002678	   -91488.442876437417	   -71066.652653582365	   -50306.104464316450	   -28691.302943460170	   -5464.4227781250975	    7200.4689250878700	    23930.319701148113	    50367.034566433147	    68627.551802862872	    87701.643640807160	    107098.36211342856	    126719.03420439822	    146541.62896823644	    166530.55671176090	    186645.71625427160	    206848.46278997418	    227104.82147746821	    247388.07950838952	    267680.24959093751	;
   -262700.09946947230	   -242168.74887297340	   -221625.02382427041	   -201045.28933169361	   -180396.61623991525	   -159639.14267873613	   -138725.83856697523	   -117595.70594531271	   -96161.459414104713	   -74314.684680306891	   -52062.933031743865	   -30066.558755541002	   -4506.5951090462313	    11332.103431537758	    26375.932943094434	    53146.324231028593	    73087.967395654938	    92786.394015176280	    112870.51293447413	    133347.51585623840	    154114.15107280787	    175087.28963214086	    196208.83823964695	    217434.00634182047	    238724.83025275730	    260049.94887214541	    281386.85268410866	]; 
mg.unpowered_torque_loss_Nm = class_REVS_dynamic_lookup;
mg.unpowered_torque_loss_Nm.axis_1.signal =  'emach_spd_radps'; 
mg.unpowered_torque_loss_Nm.axis_1.breakpoints = [	    -15000.000000000000	    15000.000000000000		]; 
mg.unpowered_torque_loss_Nm.table = [	     0.0000000000000000	    0.0000000000000000		]; 
