%% clear workspace
clearvars -except generate_DORS

if ~exist('generate_DORS', 'var')
    generate_DORS = true;  % enable DOR plots if not running all simulations
end

%% define and run sim batch
sim_batch = class_REVS_sim_batch();
sim_batch.descriptor = strrep(mfilename, 'run_', '');
sim_batch.param_path = 'param_files/BEV';

sim_batch.add_log(REVS_log_all);

sim_batch.verbose                     = 3;
sim_batch.output_verbose              = 1;
sim_batch.retain_output_workspace     = true;
sim_batch.logging_config.audit_phase  = true;

sim_batch.setup_data_columns = 'setup_custom_data_columns';

open(sim_batch.model);

sim_batch.add_config_opt(REVS_config_EVM_metapackage);


BASE         = 'DRV:BEV_driver + CON:BEV_controls';
VEHICLE      = 'VEH:vehicle_BEV + ETW_LBS:4250 + TRGA_LBS:30.0 + TRGB_LBS:0.0 + TRGC_LBS:0.02';
ELECTRICAL   = horzcat(['ELEC:{''BEV_electric'',''emachine_IPM_150kW_350V_EDU_v2''} + '], ...
                       ['PROP_BATT:battery_pack_NMC_58kWh + PROP_SOC:0.90 + MOT_PMAX:[150]']);
ACCESSORY    = 'ACC:BEV_accessories';
TRANSMISSION = 'TRANS:BEV_transmission';

base_config = [BASE ' + ' VEHICLE ' + ' ELECTRICAL ' + ' ACCESSORY ' + ' TRANSMISSION];

CYCLE = 'CYC:{''EPA_UDDS'',''EPA_HWFET'',''REVS_composite_EPA_US06_car''}';

config_strings = {
    [base_config ' + VEH_TYPE:BEV + PKG:BEV + ' CYCLE]
};

sim_batch.load_config_strings(config_strings);

sim_batch.run_sim_cases();

%% extract output workspace and post-process
sim_batch.sim_case(1).extract_workspace;

audit.print

result.print

%% plot some key results if enabeled
if generate_DORS
    REVS_DOR_EVM({}, model_data, 'accessory_plots');
    
    REVS_plot_emachine(electric.drive_motor, 'efficiency', 'heatmap', model_data.emachine, 'time', model_data.time);
end
