%% clear workspace
clearvars -except generate_DORS

if ~exist('generate_DORS', 'var')
    generate_DORS = true;  % enable DOR plots if not running all simulations
end

%% define and run sim batch
sim_batch = class_REVS_sim_batch();
sim_batch.descriptor = strrep(mfilename, 'run_', '');
sim_batch.param_path = 'param_files/CVM_P0';

sim_batch.add_log(REVS_log_all);

sim_batch.verbose                     = 3;
sim_batch.output_verbose              = 1;
sim_batch.retain_output_workspace     = true;
sim_batch.logging_config.audit_phase  = true;

sim_batch.setup_data_columns = 'setup_custom_data_columns';

open(sim_batch.model);

sim_batch.add_config_opt(REVS_config_CVM_metapackage);

sim_batch.add_case_preprocess_script('CVM_P0_P2_preprocess', 6);

BASE         = 'DRV:CVM_P0_driver + CON:P0_controls';
VEHICLE      = 'VEH:vehicle_CVM_P0 + ETW_LBS:3500 + TRGA_LBS:30.0 + TRGB_LBS:0.0 + TRGC_LBS:0.02';
ELECTRICAL   = 'ELEC:{''P0_electric'',''emachine_2012_Hyundai_Sonata_8p5kW_270V_BISG'',''P0_battery_pack''}';
ACCESSORY    = 'ACC:accessory_EPS_param';
ENGINE       = 'ENG:engine_2018_Toyota_A25AFKS_2L5_Tier3 + ES_KW:[150] + SS:1';
TRANSMISSION = 'PTRAIN:hybrid_P0 + TRANS:transmission_6AT_FWD_midsize_car';

CYCLE = 'CYC:{''EPA_UDDS'',''EPA_HWFET'',''REVS_composite_EPA_US06_car''}';

base_config = [BASE ' + ' VEHICLE ' + ' ELECTRICAL ' + ' ACCESSORY ' + '  ENGINE ' + ' TRANSMISSION];

config_strings = {
    [base_config ' + VEH_TYPE:MHEV + PKG:48V_P0 + ' CYCLE]
};

sim_batch.load_config_strings(config_strings);

sim_batch.run_sim_cases();

%% extract output workspace and post-process
sim_batch.sim_case(1).extract_workspace;

audit.print

result.print

%% plot some key results if enabeled
if generate_DORS
    REVS_DOR_HVM({}, model_data, 'engine', engine, 'accessory_plots', 'time_range', [0 2740]);
end
