%% clear workspace
clearvars -except generate_DORS

if ~exist('generate_DORS', 'var')
    generate_DORS = true;  % enable DOR plots if not running all simulations
end

%% define and run sim batch
sim_batch = class_REVS_sim_batch();
sim_batch.descriptor = strrep(mfilename, 'run_', '');
sim_batch.param_path = 'param_files/P2_PHEV';

sim_batch.add_log(REVS_log_all);

sim_batch.verbose                     = 3;
sim_batch.output_verbose              = 1;
sim_batch.retain_output_workspace     = true;
sim_batch.logging_config.audit_phase  = true;

sim_batch.setup_data_columns = 'setup_custom_data_columns';

open(sim_batch.model);

sim_batch.add_config_opt(REVS_config_HVM_metapackage);

sim_batch.add_case_preprocess_script('CVM_P0_P2_preprocess', 6);

BASE         = 'DRV:P2_driver + CON:P2_controls';
VEHICLE      = 'VEH:vehicle_P2 + ETW_LBS:3500 + TRGA_LBS:30.0 + TRGB_LBS:0.0 + TRGC_LBS:0.02';
ELECTRICAL   = horzcat(['ELEC:{''P2_electric'',''emachine_2012_Hyundai_Sonata_8p5kW_270V_BISG'',''emachine_2011_Hyundai_Sonata_30kW_270V_EMOT''} + '], ...
                       ['PROP_BATT:battery_9p8_kWh_NCM ']);
ACCESSORY    = 'ACC:P2_accessories';
ENGINE       = 'ENG:engine_2018_Toyota_A25AFKS_2L5_Tier3 + ES_KW:[150] + SS:1';
TRANSMISSION = 'PTRAIN:hybrid_P2_BAS + TRANS:TRX12_FWD_P2_Hybrid';

CYCLE = 'CYC:{''EPA_UDDS'',''EPA_HWFET'',''REVS_composite_EPA_US06_car''}';

base_config = [BASE ' + ' VEHICLE ' + ' ELECTRICAL ' + ' ACCESSORY ' + '  ENGINE ' + ' TRANSMISSION];

config_strings = {
     [base_config ' + VEH_TYPE:PHEV + PKG:CD + ' CYCLE ' + PROP_SOC:0.92']  % charge-depleting
     [base_config ' + VEH_TYPE:PHEV + PKG:CS + ' CYCLE ' + PROP_SOC:0.14']  % charge-sustaining
};

sim_batch.load_config_strings(config_strings);

sim_batch.run_sim_cases();

%% extract output workspace and post-process
sim_batch.sim_case(end).extract_workspace;

audit.print

result.print

%% plot some key results if enabeled
if generate_DORS
    REVS_DOR_HVM({}, model_data, 'engine', engine, 'accessory_plots', 'time_range', [0 2740]);
end
