%% clear workspace
clearvars -except generate_DORS

if ~exist('generate_DORS', 'var')
    generate_DORS = true;  % enable DOR plots if not running all simulations
end

%% define and run sim batch
sim_batch = class_REVS_sim_batch();
sim_batch.descriptor = strrep(mfilename, 'run_', '');
sim_batch.param_path = 'param_files/PS_HEV';

sim_batch.add_log(REVS_log_all);

sim_batch.verbose                     = 3;
sim_batch.output_verbose              = 1;
sim_batch.retain_output_workspace     = true;
sim_batch.logging_config.audit_phase  = true;

sim_batch.setup_data_columns = 'setup_custom_data_columns';

open(sim_batch.model);

sim_batch.add_config_opt(REVS_config_HVM_metapackage);

sim_batch.add_case_preprocess_script('PS_preprocess', 6);

BASE         = 'DRV:PS_driver + CON:PS_controls';
VEHICLE      = 'VEH:vehicle_PS + ETW_LBS:3500 + TRGA_LBS:30.0 + TRGB_LBS:0.0 + TRGC_LBS:0.02';
ELECTRICAL   = horzcat(['ELEC:PS_electric + MG1:emachine_2010_Toyota_Prius_60kW_650V_MG1_EMOT + MG2:emachine_2010_Toyota_Prius_60kW_650V_MG2_EMOT + '], ...
                       ['PROP_BATT:battery_base_Samsung_LI_Power_mod2 + PROP_BATT_NS:59 + PROP_BATT_NP:1 + PROP_CELL_CAP:4 + PROP_SOC:0.55 + PROP_SOC_CS_NORM:0.5']);
ACCESSORY    = 'ACC:PS_accessories';
ENGINE       = 'ENG:engine_2018_Toyota_A25AFKS_2L5_Tier3 + ES_KW:[150] + SS:1';
TRANSMISSION = 'TRANS:PS_transmission_ECVT';

CYCLE = 'CYC:{''EPA_UDDS'',''EPA_HWFET'',''REVS_composite_EPA_US06_car''}';

base_config = [BASE ' + ' VEHICLE ' + ' ELECTRICAL ' + ' ACCESSORY ' + '  ENGINE ' + ' TRANSMISSION];

config_strings = {
    [base_config ' + VEH_TYPE:HEV + PKG:CS + ' CYCLE]
};

sim_batch.load_config_strings(config_strings);

sim_batch.run_sim_cases();

%% extract output workspace and post-process
sim_batch.sim_case(1).extract_workspace;

audit.print

result.print

%% plot some key results if enabeled
if generate_DORS
    REVS_DOR_HVM({}, model_data, 'engine', engine, 'accessory_plots', 'time_range', [0 2740]);
end
