%% final drive ratio (displacement-based)
targetN_at60 = interp1([-9999 1 2 3 4 5 6 7 9999],[2250, 2250, 1750, 1700, 1600, 1500, 1450, 1300, 1300], engine.displacement_L) ;    

vehicle.drive_axle1.final_drive.gear_ratio = targetN_at60 * vehicle.drive_axle1.tire.radius_m / (unit_convert.mph2mps * unit_convert.radps2rpm * transmission.gear.ratio(end) * 60);

%% torque converter torque ratio
if isprop(transmission,'torque_converter') && isempty(sim_config.TC_torque_ratio)
    transmission.torque_converter.drive_torque_ratio = interp1([0 0.875 1],[2.2 1 1], transmission.torque_converter.speed_ratio);
    transmission.torque_converter.decel_torque_ratio = 0.98 * ones(size(transmission.torque_converter.speed_ratio));
end

%% torque converter K-factor
if isprop(transmission,'torque_converter') && isempty(sim_config.TC_K_factor) && isempty(sim_config.TC_stall_rpm) 
    temp.stall_rpm = 3250;
    temp.stall_torque_Nm     = transmission.rated_torque_Nm; 
    temp.K_factor_rpmpsqrtNm = temp.stall_rpm/sqrt(temp.stall_torque_Nm);

    % re-scale K-factor but maintain original K-factor v. SR curve:
    transmission.torque_converter.drive_k_factor_rpmpsqrtNm = temp.K_factor_rpmpsqrtNm * normalize(transmission.torque_converter.drive_k_factor_rpmpsqrtNm, 1);
    transmission.torque_converter.decel_k_factor_rpmpsqrtNm = 0.7*transmission.torque_converter.drive_k_factor_rpmpsqrtNm(1) + transmission.torque_converter.drive_k_factor_rpmpsqrtNm;
end

%% normalize ALPHAshift calibration
if  transmission.type == enum_transmission_type.automatic  
 
    transmission.gear_strategy = class_REVS_ALPHAshift( transmission.gear.number(end), engine);
    
    redline_rpm = min(engine.full_throttle_speed_radps(end) - 650 * unit_convert.rpm2radps, REVS_calc_engine_power_speed(engine, 0.98, 'max')) * unit_convert.radps2rpm;

    if vehicle.powertrain_type.is_P2()
        redline_rpm = min(electric.P2_MG.max_speed_radps * unit_convert.radps2rpm - 650, redline_rpm);
    end
        
    if transmission.matrix_vintage == enum_matrix_vintage.future
        transmission.gear_strategy.min_speed_radps					= [0 linspace(800 * unit_convert.rpm2radps, 1050 * unit_convert.rpm2radps, length(transmission.gear.number)-1)];
        transmission.gear_strategy.upshift_min_speed_radps			= 1050 * unit_convert.rpm2radps * ones(size(transmission.gear.number));
        transmission.gear_strategy.required_cost_benefit_ratio      = 1.05 * ones(size(transmission.gear.number));
        transmission.gear_strategy.disable_cost_saving_downshifts   = true; % false;
    else
        transmission.gear_strategy.min_speed_radps					= [0 linspace(800 * unit_convert.rpm2radps, 1200 * unit_convert.rpm2radps, length(transmission.gear.number)-1)];
        transmission.gear_strategy.upshift_min_speed_radps			= 1200 * unit_convert.rpm2radps * ones(size(transmission.gear.number));
        transmission.gear_strategy.required_cost_benefit_ratio      = 1.05 * ones(size(transmission.gear.number));
        transmission.gear_strategy.disable_cost_saving_downshifts   = true;
    end

    transmission.gear_strategy.min_speed_radps					= max(transmission.gear_strategy.min_speed_radps, engine.idle_speed_radps.table(1));
    transmission.gear_strategy.upshift_min_speed_radps			= max( transmission.gear_strategy.upshift_min_speed_radps, transmission.gear_strategy.min_speed_radps + 10);

    transmission.gear_strategy.upshift_min_torque_reserve_ratio = 1.15 * ones(size(transmission.gear.number));
    transmission.gear_strategy.min_speed_shift_increment        = ones(size(transmission.gear.number));
    transmission.gear_strategy.max_speed_radps					= redline_rpm * unit_convert.rpm2radps * ones(size(transmission.gear.number));
    transmission.gear_strategy.max_speed_radps(2)               = transmission.gear_strategy.max_speed_radps(2) * 0.90; % shift a little earlier in 1st gear to prevent over-rev
    
    transmission.gear_strategy.downshift_max_speed_radps 		= 0.80 * transmission.gear_strategy.max_speed_radps;
    
    transmission.gear_strategy.max_speed_shift_increment        = ones(size(transmission.gear.number));
    transmission.gear_strategy.kickdown_trigger_ratio           = 0.85 * ones(size(transmission.gear.number));
    transmission.gear_strategy.kickdown_delay_secs              = 0.05 * ones(size(transmission.gear.number));

    transmission.gear_strategy.upshift_min_speed_radps = max(transmission.gear_strategy.upshift_min_speed_radps, 1000 * unit_convert.rpm2radps);

    transmission.gear_strategy.kickdown_min_gear = 2;
    transmission.gear_strategy.kickdown_max_increment = max(2, transmission.gear.number(end)/2);

end

if vehicle.powertrain_type.is_P0()
    % pack capacity is nominal for a 115 KW engine
    electric.propulsion_battery.capacity_nominal_Ah = electric.propulsion_battery.capacity_nominal_Ah * engine.max_power_W / 115000;

    % size P0 emachine relative to engine power
    electric.P0_MG = REVS_modify_emachine(electric.P0_MG, 'scale_max_power_kW', 8.5/115 * engine.max_power_W/1000);
end

if vehicle.powertrain_type.is_P2()
    
    electric.P2_MG.max_speed_radps
    
    % pack capacity is nominal for a 115 KW engine
    electric.propulsion_battery.capacity_nominal_Ah = electric.propulsion_battery.capacity_nominal_Ah * engine.max_power_W / 115000;
    
    % size P0 and P2 emachines relative to engine power
    electric.P0_MG = REVS_modify_emachine(electric.P0_MG, 'scale_max_power_kW', 8.5/115 * engine.max_power_W/1000);
    electric.P2_MG = REVS_modify_emachine(electric.P2_MG, 'scale_max_power_kW', 50/115 * engine.max_power_W/1000);
    
    vehicle.drive_axle1.final_drive.gear_ratio = vehicle.drive_axle1.final_drive.gear_ratio * 1.25;
end

clear temp
