%% for vehicle-specific m-files:
clear; clc;
sanitize.mfiles = dir('*.m');
[~, sanitize.folder_name] = fileparts(sanitize.mfiles(1).folder);

for f = 1:length(sanitize.mfiles)
    clearvars -except sanitize f
    
    % load an engine so param files that depend on engine don't fail
    run('engine_2018_Toyota_A25AFKS_2L5_Tier3.m');
    
    run(sanitize.mfiles(f).name);
    
    sanitize.new_file_basename = [strrep(sanitize.mfiles(f).name,'.m','') '_' sanitize.folder_name];
    
    if ~isempty(strfind(sanitize.mfiles(f).name, 'TRX')) || ~isempty(strfind(sanitize.mfiles(f).name, 'transmission'))
        transmission.name = sanitize.new_file_basename;
        
        export2mfile([sanitize.new_file_basename '.m'], {'transmission'});
        
        movefile(sanitize.mfiles(f).name, '_sequester');
    else
        sanitize.workspace_vars = who();
        sanitize.param_vars = setdiff(sanitize.workspace_vars,{'f','engine','sanitize','ans'});
        
        % try to fix object names
        try
            electric.name = sanitize.new_file_basename;
        end
        
        try
            accessories.name = sanitize.new_file_basename;
        end
        
        try
            vehicle.name  = sanitize.folder_name;
            vehicle.class = sanitize.folder_name;
        end
        
        export2mfile([sanitize.new_file_basename '.m'], sanitize.param_vars);
        
        movefile(sanitize.mfiles(f).name, '_sequester');
    end
end

%% for m-files that don't get renamed (common params)
clear; clc;
sanitize.mfiles = dir('*.m');
[~, sanitize.folder_name] = fileparts(sanitize.mfiles(1).folder);

for f = 1:length(sanitize.mfiles)
    clearvars -except sanitize f
    
    sanitize.mfiles(f).name
    
    run(sanitize.mfiles(f).name);
    
    sanitize.workspace_vars = who();
    sanitize.param_vars = setdiff(sanitize.workspace_vars,{'f','engine','sanitize','ans'});
    
    movefile(sanitize.mfiles(f).name, '_sequester');
    
    export2mfile(sanitize.mfiles(f).name, sanitize.param_vars);

end
