% setup up custom data columns

if vehicle.powertrain_type.is_PS || vehicle.powertrain_type.is_P0 || vehicle.powertrain_type.is_bev
    data_columns(end+1) = class_data_column({' ',' '}, separator, '0');
    data_columns(end+1) = class_data_column({'Prop Batt Nom V','V'}, prec3_str, 'mean(mean(electric.propulsion_battery.open_circuit_voltage_map_discharge_V.table))', 1);
    data_columns(end+1) = class_data_column({'Prop Batt Ah','Ah'}, prec3_str, 'electric.propulsion_battery.capacity_nominal_Ah', 1);
    data_columns(end+1) = class_data_column({'Prop Batt Nom kWh','kWh'}, prec3_str, 'mean(mean(electric.propulsion_battery.open_circuit_voltage_map_discharge_V.table)) * electric.propulsion_battery.capacity_nominal_Ah / 1000', 1);
end

data_columns(end+1) = class_data_column({' ',' '}, separator, '0');

if vehicle.powertrain_type.is_PS  % powersplit
    data_columns(end+1) = class_data_column({'MG1_kW','kW'}, prec3_str, 'electric.MG1.max_motor_power_W / 1000', 1);
    data_columns(end+1) = class_data_column({'MG2_kW','kW'}, prec3_str, 'electric.MG2.max_motor_power_W / 1000', 1);
end

if vehicle.powertrain_type.is_P0 || vehicle.powertrain_type.is_P2  % P0 and P2 hybrids
    data_columns(end+1) = class_data_column({'MG0_kW','kW'}, prec3_str, 'electric.P0_MG.max_motor_power_W / 1000', 1);
end

if vehicle.powertrain_type.is_P2  % P2 hybrid
    data_columns(end+1) = class_data_column({'MG2_kW','kW'}, prec3_str, 'electric.P2_MG.max_motor_power_W / 1000', 1);
end

if vehicle.powertrain_type.is_bev  % BEV
    data_columns(end+1) = class_data_column({'MG_kW','kW'}, prec3_str, 'electric.drive_motor.max_motor_power_W / 1000', 1);
end