
% Scale necessary controls parameters for engine and transmission updates
controls = controls.update_powertrain_info(engine, transmission, electric, vehicle, sim_config);

%% For US06 start at max CS SOC to reduce NEC corection needed
% if contains(sim_config.drive_cycle,'US06') %Start US06 at highest SOC to reduce required NEC correction
%     electric.propulsion_battery.initial_soc_norm = max(controls.charge_sustain_soc_band);
% end

% if (sim_config.force_cs_max_soc_start) %Start at highest SOC to reduce required NEC correction for US06 or other cases
%     electric.propulsion_battery.initial_soc_norm = max(controls.charge_sustain_soc_band);
% end

try % TODO: this applies to PS, not P2
    if (sim_config.intial_soc_relative_to_cs_soc) %Start at a SOC based on user input relative to total CS range
        electric.propulsion_battery.initial_soc_norm = interp1([0 1],controls.charge_sustain_soc_band,sim_config.intial_soc_relative_to_cs_soc);
    end
end
