function package = REVS_config_electric()
%REVS_CONFIG_AMBIENT REVS configuration keys for ambient conditions


package = class_REVS_sim_config_options();

package.keys = [ ...
    class_REVS_sim_config_key('electric',                               'tag',    'ELEC',   'eval',   false);
    
    class_REVS_sim_config_key('propulsion_battery',                     'tag',    'PROP_BATT',   'eval',   false);
    class_REVS_sim_config_key('accessory_battery',                      'tag',    'ACCY_BATT',   'eval',   false);
    
    class_REVS_sim_config_key('propulsion_battery_initial_soc_norm',    'tag',    'PROP_SOC');
    class_REVS_sim_config_key('propulsion_battery_reference_soc_norm',	'tag',    'PROP_REF_SOC'); %Can be used as initial or final depending on the drive cycle
    class_REVS_sim_config_key('accessory_battery_initial_soc_norm',     'tag',    'ACCY_SOC');
        
    class_REVS_sim_config_key('propulsion_battery_cells_in_series',     'tag',    'PROP_BATT_NS');
    class_REVS_sim_config_key('propulsion_battery_cells_in_parallel', 	'tag',    'PROP_BATT_NP');
    class_REVS_sim_config_key('propulsion_battery_cell_capacity_Ah',   	'tag',    'PROP_CELL_CAP');
    
    class_REVS_sim_config_key('MG1',                                    'tag',    'MG1',   'eval',   false);
    class_REVS_sim_config_key('MG2',                                    'tag',    'MG2',   'eval',   false);
    class_REVS_sim_config_key('P0_MG',                                  'tag',    'P0_MG',   'eval',   false);
  	class_REVS_sim_config_key('P2_MG',                                  'tag',    'P2_MG',   'eval',   false);
    class_REVS_sim_config_key('MOT',                                    'tag',    'MOT',   'eval',   false);
    
    % Motor Scaling Configs
    class_REVS_sim_config_key('MG1_max_power_kW',                    	'tag',    'MG1_PMAX');
    class_REVS_sim_config_key('MG2_max_power_kW',                   	'tag',    'MG2_PMAX');
    class_REVS_sim_config_key('P0MG_max_power_kW',                     	'tag',    'P0MG_PMAX');
    class_REVS_sim_config_key('P2MG_max_power_kW',                    	'tag',    'P2MG_PMAX');
    class_REVS_sim_config_key('MOT_max_power_kW',                    	'tag',    'MOT_PMAX');
    
    class_REVS_sim_config_key('MG1_max_torque_Nm',                    	'tag',    'MG1_TMAX');
    class_REVS_sim_config_key('MG2_max_torque_Nm',                   	'tag',    'MG2_TMAX');
    class_REVS_sim_config_key('P0MG_max_torque_Nm',                    	'tag',    'P0MG_TMAX');
    class_REVS_sim_config_key('P2MG_max_torque_Nm',                    	'tag',    'P2MG_TMAX');
    class_REVS_sim_config_key('MOT_max_torque_Nm',                    	'tag',    'MOT_TMAX');
    
    ];

package.case_preprocess_scripts = [ ...
    class_REVS_sim_config_script('REVS_config_electric_load', 1)
    class_REVS_sim_config_script('REVS_config_electric_modify', 5);
    ];