function package = REVS_config_engine()
%REVS_config_engine Config keys for loading and modifying engines

package = class_REVS_sim_config_options();

package.keys = [ ...

    class_REVS_sim_config_key('engine',                                'tag',    'ENG',        'eval',     false);            
    class_REVS_sim_config_key('fuel',                                  'tag',    'FUEL',       'eval',     false);

    class_REVS_sim_config_key('engine_vintage',                        'tag',    'ENG_VTG');

    class_REVS_sim_config_key('engine_modifiers',                      'tag',    'ENG_MOD',                                'description', 'Cell array of arguments to REVS_modify_engine' );
    class_REVS_sim_config_key('engine_scale_pct',                      'tag',    'ES_PCT',                                 'description', 'Scale engine by a percentage factor');
    class_REVS_sim_config_key('engine_scale_kW',                       'tag',    'ES_KW');
    class_REVS_sim_config_key('engine_scale_hp',                       'tag',    'ES_HP');
    class_REVS_sim_config_key('engine_scale_Nm',                       'tag',    'ES_NM');
    class_REVS_sim_config_key('engine_scale_ftlbs',                    'tag',    'ES_FTLB');    
    class_REVS_sim_config_key('engine_scale_L',                        'tag',    'ES_L');
    class_REVS_sim_config_key('engine_scale_adjust_BSFC',              'tag',    'ES_BSFC',           'default', 1);
    class_REVS_sim_config_key('engine_scale_num_cylinders',            'tag',    'ES_CYL',                                 'description', 'Scale engine by adding or removing cyliners, may be used with other scale factors');
    class_REVS_sim_config_key('engine_deac_type',                      'tag',    'DEAC_TYPE',         'eval',     false);
    class_REVS_sim_config_key('engine_deac_num_cylinders',             'tag',    'DEAC_CYL');                    
    class_REVS_sim_config_key('engine_deac_scale_pct',                 'tag',    'DEAC_SCALE_PCT',     'default', 100);
    class_REVS_sim_config_key('engine_deac_max_reduction_pct',         'tag',    'DEAC_MAX_RED_PCT');
    class_REVS_sim_config_key('engine_deac_reduction_curve',           'tag',    'DEAC_RED_CRV');
    class_REVS_sim_config_key('engine_deac_activation_delay_secs',     'tag',    'DEAC_ACT_DLY_SECS');
    %              class_REVS_sim_config_key('engine_DCP_DVVL',                       'tag',    'DCP_DVVL',           'default', 0);
    %              class_REVS_sim_config_key('engine_CCP_DVVL',                       'tag',    'CCP_DVVL',           'default', 0);
    %              class_REVS_sim_config_key('engine_DCP_CVVL',                       'tag',    'DCP_CVVL',           'default', 0);
    class_REVS_sim_config_key('engine_DCP',                            'tag',    'DCP',                'default', 0,       'description', 'Add or remove digital cam phasing via modifier map');
    class_REVS_sim_config_key('engine_CCP',                            'tag',    'CCP',                'default', 0,       'description', 'Add or remove continuous cam phasing via modifier map');
    class_REVS_sim_config_key('engine_GDI',                            'tag',    'GDI',                'default', 0,       'description', 'Add or remove gasoline direct injection (vs PFI) via modifier map');
    class_REVS_sim_config_key('engine_transient_fuel_penalty',         'tag',    'TFP',                'default', 1,       'description', 'Enable calculation of fuel penalty for transient operation');
    class_REVS_sim_config_key('engine_fuel_octane_compensation',       'tag',    'OCT',                'default', 1,       'description', 'Modify engine map based on fuel octane value'); %New addition
 ];

            
package.case_preprocess_scripts = [ ...
    class_REVS_sim_config_script('REVS_config_engine_load', 1)
    class_REVS_sim_config_script('REVS_config_engine_modify', 5);
    ];

        
end

