
%% Change fuel
% engine.base_fuel = engine.fuel;
%% fuel normalization

% if ~isempty(sim_config.fuel)
%     % scale engine BSFC based on reference fuel energy density:
%     reference_fuel      = class_REVS_fuel(sim_config.fuel);
%     engine.fuel_map_gps = engine.fuel_map_gps * engine.fuel.energy_density_MJpkg / reference_fuel.energy_density_MJpkg;
%     engine.fuel         = reference_fuel;
%     vehicle.fuel        = reference_fuel;
% elseif exist('engine','var') && exist('vehicle','var') && isempty(vehicle.fuel) 
%     vehicle.fuel        = engine.fuel;
% end

if ~isempty(sim_config.engine_modifiers)
    engine_mod_args = sim_config.engine_modifiers;
else
    engine_mod_args = {};
end

%% Engine Scaling
if ~isempty(sim_config.engine_scale_pct)
    engine_mod_args{end+1} = 'scale_factor';
    engine_mod_args{end+1} = (sim_config.engine_scale_pct / 100);
end

if ~isempty(sim_config.engine_scale_L)
    engine_mod_args{end+1} = 'scale_displacement';
    engine_mod_args{end+1} = sim_config.engine_scale_L;
elseif ~isempty(sim_config.engine_scale_kW)
    engine_mod_args{end+1} = 'scale_max_power';
    engine_mod_args{end+1} = sim_config.engine_scale_kW * 1000;
elseif ~isempty(sim_config.engine_scale_hp)
    engine_mod_args{end+1} = 'scale_max_power';
    engine_mod_args{end+1} = sim_config.engine_scale_hp * unit_convert.hp2kW * 1000;
elseif ~isempty(sim_config.engine_scale_Nm)
    engine_mod_args{end+1} = 'scale_max_torque';
    engine_mod_args{end+1} = sim_config.engine_scale_Nm;
elseif ~isempty(sim_config.engine_scale_ftlbs)
    engine_mod_args{end+1} = 'scale_max_torque';
    engine_mod_args{end+1} = sim_config.engine_scale_ftlbs * unit_convert.ftlbs2Nm ;
end
%% Adjust fuel properties
if ~isempty(sim_config.fuel)
    engine_mod_args{end+1}      = 'fuel';
    engine_mod_args{end+1}      = class_REVS_fuel(sim_config.fuel);
end

%% Adjust based on fuel octane rating

if ~(sim_config.engine_fuel_octane_compensation)
    engine_mod_args{end+1} = 'no_fuel_octane_adjust';
end

%% Adjust number of cylinders

if ~isempty(sim_config.engine_scale_num_cylinders)
    engine_mod_args{end+1} = 'num_cylinders';
    engine_mod_args{end+1} = sim_config.engine_scale_num_cylinders;
end

%% Cylinder Deactivation

if isempty(sim_config.engine_deac_type) && ~isempty( sim_config.engine_deac_num_cylinders)
    warning('Engine cylinder deac not requested, but deac cylinders specified');
elseif isempty(sim_config.engine_deac_type)
    % Nothing requested
elseif any(strcmpi( sim_config.engine_deac_type, {'C','Continuous'})) && ~isempty( sim_config.engine_deac_num_cylinders)
    % Add continuous deac (all cylinders)
    engine_mod_args{end+1} = '+deacC';
    warning('Continuous engine cylinder deac requested, but number of deac cylinders specified');
elseif any(strcmpi( sim_config.engine_deac_type, {'C','Continuous'}))
    % Add continuous deac (all cylinders)
    engine_mod_args{end+1} = '+deacC';
elseif any(strcmpi( sim_config.engine_deac_type, {'D','Discrete'}))
    % Add discrete deac to portion of cylinders
    engine_mod_args{end+1} = '+deacD';
    engine_mod_args{end+1} = 'deac_cylinders';
    engine_mod_args{end+1} = sim_config.engine_deac_num_cylinders;
elseif (islogical( sim_config.engine_deac_type) && ~sim_config.engine_deac_type) || ...
        any(strcmpi( sim_config.engine_deac_type, {'N','None'}))
    engine_mod_args{end+1} = '-deac';
end

if ~isempty(sim_config.engine_deac_activation_delay_secs)
    engine_mod_args{end+1} = 'deac_activation_secs';
    engine_mod_args{end+1} = sim_config.engine_deac_activation_delay_secs;
end

if ~isempty(sim_config.engine_deac_max_reduction_pct)
    engine_mod_args{end+1} = 'deac_max_reduction';
    engine_mod_args{end+1} = sim_config.engine_deac_max_reduction_pct/100;
end

if ~isempty(sim_config.engine_deac_reduction_curve)
    engine_mod_args{end+1} = 'deac_reduction_curve';
    engine_mod_args{end+1} = eval(sim_config.engine_deac_reduction_curve);
end

%% engine tech modifiers

if ~isempty(sim_config.engine_GDI)
    engine_mod_args{end+1} = 'GDI';
    engine_mod_args{end+1} = sim_config.engine_GDI;
end

% 	if ~isempty(sim_config.engine_DCP_DVVL)
% 		engine_mod_args{end+1} = 'DCP_DVVL';
% 		engine_mod_args{end+1} = sim_config.engine_DCP_DVVL;
% 	end
%
% 	if ~isempty(sim_config.engine_CCP_CVVL)
% 		engine_mod_args{end+1} = 'CCP_CVVL';
% 		engine_mod_args{end+1} = sim_config.engine_CCP_DVVL;
% 	end
%
% 	if ~isempty(sim_config.engine_DCP_CVVL)
% 		engine_mod_args{end+1} = 'DCP_CVVL';
% 		engine_mod_args{end+1} = sim_config.engine_DCP_CVVL;
% 	end

if ~isempty(sim_config.engine_DCP)
    engine_mod_args{end+1} = 'DCP';
    engine_mod_args{end+1} = sim_config.engine_DCP;
end

if ~isempty(sim_config.engine_CCP)
    engine_mod_args{end+1} = 'CCP';
    engine_mod_args{end+1} = sim_config.engine_CCP;
end

if ~sim_config.engine_scale_adjust_BSFC
    % Disable BSFC effects
    engine_mod_args = [engine_mod_args, {'no_scaling_knock_adjust', 'no_scaling_friction_adjust', 'no_scaling_sv_ratio_adjust'}];
end

% Apply all the modifications...
if ~isempty(engine_mod_args)
    [engine,engine_modifiers] = REVS_modify_engine( engine, engine_mod_args{:} );
end

if ~exist('engine_modifiers','var')
    engine_modifiers.octane_knk_adjust_factor = nan;
    engine_modifiers.octane_change = 0;
    engine_modifiers.octane_modifier_used  = 0;
end

clear engine_mod_args

% Copy over the fuel properties to vehicle...
if exist('engine','var') && exist('vehicle','var') && isempty(vehicle.fuel) 
    vehicle.fuel        = engine.fuel;
end

%% Engine inertia plausibility check
if engine.inertia_kgm2 <= 0.07
    engine.inertia_kgm2 = 0.07;
end
%% cylinder deac strategy
if ~isempty(sim_config.engine_deac_scale_pct)
    if isa(engine.deac_strategy.enable_norm,'class_REVS_dynamic_lookup')
        engine.deac_strategy.enable_norm.table = sim_config.engine_deac_scale_pct/100 * engine.deac_strategy.enable_norm.table;
    else
        engine.deac_strategy.enable_norm = sim_config.engine_deac_scale_pct/100;
    end
end

%% engine fuel penalties
if ~sim_config.engine_transient_fuel_penalty
    engine.acceleration_penalty_gpradps2 = 0;
    engine.refuel_limit_gps = 0;
end
