

%% external simulation stimuli

if ~isempty(sim_config.test_data)     
    if contains(sim_config.test_data, '.mat')
        load(sim_config.test_data)
        sim_config.test_data = strrep(sim_config.test_data, '.mat', '');
    end
     
    if strcmpi(evalin('base', ['class(' sim_config.test_data ')']), 'cell')
        external_data_ref = [sim_config.test_data '{' num2str(sim_config.test_data_index) '}'];
    else
        external_data_ref = [sim_config.test_data '(' num2str(sim_config.test_data_index) ')'];
    end
end


%% Drive Cycle

if sim_config.external_drive_cycle
    if sim_config.external_drive_cycle == 1
        % user should load canonical cycle to provide bags/phase times etc,
        % but override vehicle speed with new data
        drive_cycle.cycle_time      = evalin('base',[external_data_ref '.time;']);
        drive_cycle.cycle_speed_mps = evalin('base',[external_data_ref '.vehicle.dyno_speed_mps;']);
    else
        % create entirely new drive cycle (single bag)
        cycle_time      = evalin('base',[external_data_ref '.time;']);
        cycle_speed_mps = evalin('base',[external_data_ref '.vehicle.dyno_speed_mps;']);
        drive_cycle = REVS_create_drive_cycle('external_cycle', cycle_speed_mps, cycle_time);
    end
end

%% Transmission

if sim_config.external_shift
	if transmission.type == enum_transmission_type.CVT
		transmission.gear_strategy = class_REVS_external_shift_CVT;
		transmission.gear_strategy.time_secs = evalin('base', [external_data_ref '.time;']);
		transmission.gear_strategy.CVT_ratio = evalin('base', [external_data_ref '.transmission.commanded_CVT_ratio;']);
	else
		transmission.gear_strategy = class_REVS_external_shift;
		transmission.gear_strategy.time_secs = evalin('base', [external_data_ref '.time;']);
		transmission.gear_strategy.gear_num  = evalin('base', [external_data_ref '.transmission.commanded_gear_number;']);
	end
end

if sim_config.external_lockup
    transmission.tcc_strategy           = class_REVS_external_lockup;
    transmission.tcc_strategy.time_secs = evalin('base', [external_data_ref '.time;']);
    transmission.tcc_strategy.lockup_cmd   = evalin('base', [external_data_ref '.transmission.launch_device_lockup_norm;']);
end

if sim_config.external_trans_temp
    transmission.thermal.variant = 'time lookup';
    transmission.thermal.temperature_time_sec = evalin('base', [external_data_ref '.time;']);
    transmission.thermal.temperature_degC = evalin('base', [external_data_ref '.transmission.oil_temp_degC;']);
end

%% External Cylinder Deactivation

if sim_config.external_cyl_deac
    engine.deac_strategy.type = enum_engine_deac_select.external_deac;
	engine.deac_strategy.time_secs = evalin('base',[external_data_ref '.time;']);
	engine.deac_strategy.deac_norm = evalin('base',[external_data_ref '.engine.cylinder_deac_norm;']);
end

%% Accessory Losses

if ~isempty(sim_config.external_accessory_elec) 
    accessories.generic_loss                                            = class_REVS_accessory_load();
    accessories.generic_loss.electrical_loss_map_A.axis_1.signal        = 'cycle_pos_secs';
    accessories.generic_loss.electrical_loss_map_A.axis_1.breakpoints   = evalin('base',[external_data_ref '.time;']);
    accessories.generic_loss.electrical_loss_map_A.table = []; % clear table
    accessories.generic_loss.electrical_loss_map_A.table(:,1)           = evalin('base',[external_data_ref '.' sim_config.external_accessory_elec ';']);
end

if ~isempty(sim_config.external_accessory_mech) 
    
end

%% Cleanup

clear external_data_ref
