


%% performance weight penalty
if ~isempty(sim_config.performance_mass_penalty_kg)
    temp.perf_phase_num = find(contains(lower(drive_cycle.phase_name),'performance'),1);
    
    if ~isempty(temp.perf_phase_num)
        temp.perf_phase_start = drive_cycle.phase_time(drive_cycle.phase == temp.perf_phase_num);
                
        % should set penalty back to zero after performance cycle... in
        % case it's not the last part of the cycle...
        vehicle.delta_mass_static_kg.axis_1.signal      = 'cycle_pos_secs';
        vehicle.delta_mass_static_kg.axis_1.breakpoints = [temp.perf_phase_start, temp.perf_phase_start + .001 ];
        vehicle.delta_mass_static_kg.table              = [0, sim_config.performance_mass_penalty_kg];
        
        vehicle.delta_mass_dynamic_kg.axis_1.signal      = 'cycle_pos_secs';
        vehicle.delta_mass_dynamic_kg.axis_1.breakpoints = [temp.perf_phase_start, temp.perf_phase_start + .001 ];
        vehicle.delta_mass_dynamic_kg.table              = [0, sim_config.performance_mass_penalty_kg];
    end
    
    clear temp
end




%% roadload reductions

weight_reduction = sim_config.weight_reduction_pct / 100;
improve_aero = sim_config.improve_aero_pct / 100;
improve_crr = sim_config.improve_crr_pct / 100;

vehicle = matrix_calc_roadload(vehicle, weight_reduction, improve_aero, improve_crr);



%% performance scaling
perf_scale = 1.0;
% if sim_config.performance_baseline.has_value && sim_config.performance_baseline.value
% 
%     % calc performance baseline
%     if sim_config.engine_scale_kW.has_value
%         temp_engine_scale_norm = (sim_config.engine_scale_kW.value * 1000) / engine.max_power_W;
%     elseif sim_config.engine_scale_hp.has_value
%         temp_engine_scale_norm = (sim_config.engine_scale_hp.value * unit_convert.hp2kW * 1000) / engine.max_power_W;
%     elseif sim_config.engine_scale_pct.has_value
%         temp_engine_scale_norm = (sim_config.engine_scale_pct.value / 100);
%     elseif sim_config.engine_scale_L.has_value
%         temp_engine_scale_norm = sim_config.engine_scale_L.value / engine.displacement_L;
%     else
%         temp_engine_scale_norm = 1.0;
%     end
%     
%     temp_engine                 = REVS_modify_engine( engine, 'scale_factor', temp_engine_scale_norm, 'no_scale_fuel_adjust');    % baseline engine scaling
%     redline_rpm                 = min(temp_engine.full_throttle_speed_radps(end) - 650 * unit_convert.rpm2radps, REVS_calc_engine_power_speed(temp_engine, 0.98, 'min')) * unit_convert.radps2rpm;
%     [~, baseline_wheelpower_W]  = REVS_calc_max_wheeltorque( temp_engine, transmission, vehicle.drive_axle1, 'stall_radps', 1 * 3000 * unit_convert.rpm2radps, 'redline_radps', redline_rpm * unit_convert.rpm2radps, 'max_speed_mph', 70); %, 'do_plots' );
%     
%     % store baseline perf in global var
%     obj.batch_sim_ptr.globals.baseline_wheel_perf = sum(baseline_wheelpower_W);
%     
%     clear temp_engine temp_engine_scale baseline_wheelpower_W;
% elseif sim_config.performance_neutral.has_value && sim_config.performance_neutral.value && isfield(obj.batch_sim_ptr.globals,'baseline_wheel_perf')
%     redline_rpm = min(engine.full_throttle_speed_radps(end) - 650 * unit_convert.rpm2radps, REVS_calc_engine_power_speed(engine, 0.98, 'min')) * unit_convert.radps2rpm;
%     
%     % scale for performance:
%     [wheeltorque_Nm, wheelpower_W] = REVS_calc_max_wheeltorque( engine, transmission, vehicle.drive_axle1, 'stall_radps', 1 * 3000 * unit_convert.rpm2radps, 'redline_radps', redline_rpm * unit_convert.rpm2radps, 'max_speed_mph', 70); %, 'do_plots' );
%     wheel_perf          = sum(wheelpower_W);
%     perf_scale          = obj.batch_sim_ptr.globals.baseline_wheel_perf / wheel_perf;
%     
%     % scale for roadload and boost:
%     boost_ratio         = max(engine.full_throttle_torque_Nm)/max(engine.naturally_aspirated_torque_Nm)-1;
%     perf_scale          = perf_scale * (1 + boost_ratio/20) * (1 - weight_reduction * 0.88) * (1 - improve_crr * 0.02) * (1 - improve_aero * 0.03); % * (1 - (transmission.matrix_vintage == enum_matrix_vintage.future) * 0.066);
%     
%     clear wheel_perf boost_ratio
% elseif sim_config.performance_neutral.has_value && sim_config.performance_neutral.value && ~isfield(obj.batch_sim_ptr.globals,'baseline_wheel_perf')
%     error('Performance Baseline Unavailable');
% end






%% final drive ratio (displacement-based)

if sim_config.FDR_auto   

    targetN_at60 = interp1([-9999 1 2 3 4 5 6 7 9999],[2250, 2250, 1750, 1700, 1600, 1500, 1450, 1300, 1300], engine.displacement_L);
    targetN_at60 = targetN_at60 - 250 * (transmission.matrix_vintage == enum_matrix_vintage.future);
    
    if (transmission.type == enum_transmission_type.DCT)
        targetN_at60 = 1.25 * targetN_at60; % DCTs a better off, considering performance neutrality, with higher FDR and smaller engine, 1.25x based on sensitivity study
    end
    
    if (transmission.type == enum_transmission_type.CVT)        
        vehicle.drive_axle1.final_drive.gear_ratio = targetN_at60 / (unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m * transmission.gear.ratio(2) * 60);
    else
        vehicle.drive_axle1.final_drive.gear_ratio = targetN_at60 / (unit_convert.mph2mps * unit_convert.radps2rpm / vehicle.drive_axle1.tire.radius_m *transmission.gear.ratio(end) * 60);
    end
    
    clear targetN_at60
end


%% update gear strategy cost map for new engine
if (transmission.type == enum_transmission_type.CVT && transmission.gear_strategy.type == enum_transmission_gear_select.ALPHAshift_CVT)
    transmission.gear_strategy = transmission.gear_strategy.update_min_bsfc_curve(engine);
elseif (transmission.type ~= enum_transmission_type.no_transmission && transmission.gear_strategy.type == enum_transmission_gear_select.ALPHAshift)
    transmission.gear_strategy = transmission.gear_strategy.update_cost_map(engine);
end

% %% random variable
% if sim_config.var.has_value && sim_config.var_value.has_value
%     eval([sim_config.var.value ' = ' num2str(sim_config.var_value.value)]);
% end

%% fix for hybrid powertrains
if vehicle.powertrain_type == enum_powertrain_type.hybrid_P0 || vehicle.powertrain_type == enum_powertrain_type.hybrid_P2 || vehicle.powertrain_type == enum_powertrain_type.hybrid_P2_BAS  %P2 added
    [controls.engine_min_bsfc_speed_radps, controls.engine_min_bsfc_torque_Nm] = REVS_calc_engine_min_bsfc(engine);
end

%% update controls (pedal map for new engine) (and min bsfc line)
if vehicle.powertrain_type == enum_powertrain_type.conventional
    controls = controls.update_powertrain_info(engine, transmission); % Might be needed in the future for EVs
end

if vehicle.powertrain_type == enum_powertrain_type.hybrid_powersplit
    controls = controls.update_powertrain_info(engine, transmission, electric, vehicle); % Might be needed in the future for EVs
end

% %% custom eval	( this should always be last )
% if sim_config.eval_value.has_value
%     eval(sim_config.eval_value.value);
% end
