
%% transmission torque rating
if transmission.type ~= enum_transmission_type.no_transmission
    transmission = REVS_modify_transmission(transmission, 'rated_torque', engine.max_torque_Nm * 1.15);
end

%% torque converter torque ratio
if ~isempty(sim_config.TC_torque_ratio) && isprop(transmission,'torque_converter')
    transmission.torque_converter.drive_torque_ratio    = interp1([0 0.875 1], [sim_config.TC_torque_ratio 1 1], transmission.torque_converter.speed_ratio);
end

%% torque converter K-factor
if  ~isprop(transmission,'torque_converter')
    % No Torque Converter
elseif ~isempty(sim_config.TC_K_factor) 
    % re-scale K-factor but maintain original K-factor v. SR curve:
    transmission.torque_converter.drive_k_factor_rpmpsqrtNm = sim_config.TC_K_factor * normalize(transmission.torque_converter.drive_k_factor_rpmpsqrtNm, 1);
    transmission.torque_converter.decel_k_factor_rpmpsqrtNm = 0.7*transmission.torque_converter.drive_k_factor_rpmpsqrtNm(1) + transmission.torque_converter.drive_k_factor_rpmpsqrtNm;
elseif ~isempty(sim_config.TC_stall_rpm) 
    K_factor_rpmpsqrtNm = sim_config.TC_stall_rpm/sqrt(transmission.rated_torque_Nm);
    transmission.torque_converter.drive_k_factor_rpmpsqrtNm = K_factor_rpmpsqrtNm * normalize(transmission.torque_converter.drive_k_factor_rpmpsqrtNm, 1);
    transmission.torque_converter.decel_k_factor_rpmpsqrtNm = 0.7*transmission.torque_converter.drive_k_factor_rpmpsqrtNm(1) + transmission.torque_converter.drive_k_factor_rpmpsqrtNm;
end
