function package = REVS_config_vehicle()
%REVS_CONFIG_CVM_METAPACKAGE Summary of this function goes here
%   Detailed explanation goes here

package = class_REVS_sim_config_options();

package.keys = [ ...
            class_REVS_sim_config_key('package',          'tag',    'PKG',  'eval',   false);

            class_REVS_sim_config_key('drive_cycle',          'tag',    'CYC',  'eval',   false);
            class_REVS_sim_config_key('vehicle',              'tag',    'VEH',  'eval',   false);
            class_REVS_sim_config_key('driver',               'tag',    'DRV',  'eval',   false, 'default', {'driver=class_REVS_driver;'});
            
            class_REVS_sim_config_key('vehicle_lbs',                  'tag', 'VEH_LBS');                % sets vehicle mass, dynamic mass = 1.03 * vehicle mass
            class_REVS_sim_config_key('vehicle_kg',                   'tag', 'VEH_KG');
            class_REVS_sim_config_key('performance_mass_penalty_kg',  'tag', 'PERF_KG', 'default', 0);  % additional mass added during performance drive cycle

            class_REVS_sim_config_key('ETW_lbs',                'tag', 'ETW_LBS');    % sets vehicle mass, dynamic mass = 1.015 * vehicle mass (ETW includes 1.5% additional inertia already)
            class_REVS_sim_config_key('ETW_kg',                 'tag', 'ETW_KG');
            class_REVS_sim_config_key('ETW_multiplier',         'tag', 'ETW_MLT', 'default', 1.0);

            class_REVS_sim_config_key('target_A_lbs',           'tag', 'TRGA_LBS');
            class_REVS_sim_config_key('target_B_lbs',           'tag', 'TRGB_LBS');
            class_REVS_sim_config_key('target_C_lbs',           'tag', 'TRGC_LBS');

            class_REVS_sim_config_key('dyno_set_A_lbs',         'tag', 'DYNA_LBS');
            class_REVS_sim_config_key('dyno_set_B_lbs',         'tag', 'DYNB_LBS');
            class_REVS_sim_config_key('dyno_set_C_lbs',         'tag', 'DYNC_LBS');

            class_REVS_sim_config_key('calc_ABC_adjustment',    'tag', 'CALC_ABC_ADJ', 'default', false);

            class_REVS_sim_config_key('target_A_N',             'tag', 'TRGA_N');
            class_REVS_sim_config_key('target_B_N',             'tag', 'TRGB_N');
            class_REVS_sim_config_key('target_C_N',             'tag', 'TRGC_N');

            class_REVS_sim_config_key('dyno_set_A_N',           'tag', 'DYNA_N');
            class_REVS_sim_config_key('dyno_set_B_N',           'tag', 'DYNB_N');
            class_REVS_sim_config_key('dyno_set_C_N',           'tag', 'DYNC_N');

            class_REVS_sim_config_key('adjust_A_lbs',           'tag', 'ADJA_LBS');
            class_REVS_sim_config_key('adjust_B_lbs',           'tag', 'ADJB_LBS');
            class_REVS_sim_config_key('adjust_C_lbs',           'tag', 'ADJC_LBS');

            class_REVS_sim_config_key('adjust_A_N',             'tag', 'ADJA_N');
            class_REVS_sim_config_key('adjust_B_N',             'tag', 'ADJB_N');
            class_REVS_sim_config_key('adjust_C_N',             'tag', 'ADJC_N');

            class_REVS_sim_config_key('roadload_multiplier',    'tag', 'RL_MLT',  'default', 1.0);
            
            class_REVS_sim_config_key('NV_ratio',               'tag','NV_RATIO');
            class_REVS_sim_config_key('FDR',                    'tag','FDR');
            class_REVS_sim_config_key('FDR_efficiency_norm',    'tag','FDR_EFF');

            class_REVS_sim_config_key('powertrain_type',        'tag',  'PTRAIN',    'eval', false);
            class_REVS_sim_config_key('vehicle_type',           'tag',  'VEH_TYPE',  'eval', false);
            class_REVS_sim_config_key('vehicle_manufacturer',   'tag',  'VEH_MFR',   'eval', false);
            class_REVS_sim_config_key('vehicle_model',          'tag',  'VEH_MDL',   'eval', false);
            class_REVS_sim_config_key('vehicle_description',    'tag',  'VEH_DESC',  'eval', false); 
            class_REVS_sim_config_key('tire_radius_mm',         'tag',  'TIRERAD');];
        
        
            

            
package.case_preprocess_scripts = [ ...
    class_REVS_sim_config_script('REVS_config_vehicle_load', 1)
    class_REVS_sim_config_script('REVS_config_vehicle_modify', 6)
    ];

        
end

