


REVS_load_param( sim_config.vehicle );
REVS_load_param( sim_config.driver );


%% Drive Cycle

if isempty(sim_config.drive_cycle)
    % Nothin to load (might be created later)
elseif isa( sim_config.drive_cycle, 'class_REVS_drive_cycle')
    drive_cycle = sim_config.drive_cycle;
elseif iscell( sim_config.drive_cycle )
    drive_cycle = REVS_combine_drive_cycles(sim_config.drive_cycle);
elseif ~ischar(sim_config.drive_cycle)
    error('Unable to load drive cycle, must be a drive cycle mat file for class_REVS_dive_cycle_object')
elseif regexpcmp(sim_config.drive_cycle, '^\{.*\}$')
    drive_cycle = eval( sim_config.drive_cycle );
    drive_cycle = REVS_combine_drive_cycles(drive_cycle);
else
    load( sim_config.drive_cycle );
end
    

%% powertrain type
if ~isempty(sim_config.powertrain_type)
    vehicle.powertrain_type = eval(['enum_powertrain_type.' sim_config.powertrain_type]);
end


%% test weight/mass
if ~isempty(sim_config.ETW_lbs)
    vehicle.ETW_lbs = sim_config.ETW_lbs;
end

if ~isempty(sim_config.ETW_kg)
    vehicle.ETW_kg  = sim_config.ETW_kg;
end

if ~isempty(sim_config.vehicle_lbs)
    vehicle.mass_static_kg  = unit_convert.lbm2kg * sim_config.vehicle_lbs;
end

if ~isempty(sim_config.vehicle_kg)
    vehicle.mass_static_kg  = sim_config.vehicle_kg;
end


%% base roadload

roadload_multiplier = sim_config.roadload_multiplier;

if ~isempty(sim_config.target_A_lbs)
    vehicle.coastdown_target_A_lbf = sim_config.target_A_lbs * roadload_multiplier;
elseif ~isempty(sim_config.target_A_N)
    vehicle.coastdown_target_A_N = sim_config.target_A_N * roadload_multiplier;
else
    vehicle.coastdown_target_A_N = vehicle.coastdown_target_A_N * roadload_multiplier;
end

if ~isempty(sim_config.target_B_lbs)
    vehicle.coastdown_target_B_lbfpmph = sim_config.target_B_lbs * roadload_multiplier;
elseif ~isempty(sim_config.target_B_N)
    vehicle.coastdown_target_B_Npms = sim_config.target_B_N * roadload_multiplier;
else
     vehicle.coastdown_target_B_Npms = vehicle.coastdown_target_B_Npms * roadload_multiplier;
end

if ~isempty(sim_config.target_C_lbs)
    vehicle.coastdown_target_C_lbfpmph2 = sim_config.target_C_lbs * roadload_multiplier;
elseif ~isempty(sim_config.target_C_N)
    vehicle.coastdown_target_C_Npms2 = sim_config.target_C_N * roadload_multiplier;
else
    vehicle.coastdown_target_C_Npms2 = vehicle.coastdown_target_C_Npms2 * roadload_multiplier;
end



%% dyno sets
if  ~isempty(sim_config.dyno_set_A_lbs)
    vehicle.dyno_set_A_lbf = sim_config.dyno_set_A_lbs;
elseif  ~isempty(sim_config.dyno_set_A_N)
    vehicle.dyno_set_A_N = sim_config.dyno_set_A_N;    
end

if  ~isempty(sim_config.dyno_set_B_lbs)
    vehicle.dyno_set_B_lbfpmph = sim_config.dyno_set_B_lbs;
elseif  ~isempty(sim_config.dyno_set_B_N)
    vehicle.dyno_set_B_Npms = sim_config.dyno_set_B_N;        
end

if ~isempty( sim_config.dyno_set_C_lbs)
    vehicle.dyno_set_C_lbfpmph2 = sim_config.dyno_set_C_lbs;
elseif  ~isempty(sim_config.dyno_set_C_N)
    vehicle.dyno_set_C_Npms2 = sim_config.dyno_set_C_N;
end


if sim_config.calc_ABC_adjustment
    % calculate roadload adjustment from targets and dyno sets
    vehicle = vehicle.calc_roadload_adjust();
else
    %% roadload adjustment
    if ~isempty(sim_config.adjust_A_lbs)
        vehicle.coastdown_adjust_A_lbf = sim_config.adjust_A_lbs;
    elseif ~isempty(sim_config.adjust_A_N)
        vehicle.coastdown_adjust_A_N = sim_config.adjust_A_N;    
        
    end

    if ~isempty(sim_config.adjust_B_lbs)
        vehicle.coastdown_adjust_B_lbfpmph = sim_config.adjust_B_lbs;
    elseif ~isempty(sim_config.adjust_B_N)
        vehicle.coastdown_adjust_B_Npms = sim_config.adjust_B_N;    
        
    end

    if ~isempty(sim_config.adjust_C_lbs)
        vehicle.coastdown_adjust_C_lbfpmph2 = sim_config.adjust_C_lbs;
    elseif ~isempty(sim_config.adjust_C_N)
        vehicle.coastdown_adjust_C_Npms2 = sim_config.adjust_C_N;
    end

end




%% final drive ratio (absolute)
% if ~isempty(sim_config.FDR)
%     vehicle.drive_axle1.final_drive.gear_ratio = sim_config.FDR;
% elseif ~isempty(sim_config.NV_ratio)
%     vehicle.drive_axle1.final_drive.gear_ratio = sim_config.NV_ratio * vehicle.drive_axle1.tire.radius_m / ( unit_convert.mph2mps * unit_convert.radps2rpm * transmission.gear.ratio(end) );
% end
% 
% 
% %% final drive ratio efficiency
% if ~isempty(sim_config.FDR_efficiency_norm)
%     vehicle.drive_axle1.final_drive.efficiency_norm = sim_config.FDR_efficiency_norm;
% end




