%% tire radius
if ~isempty(sim_config.tire_radius_mm)
        vehicle.drive_axle1.tire.radius_m = sim_config.tire_radius_mm/1000;
end


%% final drive ratio (absolute)
if ~isempty(sim_config.FDR)
    vehicle.drive_axle1.final_drive.gear_ratio = sim_config.FDR;
elseif ~isempty(sim_config.NV_ratio)
    vehicle.drive_axle1.final_drive.gear_ratio = sim_config.NV_ratio * vehicle.drive_axle1.tire.radius_m / ( unit_convert.mph2mps * unit_convert.radps2rpm * transmission.gear.ratio(end) );
end


%% final drive ratio efficiency
if ~isempty(sim_config.FDR_efficiency_norm)
    vehicle.drive_axle1.final_drive.efficiency_norm = sim_config.FDR_efficiency_norm;
end







