classdef class_REVS3_electric
	%class_REVS3_electric
	%   ALPHA Electric description class. Contains definitions for
	%	starter, alternator, battery & related electrical systems
	
	properties
        name = '';
        matrix_vintage = enum_matrix_vintage.present;
		
        starter_generator;
        energy_storage;        
	end
	
	methods
		
		function obj = class_REVS_electric( obj, starter_generator_type, energy_storage_type, engine )
			% Pass in Engine class to auto calculate starter & alternator
			% parameters
			
            if (starter_generator_type == enum_starter_generator_type.conventional) && (nargin > 2)
                obj.starter_generator            = class_REVS_starter_alternator;
                obj.starter_generator.starter    = class_REVS_starter( engine );
                obj.starter_generator.alternator = class_REVS_alternator( engine );
            elseif (starter_generator_type == enum_starter_generator_type.conventional)
                obj.starter_generator            = class_REVS_starter_alternator;
                obj.starter_generator.starter    = class_REVS_starter();
                obj.starter_generator.alternator = class_REVS_alternator();
            elseif (starter_generator_type == enum_starter_generator_type.mild_hybrid)
                obj.starter_generator            = class_REVS_motor_generator;
            elseif (starter_generator_type == enum_starter_generator_type.strong_hybrid)
                obj.starter_generator            = [];
            end            						

            
            if (energy_storage_type == enum_energy_storage_type.conventional)
                obj.energy_storage.battery              = class_REVS_battery;
            elseif (energy_storage_type == enum_energy_storage_type.HV_DCDC)
                obj.energy_storage.propulsion_battery   = class_REVS_battery;
                obj.energy_storage.voltage_converter    = class_REVS_constant_voltage_power_converter;
            elseif (energy_storage_type == enum_energy_storage_type.HV_DCDC_LV)
                obj.energy_storage.battery              = class_REVS_battery;
                obj.energy_storage.voltage_converter    = class_REVS_constant_voltage_power_converter;
                obj.energy_storage.propulsion_battery   = class_REVS_battery;
            end
            
		end
				
	end
	
end

