classdef class_REVS_ALPHAshift
	%class_REVS_ALPHAshift
	%   defines parameters for use with ALPHAshift shift algorithm
	
    properties (Constant = true )
       type =  enum_transmission_gear_select.ALPHAshift;
    end
    
	properties
        % variant = 'ALPHAshift'; % name of library gear select variant target block
        
		launch_gear_num                     = 1;
		restrict_skip_shifts                = false;
		restrict_shift_parity               = false;
		
		min_speed_radps                     = [];
		min_speed_shift_increment           = [];
		max_speed_radps                     = [];
		max_speed_shift_increment           = [];
		
		downshift_delay_secs                = [];
		downshift_commit_secs               = [];
		downshift_max_speed_radps           = [];
		disable_cost_saving_downshifts      = true;
		
		upshift_min_speed_radps             = [];
		upshift_delay_secs                  = [];
		upshift_commit_secs                 = [];
		upshift_min_torque_reserve_ratio    = [];
		
		kickdown_trigger_ratio              = [];
		kickdown_delay_secs                 = [];
		kickdown_min_gear                   = 1;
		kickdown_max_increment              = 1;
		
		use_engine_speed_mask               = [];
		
		max_input_torque_curve_Nm           = [];
		max_input_torque_speeds_radps       = [];
		
		required_cost_benefit_ratio         = [];
		cost_map_speed_radps                = [];
		cost_map_torque_Nm                  = [];
		cost_map                            = [];
	end
	
	methods
		function obj = class_REVS_ALPHAshift( num_gears, engine )
			if nargin >= 1
				obj.max_speed_radps             = Inf * ones(num_gears + 1, 1);
				obj.max_speed_shift_increment   = ones(num_gears + 1, 1);
				
				obj.min_speed_radps             = zeros(num_gears + 1, 1);
				obj.min_speed_shift_increment   = ones(num_gears + 1, 1);
				
				obj.upshift_min_speed_radps     = zeros(num_gears + 1, 1);
				
				obj.downshift_max_speed_radps   = Inf * ones(num_gears + 1, 1);
				
				obj.required_cost_benefit_ratio = 1.03 * ones(num_gears + 1, 1);
				
				obj.downshift_delay_secs        = zeros(num_gears + 1, 1);
				obj.downshift_commit_secs       = zeros(num_gears + 1, 1);
				
				obj.upshift_delay_secs          = zeros(num_gears + 1, 1);
				obj.upshift_commit_secs         = zeros(num_gears + 1, 1);
				
				obj.kickdown_trigger_ratio      = ones(num_gears + 1, 1);
				obj.kickdown_delay_secs         = zeros(num_gears + 1, 1);
				obj.kickdown_max_increment      = floor(num_gears / 2);
				
				obj.use_engine_speed_mask       = zeros(num_gears+1,1);
			end
			
			if nargin >= 2
				obj = obj.update_cost_map( engine );
			end
		end
		
		function obj = update_cost_map(obj, engine)

          
            [obj.max_input_torque_speeds_radps, obj.max_input_torque_curve_Nm] = engine.get_max_torque_curve();
			
            [fuel_map.speed_radps, fuel_map.torque_Nm, fuel_map.fuel_gps] = engine.get_fuel_map();
            
			obj.cost_map_speed_radps            = fuel_map.speed_radps;
			obj.cost_map_torque_Nm              = fuel_map.torque_Nm;
			
			eff_torque_Nm = [0.00 0.2 0.4 0.60 0.80 1.00] * engine.max_torque_Nm;
			eff_pct       = [0.05 0.80 0.90 0.91 0.92 0.93];
			eff_pct       = max(min(eff_pct), interp1(eff_torque_Nm , eff_pct, obj.cost_map_torque_Nm(:), 'linear', 'extrap'));
			eff_map       = repmat(eff_pct, 1, length(obj.cost_map_speed_radps));
			
			obj.cost_map  = fuel_map.fuel_gps ./ eff_map;
		end
		
		function val = as_struct(obj)
			fields = fieldnames(obj);
			
			for i = 1:length(fields)
				val.(fields{i}) = obj.(fields{i});
			end
		end
	end
	
	
end
