classdef class_REVS_ALPHAshift_CVT
    %class_REVS_ALPHAshift_CVT
    %   defines parameters for use with ALPHAshift shift algorithm
    
    properties( Constant = true)
        type = enum_transmission_gear_select.ALPHAshift_CVT;
    end
    
    
    properties
        variant = 'ALPHAshift_CVT'; % name of library gear select variant target block
        
        min_bsfc_speed_rapds;			% Optimal Efficiency line speeds [radps]
        min_bsfc_power_W;				% Optimal efficiency line powers [W]
        
        min_speed_radps class_REVS_dynamic_lookup;				% Minimum allowed operational speeds - Dynamic Lookup
        
        speed_ratio_rise_rate_limit = 4.5;  % rising speed ratio (falling gear ratio / upshift) rate limit
        speed_ratio_fall_rate_limit = 4.5;  % falling speed ratio (rising gear ratio / downshift) rate limit
        
    end
    
    methods
        function obj = class_REVS_ALPHAshift_CVT( engine )
            
            obj.min_speed_radps = class_REVS_dynamic_lookup;
            
            if nargin >= 1
%                % Use engine map to set optimal speed points - could include adjustment for transmission losses
%                [obj.min_bsfc_speed_rapds, ~, obj.min_bsfc_power_W] = REVS_calc_engine_min_bsfc(engine,'increment', 2.5);
                obj = obj.update_min_bsfc_curve(engine);
            end
            
        end
        
        function obj = update_min_bsfc_curve(obj_in, engine)
            obj = obj_in;
            % Use engine map to set optimal speed points - could include adjustment for transmission losses
            [obj.min_bsfc_speed_rapds, ~, obj.min_bsfc_power_W] = REVS_calc_engine_min_bsfc(engine,'increment', 2.5);
        end
        
    end
    
end
