classdef class_REVS_AMT_transmission < class_REVS_transmission
	%class_REVS_AMT_transmission
	%   Definition for REVS AMT Transmission class
	

	
	properties

		clutch = class_REVS_clutch();
		gear = class_REVS_gearbox();                  % gearbox Parameters
		inertia_brake = class_REVS_AMT_inertia_brake();
		
		control = class_REVS_AMT_control;			% AMT Control Parameters
		thermal;									% Thermal Definintion
		
		gear_strategy;								% Gear selection strategy structure
			
	end
	

	methods 
		
		% Constructor
		function obj = class_REVS_AMT_transmission( varargin )
									
			obj = obj@class_REVS_transmission( varargin{:} );
            obj.variant = 'AMT transmission system';
            obj.type    = enum_transmission_type.AMT;

            % Default Gearbox Parameters
            obj.gear.shift_duration_secs = 0.5;
            obj.gear.type = enum_transmission_type.AMT;
            
			% Default to no thermal
			obj.thermal.variant = 'none';
						
		end
		
		
		function val = get.inertia_brake(obj)
			
			val = obj.inertia_brake;
			
			if ~isempty( val.torque_capacity_Nm)
				% torque capacity provided -> All good
			elseif obj.control.clutched_upshift
				val.torque_capacity_Nm = 150 * (obj.gear.common_input_inertia_kgm2 + obj.clutch.output_inertia_kgm2);
			else
				val.torque_capacity_Nm = 150 * (obj.gear.common_input_inertia_kgm2 + obj.clutch.input_inertia_kgm2 + obj.clutch.output_inertia_kgm2 + obj.upstream_inertia_kgm2);
			end
						
		end
		

		
		function val = get.clutch(obj)	
			val = obj.clutch;
			val.torque_capacity_Nm = REVS_class_default( val.torque_capacity_Nm, 1.8* obj.rated_torque_Nm );			
		end
		
	end
	
	
	
end

