classdef class_REVS_AT_core_transmission 
	%class_REVS_AT_transmission
	%   Definition of class_REVS_AT_core_transmission class
    % same as class_REVS_AT_transmission minus torque_converter (for P2
    % hybrid, for example).
    
	properties ( Constant = true )
		type = enum_transmission_type.automatic;
	end

	properties
		variant = 'automatic transmission system';

        matrix_vintage = enum_matrix_vintage.present;

        name                = '';                           % Description of transmission
        
        rated_torque_Nm     = 0;                            % transmission rated input torque in Newton-meters
        
		gear                = class_REVS_gearbox;			% Gearbox Definition
		control             = class_REVS_AT_control;        % AT Control Parameters
		thermal;                                            % Thermal Definintion
		pump_loss_Nm class_REVS_dynamic_lookup;             % Transmission Pump Loss - Dynamic Lookup
		
		gear_strategy;                                      % Gear selection strategy structure / class
		tcc_strategy;                                       % TCC lockup strategy structure / class
        
	end
	
	methods 		
		% Constructor
		function obj = class_REVS_AT_core_transmission()
			
			obj.gear.type = enum_transmission_type.automatic;
			obj.gear.shift_duration_secs = 0.5;
	
			obj.pump_loss_Nm = class_REVS_dynamic_lookup;
			
        end
    end
end

