classdef class_REVS_CVT_control  < class_REVS_control
    %class_REVS_CVT_control
    %   Definition of class_REVS_CVT_control class
    
    properties
        % Base Properties
        line_press_rate_limit_barps                         = 35;       % line pressure rate limit, in bar / sec
        line_pressure_map_bar class_REVS_dynamic_lookup;                % line pressure dynamic lookup table
        
        auto_neutral_enable                                 = false;    % Shift transmission to neutral when stopped
        auto_neutral_delay_secs                             = 0;        % Delay before auto neutral shift
        auto_neutral_warmup_condition                       = '1';      % Disable auto neutral is warmup condition is false
        auto_neutral_warmup_temp_degC                       = 50;       % Auto neutral Temperature setpoint for use in warmup condition
        auto_neutral_warmup_duration_secs                   = 100;      % Auto neutral warmup delay for use in warmup condition
    end
    
    methods
        function obj = class_REVS_CVT_control()
            % Blank Line Pressure Map
            obj.line_pressure_map_bar = class_REVS_dynamic_lookup;
            obj.line_pressure_map_bar.axis_1.signal = 'driveline_engaged_bool';
            obj.line_pressure_map_bar.axis_1.breakpoints = [0,1];
            obj.line_pressure_map_bar.table = [0,0];    
        end
        
        function val = get.auto_neutral_warmup_condition(obj)
            if ~obj.auto_neutral_enable
                val = '0';
            elseif ~isempty( obj.auto_neutral_warmup_condition )
                val = obj.auto_neutral_warmup_condition;
            end
        end
    end
    
end

