classdef class_REVS_DCDC_converter
	%class_REVS_DCDC_converter
	%   Definition of class_REVS_DCDC_converter class
	
	properties
		% electrical_source = 'accessory'; % electrical bus name prefix
        output_voltage_V;   % DCDC output voltage [Volts]
        rated_power_W;      % rated power [Watts]
        Kp;                 % converter P of PID
        Ki;                 % converter I of PID
                
        power_loss_map_norm class_REVS_dynamic_lookup; % Efficiency Map, dynamic lookup
    end
	
	methods
        %Constructor
        function obj = class_REVS_DCDC_converter()
            % load default values
            obj.output_voltage_V = 13.15;
            obj.rated_power_W    = 420;
            obj.Kp               = 10;  % same as nominal alternator Kp
            obj.Ki               = 1;   % same as nominal alternator Ki
                        
            % default loss curve based on 420W CUI NQB-N automotive grade
            % (36->75V):12V DCDC converter datasheet
            obj.power_loss_map_norm                    = class_REVS_dynamic_lookup;
            obj.power_loss_map_norm.axis_1.signal      = 'DCDC_load_norm';
            obj.power_loss_map_norm.axis_1.breakpoints = [0      0.14   0.29   0.43  0.57 0.71  0.86  1.0  ]; % output power divided by rated_power_W
            obj.power_loss_map_norm.table              = [0.0048 0.0071 0.0095 0.014 0.02 0.027 0.038 0.052]; % multiply by rated_power_W for actual power loss
        end
        
	end
	
end
