classdef class_REVS_EPA_FTP_cycle_aggregator < class_REVS_cycle_aggregator
    %UNTITLED2 Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
    end
    
    methods
        function obj = class_REVS_EPA_FTP_cycle_aggregator(data, data_root, phase_idx)
            if numel(phase_idx) < 3 || numel(phase_idx) > 4
                error('FTP data must contain 3 or 4 phases');
            end
            
            obj@class_REVS_cycle_aggregator(data, data_root, phase_idx);
                        
        end
        
        
        function val = initial(obj, prop)
            val = obj.phase_data.(prop)(obj.phase_idx(1));           
        end
        
        function val = final(obj, prop)
            val = obj.phase_data.(prop)(obj.phase_idx(end));           
        end
        
        function val = maximum(obj, prop)
            val = max(obj.phase_data.(prop)(obj.phase_idx));           
        end
        
        function val = minimum(obj, prop)
            val = min(obj.phase_data.(prop)(obj.phase_idx));           
        end
        
        function val = sum(obj, prop)
            val = sum(obj.phase_data.(prop)(obj.phase_idx));           
        end
        
        function val = mean(obj, prop)
            cold = sum(obj.phase_data.(prop)(obj.cold_udds_idx) .* obj.phase_data_root.time_secs(obj.cold_udds_idx)) ./ sum(obj.phase_data_root.time_secs(obj.cold_udds_idx));   
            warm = sum(obj.phase_data.(prop)(obj.warm_udds_idx) .* obj.phase_data_root.time_secs(obj.warm_udds_idx)) ./ sum(obj.phase_data_root.time_secs(obj.warm_udds_idx));  
                        
            val =   0.43 * cold + 0.57 * warm ;    
        end
        
        function val = quant_per_dist(obj, prop)
            cold = sum(obj.phase_data.(prop)(obj.cold_udds_idx) .* obj.phase_data_root.distance_m(obj.cold_udds_idx)) ./ sum(obj.phase_data_root.distance_m(obj.cold_udds_idx));
            warm = sum(obj.phase_data.(prop)(obj.warm_udds_idx) .* obj.phase_data_root.distance_m(obj.warm_udds_idx)) ./ sum(obj.phase_data_root.distance_m(obj.warm_udds_idx));
            
            val =   0.43 * cold + 0.57 * warm ;  
        end
        
        function val = dist_per_quant(obj, prop)            
            cold_inv = sum(1./obj.phase_data.(prop)(obj.cold_udds_idx) .* obj.phase_data_root.distance_m(obj.cold_udds_idx)) ./ sum(obj.phase_data_root.distance_m(obj.cold_udds_idx));
            warm_inv = sum(1./obj.phase_data.(prop)(obj.warm_udds_idx) .* obj.phase_data_root.distance_m(obj.warm_udds_idx)) ./ sum(obj.phase_data_root.distance_m(obj.warm_udds_idx));
            
            val = 1 ./ ( 0.43 * cold_inv + 0.57 * warm_inv );
        end
                
    end
    
    methods( Access = private)
        
        function idx = cold_udds_idx(obj)
            idx = obj.phase_idx(1:2);            
        end
        
        function idx = warm_udds_idx(obj)
            idx = obj.phase_idx(end-1:end);            
        end  
          
    end 
    
end

