classdef class_REVS_EPA_combined_aggregator < class_REVS_cycle_aggregator
    %UNTITLED2 Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
    end
    
    methods
        function obj = class_REVS_EPA_combined_aggregator(data, data_root, phase_idx)
            obj@class_REVS_cycle_aggregator(data, data_root, phase_idx);                       
        end
        
        
        function val = initial(obj, prop)
            val = nan;           
        end
        
        function val = final(obj, prop)
            val = nan;           
        end
        
        function val = maximum(obj, prop)
            ftp = obj.phase_data_root.(obj.phase_idx{1}).(prop);
            hwfet = obj.phase_data_root.(obj.phase_idx{2}).(prop);
            val = max(ftp, hwfet);            
        end
        
        function val = minimum(obj, prop)
            ftp = obj.phase_data_root.(obj.phase_idx{1}).(prop);
            hwfet = obj.phase_data_root.(obj.phase_idx{2}).(prop);
            val = min(ftp, hwfet);            
        end
        
        function val = sum(obj, prop)
             ftp = obj.phase_data_root.(obj.phase_idx{1}).(prop);
             hwfet = obj.phase_data_root.(obj.phase_idx{2}).(prop);
            val = ftp + hwfet;            
        end
        
        function val = mean(obj, prop)
            ftp = obj.phase_data_root.(obj.phase_idx{1}).(prop);
            hwfet = obj.phase_data_root.(obj.phase_idx{2}).(prop);
            val = 0.55 * ftp + 0.45 * hwfet;  
        end
        
        function val = quant_per_dist(obj, prop)
            ftp = obj.phase_data_root.(obj.phase_idx{1}).(prop);
            hwfet = obj.phase_data_root.(obj.phase_idx{2}).(prop);
            val = 0.55 * ftp + 0.45 * hwfet;  
        end
        
        function val = dist_per_quant(obj, prop)            
            ftp = obj.phase_data_root.(obj.phase_idx{1}).(prop);
            hwfet = obj.phase_data_root.(obj.phase_idx{2}).(prop);
            val = 1./ (0.55 ./ ftp + 0.45 ./ hwfet); 
        end
                
    end
    
    methods( Access = private)
        
    end 
    
end

