classdef class_REVS_EVM_result < class_REVS_VM_result
	%class_REVS_EVM_result
	%   Definition of class_REVS_EVM_result class
    
    properties
        
    end
    
    properties ( Dependent= true , Transient = true)
        
        MPGe; 
        energy_kWhp100mi;           % Energy [kWh per 100 miles]
        energy_Wh;                  % Energy [Wh]
        energy_Wh_AC;               % Energy [Wh] - Accounting for charging efficiency
        fuel_consumed_e_gallons;    % Fuel consumed [e gallons]
        
    end
    
    %%
    methods
        %% Constructor
        function obj = class_REVS_EVM_result( root, cycle_or_phase_name, varargin )
            obj@class_REVS_VM_result( root, cycle_or_phase_name, varargin{:} );
        end
        
        %% Print Result - to screen or file
        function print( obj, fid )
            if nargin < 2 || isempty(fid)
                fid = 1;
            end
            
             for p = 1:length(obj.time_secs)
                
                if isprop(obj, 'cycle_name')
                    name = obj.cycle_name;
                elseif isprop(obj, 'phase_name')
                    name = obj.phase_name(p);
                else
                    name = '';
                end
                
                fprintf(fid,'   %s: %s\n',                              name, repmat('-', 1,25-length(name)));
                if isprop(obj, 'driver') && isprop(obj.driver, 'error_time_secs')
                    fprintf(fid,'   Percent Time Missed by 2mph = %6.2f %%\n',          obj.driver.error_time_secs(p) ./ obj.time_secs(p) * 100);
                end
                fprintf(fid,'   Distance                    = %6.3f mi\n',        obj.distance_mi(p));
                fprintf(fid,'   Energy Economy              = %6.2f MPGe\n',      obj.MPGe(p));
                fprintf(fid,'   Energy Efficiency           = %6.2f kWh/100mi\n', obj.energy_kWhp100mi(p));
                fprintf(fid,'   Energy Consumption          = %6.2f Wh\n',        obj.energy_Wh(p));
                fprintf(fid,'   Energy Efficiency           = %6.0f Wh/mi\n',     obj.energy_kWhp100mi(p) * 10);
                
                fprintf(fid,'\n');
            end
        end
        
        %% calc methods
        function val = get.energy_kWhp100mi(obj)
            val = obj.energy_Wh / 1000 ./ obj.distance_mi * 100;
        end
        
        function val = get.energy_Wh(obj)
            % val = obj.electric.propulsion_battery.delta_kJ * 1000 / 3600; % this one is internal to the battery cells..
            
            % this one is measured at the battery terminals:
            val = obj.electric.propulsion_battery.output_tot_kJ * 1000 / 3600;
        end
        
    	function val = get.energy_Wh_AC(obj)
            val = obj.energy_Wh./0.9; %https://ieeexplore.ieee.org/document/7046253
        end
        
        function val = get.MPGe(obj)
            val = 33705 ./ (obj.energy_Wh_AC ./ obj.distance_mi);
        end
        
        function val = get.fuel_consumed_e_gallons(obj)
            val = obj.energy_Wh_AC / 33705;
        end

    end
    
end

