classdef class_REVS_HVM_audit < class_REVS_VM_audit
	%class_REVS_HVM_audit
	%   Definition of class_REVS_HVM_audit class
    
    properties
        % Required Parameters
        map_fuel;								% Test Fuel Properties

    end
    
    properties ( Dependent= true , Transient = true)

    end
    
    methods
        %% Constructor
        function obj = class_REVS_HVM_audit( cycle_or_phase_names, orig_fuel )
            
            obj@class_REVS_VM_audit( cycle_or_phase_names );
            
            obj.map_fuel = orig_fuel;
            
        end
                
        function calc_audit(obj)
            calc_audit@class_REVS_VM_audit(obj);
            
            %% calculate engine fuel, crankshaft energy and stored energy                                    
%            obj.energy_balance.source.gross.stored_kJ    = max(0, -obj.electric.propulsion_battery.delta_kJ);
%            obj.energy_balance.source.gross.stored_Wh    = obj.energy_balance.source.gross.stored_kJ / 3.6;
                     
            obj.energy_balance.source.gross.propulsion_battery_stored_kJ = max(0, obj.electric.propulsion_battery.delta_kJ);
            obj.energy_balance.source.gross.accessory_battery_stored_kJ  = max(0, obj.electric.accessory_battery.delta_kJ);
            obj.energy_balance.source.gross.stored_kJ          = obj.energy_balance.source.gross.propulsion_battery_stored_kJ + obj.energy_balance.source.gross.accessory_battery_stored_kJ;
            obj.energy_balance.source.gross.stored_Wh          = obj.energy_balance.source.gross.stored_kJ / 3.6;
            
            obj.energy_balance.source.gross.fuel_kJ      = obj.engine.fuel_consumed_g * obj.map_fuel.energy_density_MJpkg;

%            obj.energy_balance.source.net.stored_kJ      = max(0, -obj.electric.propulsion_battery.output_tot_kJ);
%            obj.energy_balance.source.net.stored_Wh      = obj.energy_balance.source.net.stored_kJ / 3.6;
            
            obj.energy_balance.source.net.propulsion_battery_stored_kJ = max(0, obj.electric.propulsion_battery.output_tot_kJ);
            obj.energy_balance.source.net.accessory_battery_stored_kJ  = max(0, obj.electric.accessory_battery.output_tot_kJ);
            obj.energy_balance.source.net.stored_kJ                    = obj.energy_balance.source.net.propulsion_battery_stored_kJ + obj.energy_balance.source.net.accessory_battery_stored_kJ;
            obj.energy_balance.source.net.stored_Wh            = obj.energy_balance.source.net.stored_kJ / 3.6;            
            
            obj.energy_balance.source.net.engine_kJ      = max(0, obj.engine.gross_tot_kJ);
            obj.energy_balance.source.net.engine_efficiency_pct = obj.energy_balance.source.net.engine_kJ ./ obj.energy_balance.source.gross.fuel_kJ * 100;
            obj.energy_balance.source.net.stored_energy_efficiency_pct =  obj.energy_balance.source.net.stored_kJ ./ obj.energy_balance.source.gross.stored_kJ * 100;

            %% sinks
            obj.energy_balance.sink.gross.battery_loss_kJ = obj.electric.propulsion_battery.battery_loss_kJ;
            obj.energy_balance.sink.vehicle.driveline.engine_crankshaft_kJ = max(0, -obj.engine.gross_tot_kJ);
            
            % calculate stored energy change
%            if isprop(obj,'electric')                
                obj.energy_balance.sink.accessory.battery_internal_loss_kJ  = obj.electric.propulsion_battery.battery_loss_kJ;
                
                obj.energy_balance.sink.accessory.elec.accessory_battery_charge_kJ = max(0, -obj.electric.accessory_battery.output_tot_kJ);
                
%             else
%                 obj.energy_balance.source.gross.stored_kJ = zeros(size(obj.cycle_or_phase_name));
%                 obj.energy_balance.source.net.stored_kJ   = zeros(size(obj.cycle_or_phase_name));
%                 
%                 obj.energy_balance.sink.accessory.battery_internal_loss_kJ = zeros(size(obj.cycle_or_phase_name));
%                 obj.energy_balance.sink.accessory.elec.battery_charge_kJ   = zeros(size(obj.cycle_or_phase_name));
%                 obj.energy_balance.sink.accessory.battery_charge_kWh       = zeros(size(obj.cycle_or_phase_name));
%             end
            
            if isprop(obj.electric,'starter')
                obj.energy_balance.sink.accessory.elec.starter_kJ = obj.electric.starter.loss_kJ;
            else
                obj.energy_balance.sink.accessory.elec.starter_kJ = zeros(size(obj.cycle_or_phase_name));
            end
            
            if isprop(obj.electric,'alternator')
                obj.energy_balance.sink.accessory.elec.alternator_kJ = obj.electric.alternator.loss_kJ;
            else
                obj.energy_balance.sink.accessory.elec.alternator_kJ = zeros(size(obj.cycle_or_phase_name));
            end
            
            %% calculate total energy consumed and total energy provided to driveline
            obj.energy_balance.source.gross.total_kJ =  obj.energy_balance.source.gross.fuel_kJ + ...
                obj.energy_balance.source.gross.stored_kJ + ...
                obj.energy_balance.source.KE_kJ + ...
                obj.energy_balance.source.gradient_kJ;
            
            obj.energy_balance.source.net.total_kJ = obj.energy_balance.source.net.engine_kJ + ...
                obj.energy_balance.source.net.stored_kJ + ...
                obj.energy_balance.source.KE_kJ + ...
                obj.energy_balance.source.gradient_kJ;
            
            %% calc launch device losses ----------------------------------------------
            if  isprop(obj.transmission,'torque_converter')
                obj.energy_balance.sink.vehicle.driveline.gearbox.pump_kJ = obj.transmission.torque_converter.pumploss_tot_kJ;
                obj.energy_balance.sink.vehicle.driveline.launch_device_kJ = obj.transmission.torque_converter.loss_kJ - obj.transmission.torque_converter.pumploss_tot_kJ;
            elseif isprop(obj.transmission,'dual_clutch')                
                obj.energy_balance.sink.vehicle.driveline.gearbox.pump_kJ = zeros(size(obj.cycle_or_phase_name));	% No Pump Losses
                obj.energy_balance.sink.vehicle.driveline.launch_device_kJ = obj.transmission.clutch.loss_kJ + obj.transmission.dual_clutch.clutch1.loss_kJ + obj.transmission.dual_clutch.clutch2.loss_kJ;
            elseif isprop(obj.transmission,'clutch')
                obj.energy_balance.sink.vehicle.driveline.gearbox.pump_kJ = zeros(size(obj.cycle_or_phase_name));	% No Pump Losses
                obj.energy_balance.sink.vehicle.driveline.launch_device_kJ = obj.transmission.clutch.loss_kJ;
            elseif isprop(obj.transmission,'planetary')
                obj.energy_balance.sink.vehicle.driveline.gearbox.pump_kJ  = zeros(size(obj.cycle_or_phase_name));	% No Pump Losses
                obj.energy_balance.sink.vehicle.driveline.launch_device_kJ = zeros(size(obj.cycle_or_phase_name));	% No Launch Device
            else
                error( 'Unknown launch device');
            end
            
            %% calc gearbox losses ----------------------------------------------------
            if isprop(obj.transmission,'dual_clutch')
                obj.energy_balance.sink.vehicle.driveline.gearbox.total_kJ = ...
                    obj.transmission.dual_clutch.input_torque_loss_tot_kJ + ...
                    obj.transmission.gearbox1.loss_kJ + ...
                    obj.transmission.gearbox1.inertia_KE_loss_kJ + ...
                    obj.transmission.gearbox1.inertia_spinup_tot_kJ + ...
                    obj.transmission.gearbox2.loss_kJ + ...
                    obj.transmission.gearbox2.inertia_KE_loss_kJ + ...
                    obj.transmission.gearbox2.inertia_spinup_tot_kJ;

                    obj.energy_balance.sink.vehicle.driveline.gearbox.spin_loss_kJ    = obj.transmission.gearbox1.input_loss_map_tot_kJ + ...
                                                                                        obj.transmission.gearbox1.output_loss_map_tot_kJ + ...
                                                                                        obj.transmission.gearbox2.input_loss_map_tot_kJ + ...
                                                                                        obj.transmission.gearbox2.output_loss_map_tot_kJ;
                                                                                    
                    obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_loss_kJ = obj.transmission.gearbox1.inertia_KE_loss_kJ + ...
                                                                                        obj.transmission.gearbox1.inertia_spinup_tot_kJ + ...
                                                                                        obj.transmission.gearbox2.inertia_KE_loss_kJ + ...
                                                                                        obj.transmission.gearbox2.inertia_spinup_tot_kJ;
                                                                                    
                    obj.energy_balance.sink.vehicle.driveline.gearbox.gear_loss_kJ    = obj.energy_balance.sink.vehicle.driveline.gearbox.total_kJ - ...
                                                                                        obj.energy_balance.sink.vehicle.driveline.gearbox.pump_kJ - ...
                                                                                        obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_loss_kJ - ...
                                                                                        obj.transmission.gearbox1.input_loss_map_tot_kJ - ...
                                                                                        obj.transmission.gearbox2.input_loss_map_tot_kJ - ...
                                                                                        obj.transmission.gearbox1.output_loss_map_tot_kJ - ...
                                                                                        obj.transmission.gearbox2.output_loss_map_tot_kJ;
             elseif isprop(obj.transmission, 'gearbox')
                obj.energy_balance.sink.vehicle.driveline.gearbox.total_kJ = ...
                    obj.transmission.gearbox.loss_kJ + ...
                    obj.energy_balance.sink.vehicle.driveline.gearbox.pump_kJ + ...
                    obj.transmission.gearbox.inertia_KE_loss_kJ + ...
                    obj.transmission.gearbox.inertia_spinup_tot_kJ;

                    obj.energy_balance.sink.vehicle.driveline.gearbox.spin_loss_kJ    = obj.transmission.gearbox.input_loss_map_tot_kJ + ...
                                                                                        obj.transmission.gearbox.output_loss_map_tot_kJ;
                                                                                    
                    obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_loss_kJ = obj.transmission.gearbox.inertia_KE_loss_kJ + ...
                                                                                        obj.transmission.gearbox.inertia_spinup_tot_kJ;
                                                                                    
                    obj.energy_balance.sink.vehicle.driveline.gearbox.gear_loss_kJ    = obj.energy_balance.sink.vehicle.driveline.gearbox.total_kJ - ...
                                                                                        obj.energy_balance.sink.vehicle.driveline.gearbox.pump_kJ - ...
                                                                                        obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_loss_kJ - ...
                                                                                        obj.transmission.gearbox.input_loss_map_tot_kJ - ...
                                                                                        obj.transmission.gearbox.output_loss_map_tot_kJ;
            elseif isprop(obj.transmission, 'planetary') 
                obj.energy_balance.sink.vehicle.driveline.gearbox.spin_loss_kJ    = zeros(size(obj.cycle_or_phase_name));
                obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_loss_kJ = zeros(size(obj.cycle_or_phase_name));
                obj.energy_balance.sink.vehicle.driveline.gearbox.gear_loss_kJ    = obj.transmission.planetary.gear_mesh.loss_kJ + obj.transmission.MG2.gear.loss_kJ;
                
                obj.energy_balance.sink.vehicle.driveline.gearbox.total_kJ        = obj.energy_balance.sink.vehicle.driveline.gearbox.spin_loss_kJ + ...
                                                                                    obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_loss_kJ + ...
                                                                                    obj.energy_balance.sink.vehicle.driveline.gearbox.gear_loss_kJ;
            else
                obj.energy_balance.sink.vehicle.driveline.gearbox.total_kJ        = zeros(size(obj.cycle_or_phase_name));
                obj.energy_balance.sink.vehicle.driveline.gearbox.spin_loss_kJ    = zeros(size(obj.cycle_or_phase_name));
                obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_loss_kJ = zeros(size(obj.cycle_or_phase_name));
                obj.energy_balance.sink.vehicle.driveline.gearbox.gear_loss_kJ    = zeros(size(obj.cycle_or_phase_name));
             end
            
            %% calc accessory losses -------------------------------------------------
            if isprop(obj,'accessories')
                obj.energy_balance.sink.accessory.mech.engine_fan_kJ = obj.accessories.fan_loss.mech_neg_kJ + obj.accessories.fan_loss.gear.loss_kJ;;
                obj.energy_balance.sink.accessory.elec.engine_fan_kJ = obj.accessories.fan_loss.elec_pos_kJ; % + obj.accessories.fan_loss.high_volt_pos_kJ;
                obj.energy_balance.sink.accessory.engine_fan_kJ      = obj.energy_balance.sink.accessory.mech.engine_fan_kJ + obj.energy_balance.sink.accessory.elec.engine_fan_kJ;

                obj.energy_balance.sink.accessory.mech.power_steering_kJ = obj.accessories.power_steering.mech_neg_kJ + obj.accessories.power_steering.gear.loss_kJ;;
                obj.energy_balance.sink.accessory.elec.power_steering_kJ = obj.accessories.power_steering.elec_pos_kJ; % + obj.accessories.power_steering.high_volt_pos_kJ;
                obj.energy_balance.sink.accessory.power_steering_kJ      = obj.energy_balance.sink.accessory.mech.power_steering_kJ + obj.energy_balance.sink.accessory.elec.power_steering_kJ;

                obj.energy_balance.sink.accessory.mech.air_conditioner_kJ = obj.accessories.air_conditioner.mech_neg_kJ + obj.accessories.air_conditioner.gear.loss_kJ;;
                obj.energy_balance.sink.accessory.elec.air_conditioner_kJ = obj.accessories.air_conditioner.elec_pos_kJ; % + obj.accessories.air_conditioner.high_volt_pos_kJ;
                obj.energy_balance.sink.accessory.air_conditioner_kJ      = obj.energy_balance.sink.accessory.mech.air_conditioner_kJ + obj.energy_balance.sink.accessory.elec.air_conditioner_kJ;

                obj.energy_balance.sink.accessory.mech.generic_loss_kJ  = obj.accessories.generic_loss.mech_neg_kJ + obj.accessories.generic_loss.gear.loss_kJ;
                obj.energy_balance.sink.accessory.elec.generic_loss_kJ  = obj.accessories.generic_loss.elec_pos_kJ; % + obj.accessories.generic_loss.high_volt_pos_kJ;
                obj.energy_balance.sink.accessory.generic_loss_kJ       = obj.energy_balance.sink.accessory.mech.generic_loss_kJ + obj.energy_balance.sink.accessory.elec.generic_loss_kJ;
                
                % obj.energy_balance.sink.accessory.elec.total_kJ = obj.accessories.low_volt_total_tot_kJ + obj.accessories.high_volt_total_tot_kJ;
                obj.energy_balance.sink.accessory.elec.total_kJ = obj.energy_balance.sink.accessory.elec.engine_fan_kJ + obj.energy_balance.sink.accessory.elec.power_steering_kJ + obj.energy_balance.sink.accessory.elec.air_conditioner_kJ + obj.energy_balance.sink.accessory.elec.generic_loss_kJ;            
                obj.energy_balance.sink.accessory.mech.total_kJ = obj.accessories.mech_total_neg_kJ;

                obj.energy_balance.sink.accessory.econverter_kJ = obj.electric.accessory_dcdc.loss_kJ;
                
                obj.energy_balance.sink.accessory.total_kJ = ...
                    obj.energy_balance.sink.accessory.mech.total_kJ + ...
                    obj.energy_balance.sink.accessory.elec.starter_kJ + ...
                    obj.energy_balance.sink.accessory.elec.alternator_kJ + ...
                    obj.energy_balance.sink.accessory.econverter_kJ + ...
                    obj.energy_balance.sink.accessory.elec.total_kJ + ...
                    obj.energy_balance.sink.accessory.elec.accessory_battery_charge_kJ;
%                     obj.accessories.low_volt_total_tot_kJ + ...
%                     obj.accessories.high_volt_total_tot_kJ + ...

            else
%                 obj.energy_balance.sink.accessory.econverter_kJ = obj.electric.electric.boost_dcdc.loss_kJ;
                obj.energy_balance.sink.accessory.constant_power_kJ = obj.electric.constant_power_accessories.elec_tot_kJ;

                obj.energy_balance.sink.accessory.total_kJ = ...
                    obj.energy_balance.sink.accessory.elec.starter_kJ + ...
                    obj.energy_balance.sink.accessory.elec.alternator_kJ + ...
                    obj.energy_balance.sink.accessory.econverter_kJ + ...
                    obj.energy_balance.sink.accessory.constant_power_kJ + ...
                    obj.energy_balance.sink.accessory.elec.accessory_battery_charge_kJ;
%                    obj.energy_balance.sink.accessory.mech.total_kJ + ...
%                    obj.accessories.low_volt_total_tot_kJ + ...
%                    obj.accessories.high_volt_total_tot_kJ + ...
            end
            
            %% calc axle losses ------------------------------------------------------
            % if (vehicle.powertrain_type == enum_powertrain_type.hybrid_P0)
            %     audit.mech.drive_motor.loss_kJ = audit.mech.P0_MG.loss_kJ + audit.mech.P0_MG.gearbox.loss_kJ;
            %     % else ... for example:
            %     %     audit.mech.drive_motor.loss_kJ = audit.mech.drive_motor.loss_kJ;
            %     %     (for single drive motor hybrid)
            % end
            
            if isprop(obj.transmission,'drive_motor')
                obj.energy_balance.sink.vehicle.driveline.drive_motor_kJ = obj.transmission.drive_motor.loss_kJ;
            elseif isprop(obj.transmission,'MG1') && isprop(obj.transmission,'MG2')
                obj.energy_balance.sink.vehicle.driveline.drive_motor_kJ = obj.transmission.MG1.loss_kJ + obj.transmission.MG2.loss_kJ; % FOR NOW
            else
                obj.energy_balance.sink.vehicle.driveline.drive_motor_kJ = 0;
            end
            
            if isprop(obj.electric,'P0_MG')
                obj.energy_balance.sink.vehicle.driveline.P0_MG_kJ         = obj.electric.P0_MG.loss_kJ;
                obj.energy_balance.sink.vehicle.driveline.P0_MG_gearing_kJ = obj.electric.P0_MG.gear.loss_kJ;
            else
                obj.energy_balance.sink.vehicle.driveline.P0_MG_kJ         = 0;
                obj.energy_balance.sink.vehicle.driveline.P0_MG_gearing_kJ = 0;                
            end
            
            
            if isprop(obj.transmission,'P2_MG')
                obj.energy_balance.sink.vehicle.driveline.P2_MG_kJ         = obj.transmission.P2_MG.loss_kJ;
                obj.energy_balance.sink.vehicle.driveline.P2_MG_gearing_kJ = obj.transmission.P2_MG.gear.loss_kJ;
            else
                obj.energy_balance.sink.vehicle.driveline.P2_MG_kJ         = 0;
                obj.energy_balance.sink.vehicle.driveline.P2_MG_gearing_kJ = 0;                
            end
            
            
            obj.energy_balance.sink.vehicle.driveline.propulsion_battery_charge_kJ = max(0, -obj.electric.propulsion_battery.output_tot_kJ);
            obj.energy_balance.sink.vehicle.driveline.battery_charge_kWh           = max(0, -obj.electric.propulsion_battery.delta_kWh);
            
            if isprop(obj.electric,'boost_dcdc')
                obj.energy_balance.sink.vehicle.driveline.HV_econverter_kJ =  obj.electric.boost_dcdc.loss_kJ;
            else
                obj.energy_balance.sink.vehicle.driveline.HV_econverter_kJ = 0;                
            end
            
            obj.energy_balance.sink.vehicle.driveline.total_kJ = obj.energy_balance.sink.vehicle.driveline.engine_crankshaft_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.propulsion_battery_charge_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.launch_device_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.HV_econverter_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.drive_motor_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.P0_MG_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.P0_MG_gearing_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.P2_MG_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.P2_MG_gearing_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.gearbox.total_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.final_drive_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.friction_brake_kJ + ...
                obj.energy_balance.sink.vehicle.driveline.tire_slip_kJ;

             if isprop(obj.transmission,'inertia_brake_pos_kJ')   % add audit for AMT inertia brake...
                 obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_brake_kJ = obj.transmission.inertia_brake_pos_kJ;                 
                 obj.energy_balance.sink.vehicle.driveline.total_kJ    = obj.energy_balance.sink.vehicle.driveline.total_kJ + obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_brake_kJ;
             end
             
            if isprop(obj.vehicle,'transfer_case')      % Add transfer case if present
                 obj.energy_balance.sink.vehicle.driveline.transfer_case_kJ = obj.vehicle.transfer_case.loss_kJ;
                 obj.energy_balance.sink.vehicle.driveline.total_kJ = obj.energy_balance.sink.vehicle.driveline.total_kJ + obj.energy_balance.sink.vehicle.driveline.transfer_case_kJ;
             end
            
            if isprop(obj.vehicle,'driveshaft')         % Add driveshaft if present
                obj.energy_balance.sink.vehicle.driveline.driveshaft_kJ = obj.vehicle.driveshaft.loss_kJ;
                obj.energy_balance.sink.vehicle.driveline.total_kJ = obj.energy_balance.sink.vehicle.driveline.total_kJ + obj.energy_balance.sink.vehicle.driveline.driveshaft_kJ;
            end
            
            %% calc total losses ------------------------------------------------------
            obj.energy_balance.sink.total_kJ = obj.energy_balance.sink.accessory.total_kJ + obj.energy_balance.sink.vehicle.driveline.total_kJ + obj.energy_balance.sink.vehicle.roadload_kJ + obj.energy_balance.sink.KE_kJ;
            
            obj.energy_balance.simulation_error_kJ       = obj.energy_balance.source.net.total_kJ - obj.energy_balance.sink.total_kJ;
            obj.energy_balance.energy_conservation_pct   = obj.energy_balance.sink.total_kJ ./ obj.energy_balance.source.net.total_kJ * 100;
        end
        
        function print( obj, fid )
            obj.calc_audit();
            
            if nargin < 2 || isempty(fid)
                fid = 1;
            end
            
            for p = 1:length(obj.cycle_or_phase_name)
                if ~isempty( obj.cycle_or_phase_name ) && p <= length(obj.cycle_or_phase_name )
                    name = obj.cycle_or_phase_name{p};
                else
                    name = '';
                end
                
                fprintf(fid,'   %s audit: %s\n', name, repmat('-', 1, 25-length(name)));
                fprintf(fid, '\n         ---- Energy Audit Report ----\n');
                fprintf(fid,'\n');
                
                fprintf(fid,'Gross Energy Provided            = %8.2f kJ\n',                  obj.energy_balance.source.gross.total_kJ(p));
                result_fprintf(fid,'    Fuel Energy                  = %8.2f kJ  %8.2f%%\n',  obj.energy_balance.source.gross.fuel_kJ(p),   obj.energy_balance.source.gross.total_kJ(p));
                result_fprintf(fid,'    Stored Energy                = %8.2f kJ  %8.2f%%\n',  obj.energy_balance.source.gross.stored_kJ(p), obj.energy_balance.source.gross.total_kJ(p));
                %                result_fprintf(fid,'         Battery Internal Losses = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.battery_internal_loss_kJ(p), obj.energy_balance.source.gross.total_kJ(p));
                result_fprintf(fid,'    Kinetic Energy               = %8.2f kJ  %8.2f%%\n',  obj.energy_balance.source.KE_kJ(p),           obj.energy_balance.source.gross.total_kJ(p));
                result_fprintf(fid,'    Potential Energy             = %8.2f kJ  %8.2f%%\n\n',obj.energy_balance.source.gradient_kJ(p),     obj.energy_balance.source.gross.total_kJ(p));
                
                fprintf(fid,'Net Energy Provided              = %8.2f kJ\n',                  obj.energy_balance.source.net.total_kJ(p));
                result_fprintf(fid,'    Engine Energy                = %8.2f kJ%8.2f%%\n',    obj.energy_balance.source.net.engine_kJ(p),   obj.energy_balance.source.net.total_kJ(p));
                       fprintf(fid,'         Engine Efficiency       = %8.2f %%\n',           obj.energy_balance.source.net.engine_efficiency_pct(p));
                result_fprintf(fid,'    Stored Energy                = %8.2f kJ  %8.2f%%\n',  obj.energy_balance.source.net.stored_kJ(p),   obj.energy_balance.source.net.total_kJ(p));
                result_fprintf(fid,'        Propulsion Batt. Energy  = %8.2f kJ  %8.2f%%\n',  obj.energy_balance.source.net.propulsion_battery_stored_kJ(p), obj.energy_balance.source.net.total_kJ(p));
                result_fprintf(fid,'        Accessory Batt. Energy   = %8.2f kJ  %8.2f%%\n',  obj.energy_balance.source.net.accessory_battery_stored_kJ(p), obj.energy_balance.source.net.total_kJ(p));                
                result_fprintf(fid,'    Kinetic Energy               = %8.2f kJ  %8.2f%%\n',  obj.energy_balance.source.KE_kJ(p),           obj.energy_balance.source.net.total_kJ(p));
                result_fprintf(fid,'    Potential Energy             = %8.2f kJ  %8.2f%%\n\n',obj.energy_balance.source.gradient_kJ(p),     obj.energy_balance.source.net.total_kJ(p));
                if obj.vehicle.final_use_abc_roadload
                    result_fprintf(fid, 'Energy Consumed by ABC roadload  = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.ABC_drag_neg_kJ(p),     obj.energy_balance.sink.total_kJ(p));
                else
                    result_fprintf(fid, 'Energy Consumed by Crr           = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.rolling_resistance_kJ(p),  obj.energy_balance.sink.total_kJ(p));
                    result_fprintf(fid, 'Energy Consumed by Cd            = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.aerodynamic_drag_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                end
                result_fprintf(fid, 'Energy Consumed by Gradient      = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.gradient_kJ(p),        obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, 'Energy Consumed by Accessories   = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.total_kJ(p),               obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    Starter                      = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.elec.starter_kJ(p),  obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    Alternator                   = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.elec.alternator_kJ(p), obj.energy_balance.sink.total_kJ(p));
            if isprop(obj,'accessories')
                result_fprintf(fid, '    Engine Fan                   = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.engine_fan_kJ(p),            obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '         Electrical              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.elec.engine_fan_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '         Mechanical              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.mech.engine_fan_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    Power Steering               = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.power_steering_kJ(p),      obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '         Electrical              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.elec.power_steering_kJ(p), obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '         Mechanical              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.mech.power_steering_kJ(p), obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    Air Conditioning             = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.air_conditioner_kJ(p),         obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '         Electrical              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.elec.air_conditioner_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '         Mechanical              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.mech.air_conditioner_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    Generic Loss                 = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.generic_loss_kJ(p),            obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '         Electrical              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.elec.generic_loss_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '         Mechanical              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.mech.generic_loss_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    DCDC Converter Losses        = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.econverter_kJ(p), obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    Battery Stored Charge        = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.elec.accessory_battery_charge_kJ(p), obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    Total Electrical Accessories = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.elec.total_kJ(p),      obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '    Total Mechanical Accessories = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.mech.total_kJ(p),      obj.energy_balance.sink.total_kJ(p));
            else
                %    fprintf(output_fid,'     Engine Accessories          = %8.2f kJ  %8.2f%%\n', audit.mech.engine.accessories_neg_kJ(end), audit.mech.engine.accessories_neg_kJ(end) / audit.energy_balance.total_loss_kJ(end)*100);
                result_fprintf(fid, '     Electrical Accessories      = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.constant_power_kJ(p), obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '     DCDC Converter              = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.accessory.econverter_kJ(p), obj.energy_balance.sink.total_kJ(p));
                
            end
                result_fprintf(fid, 'Energy Consumed by Driveline     = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.total_kJ(p),             obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '     Battery Stored Charge       = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.propulsion_battery_charge_kJ(p), obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '     Engine                      = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.engine_crankshaft_kJ(p), obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid, '     Launch Device / Clutches    = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.launch_device_kJ(p),     obj.energy_balance.sink.total_kJ(p));

                result_fprintf(fid, '     High Voltage DCDC           = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.HV_econverter_kJ(p),     obj.energy_balance.sink.total_kJ(p));                                
                if length(obj.energy_balance.sink.vehicle.driveline.drive_motor_kJ) == length(obj.cycle_or_phase_name)
                    result_fprintf(fid, '     Driveline Emachines         = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.drive_motor_kJ(p),       obj.energy_balance.sink.total_kJ(p));                    
                    if isprop(obj.transmission,'MG1') && isprop(obj.transmission,'MG2')
                        result_fprintf(fid, '         MG1                     = %8.2f kJ  %8.2f%%\n', obj.transmission.MG1.loss_kJ(p), obj.energy_balance.sink.total_kJ(p));
                        result_fprintf(fid, '         MG2                     = %8.2f kJ  %8.2f%%\n', obj.transmission.MG2.loss_kJ(p), obj.energy_balance.sink.total_kJ(p));
                    end                                        
                end
                %if length(obj.energy_balance.sink.vehicle.driveline.P0_MG_kJ) == length(obj.cycle_or_phase_name)
                if isprop(obj.electric,'P0_MG')
                    result_fprintf(fid, '     P0 Motor Generator     = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.P0_MG_kJ(p),            obj.energy_balance.sink.total_kJ(p));
                    result_fprintf(fid, '     P0 Gearing             = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.P0_MG_gearing_kJ(p),            obj.energy_balance.sink.total_kJ(p));                                
                end
                if isprop(obj.transmission,'P2_MG')
                    result_fprintf(fid, '     P2 Motor Generator     = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.P2_MG_kJ(p),            obj.energy_balance.sink.total_kJ(p));
                    result_fprintf(fid, '     P2 Gearing             = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.P2_MG_gearing_kJ(p),            obj.energy_balance.sink.total_kJ(p));                                
                end
                result_fprintf(fid, '     Gearbox                     = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.gearbox.total_kJ(p),     obj.energy_balance.sink.total_kJ(p));
                try
                    result_fprintf(fid,'         Pump Loss               = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.gearbox.pump_kJ(p),      obj.energy_balance.sink.total_kJ(p));
                    result_fprintf(fid,'         Spin Loss               = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.gearbox.spin_loss_kJ(p),     obj.energy_balance.sink.total_kJ(p));
                    result_fprintf(fid,'         Gear Loss               = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.gearbox.gear_loss_kJ(p),     obj.energy_balance.sink.total_kJ(p));
                    result_fprintf(fid,'         Inertia Loss            = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_loss_kJ(p),  obj.energy_balance.sink.total_kJ(p));
                    if isprop(obj.transmission,'inertia_brake_pos_kJ')
                        result_fprintf(fid,'         Input Inertia Brake     = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.gearbox.inertia_brake_kJ(p),  obj.energy_balance.sink.total_kJ(p));
                    end                    
                end
                if isprop(obj.vehicle,'driveshaft')
                result_fprintf(fid,'     Driveshaft                  = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.driveshaft_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                end
                if isprop(obj.vehicle,'transfer_case')
                result_fprintf(fid,'     Transfer Case               = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.transfer_case_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                end                
                result_fprintf(fid,'     Final Drive                 = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.final_drive_kJ(p),    obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid,'     Friction Brakes             = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.friction_brake_kJ(p),  obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid,'     Tire Slip                   = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.vehicle.driveline.tire_slip_kJ(p),      obj.energy_balance.sink.total_kJ(p));
                result_fprintf(fid,'System Kinetic Energy Gain       = %8.2f kJ  %8.2f%%\n', obj.energy_balance.sink.KE_kJ(p),          obj.energy_balance.sink.total_kJ(p));
                fprintf(fid,'                                    ------------\n');
                fprintf(fid,'Total Loss Energy                = %8.2f kJ\n', obj.energy_balance.sink.total_kJ(p));
                fprintf(fid,'Simulation Error                 = %8.2f kJ\n', obj.energy_balance.simulation_error_kJ(p));
                fprintf(fid,'Energy Conservation              = %8.3f %%\n', obj.energy_balance.energy_conservation_pct(p));
                fprintf(fid,'\n');
            end
        end
    end
    
end
