classdef class_REVS_P0_control < class_REVS_CVM_control
    %class_REVS_P0_control
    %   For mild hybrid P0 controls
    
    properties
        %        hybrid_max_torque_speeds_radps
        %        hybrid_max_torque_curve_Nm
                        
        hybrid_system_enable
        regenerative_braking_enable
        
        stop_delay_secs
        
        regen_vspeed_limit_mps
        regen_vspeed_derate_norm
        
        regen_soc_limit_norm
        regen_soc_derate_norm
        
        motor_vspeed_limit_mps
        motor_vspeed_derate_norm
        
        motor_soc_limit_norm
        motor_soc_derate_norm
        
        motor_min_power_threshold_W
        regen_min_power_threshold_W
        
        engine_min_bsfc_speed_radps
        engine_min_bsfc_torque_Nm
        
        P0_controls_variant
        
        charge_depleting_min_soc_norm
        charge_sustaining_max_soc_norm
        
        ev_mode_min_soc_norm
        ev_mode_soc_limit_norm
        ev_mode_soc_derate_norm

    end
    
    methods
        
        function obj = class_REVS_P0_control(varargin)
            
            obj = obj@class_REVS_CVM_control(varargin{:});
            
            obj.stop_delay_secs         = 0.1;
            obj.start_stop_enable       = true;
            obj.start_stop_warmup_condition = '(@cycle_pos_secs >= 100)';
            
            obj.hybrid_system_enable        = true;
            obj.regenerative_braking_enable = true;
            
            obj.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;
                        
        end
        
        function obj = update_powertrain_info(obj, engine, transmission, accessories)
            
            obj = update_powertrain_info@class_REVS_CVM_control(obj, engine, transmission, accessories);
            
            [obj.engine_min_bsfc_speed_radps, obj.engine_min_bsfc_torque_Nm] = REVS_calc_engine_min_bsfc(engine);
            
        end % update_powertrain_info()

    end
    
end
