classdef class_REVS_P0_control_Malibu_ECO < class_REVS_P0_control
    %class_REVS_P0_control_Malibu_ECO
    %   For Malibu ECO P0 controls
    
    properties
        hybrid_max_torque_speeds_radps
        hybrid_max_torque_curve_Nm
        
        regen_vspeed_limit_torque_Nm
        
        max_wheel_torque_Nm
        max_wheel_power_W

        max_wheel_torque_vspeed_mps
        max_wheel_torque_table        
    end
    
    methods
        
        function obj = class_REVS_P0_control_Malibu_ECO(varargin)
            obj = obj@class_REVS_P0_control(varargin{:});
            
            obj.stop_delay_secs         = 0.1;
            obj.start_stop_enable       = true;
            obj.start_stop_warmup_condition = '(@cycle_pos_secs >= 100)';
            
            obj.hybrid_system_enable        = true;
            obj.regenerative_braking_enable = true;
            
        end
        
    end
    
end
