classdef class_REVS_P2_electric
	% REVS_P2_electric
	%    P2 Electric description class. Contains definitions for
	%	electric components specific to the P2 architecture
	
	properties
        name = '';
        
        matrix_vintage    = enum_matrix_vintage.present      
		starter           = class_REVS_starter		
        alternator        = class_REVS_alternator		
        low_voltage_DCDC  = class_REVS_DCDC_converter
        high_voltage_DCDC = class_REVS_DCDC_converter
        
         
        accessory_battery class_REVS_battery    % accessory battery (for xEV)
        propulsion_battery class_REVS_battery   % propulsion battery (for xEV)
        battery class_REVS_battery              % starter / accessory battery (for CVM)
        
        P0_MG class_REVS_emachine_geared;      % motor / generator (for BAS/ISG/HSG hybrids)
        P2_MG class_REVS_emachine_geared;         % generator / motor 
        
        disconnect_clutch class_REVS_clutch;  % disconnect clutch
        
	end
	
	methods
		
		function obj = class_REVS_P2_electric( engine )
			% Pass in Engine class to auto calculate starter & alternator
			% parameters
			
			if nargin > 0
				obj.starter = class_REVS_starter( engine );
				obj.alternator = class_REVS_alternator( engine );
            else
                obj.starter = class_REVS_starter;
                obj.alternator = class_REVS_alternator;
            end									            
		end
				
	end
	
end

