classdef class_REVS_VM_audit < class_REVS_logging_object
	%class_REVS_VM_audit
	%   Definition of class_REVS_VM_audit class
    
    properties
        % Required Parameters
        cycle_or_phase_name;    % cycle phase Name
               
        energy_balance;
    end
    
    properties ( Dependent= true , Transient = true)
                
    end
    
    methods
        
        %% Constructor
        function obj = class_REVS_VM_audit( cycle_or_phase_names )
            
            obj.cycle_or_phase_name = cycle_or_phase_names;
            
        end
                
        %% audit calcs applicable to all powertrains
        function [] = calc_audit(obj)
            obj.energy_balance = [];

            obj_vars = fieldnames_all('obj');
            
            % auto-sum variables:
            %% KE_kJ
            varlist = obj_vars(contains(obj_vars, 'KE_kJ'));
            sum = 0;
            for v = 1:length(varlist)
                sum = sum + eval(varlist{v});
                %varlist{v}
                %eval(varlist{v})
            end
            obj.energy_balance.source.KE_kJ = max(0, -sum);
            obj.energy_balance.sink.KE_kJ   = max(0, sum);
            
            %% friction_brake_kJ
            varlist = obj_vars(contains(obj_vars, 'brake_neg_kJ'));
            sum = 0;
            for v = 1:length(varlist)
                sum = sum + eval(varlist{v});
            end
            obj.energy_balance.sink.vehicle.driveline.friction_brake_kJ = sum;
            
            %% rolling_resistance_kJ
            varlist = obj_vars(contains(obj_vars, 'rolling_drag_neg_kJ'));
            sum = 0;
            for v = 1:length(varlist)
                sum = sum + eval(varlist{v});
            end
            obj.energy_balance.sink.vehicle.rolling_resistance_kJ = sum;
            
            %% final_drive_kJ
            varlist = obj_vars(contains(obj_vars, 'final_drive.loss_kJ'));
            sum = 0;
            for v = 1:length(varlist)
                sum = sum + eval(varlist{v});
            end
            obj.energy_balance.sink.vehicle.driveline.final_drive_kJ = sum;
            
            %%  tire_slip_kJ
            varlist = obj_vars(contains(obj_vars, 'tire.input_pos_kJ'));
            sum = 0;
            for v = 1:length(varlist)
                sum = sum + eval(varlist{v});
            end
            tire_input_pos_kJ = sum;
            
            varlist = obj_vars(contains(obj_vars, 'tire.output_pos_kJ'));
            sum = 0;
            for v = 1:length(varlist)
                sum = sum + eval(varlist{v});
            end
            tire_output_pos_kJ = sum;
            
            varlist = obj_vars(contains(obj_vars, 'tire.input_neg_kJ'));
            sum = 0;
            for v = 1:length(varlist)
                sum = sum + eval(varlist{v});
            end
            tire_input_neg_kJ = sum;
            
            varlist = obj_vars(contains(obj_vars, 'tire.output_neg_kJ'));
            sum = 0;
            for v = 1:length(varlist)
                sum = sum + eval(varlist{v});
            end
            tire_output_neg_kJ = sum;
            
            obj.energy_balance.sink.vehicle.driveline.tire_slip_kJ = tire_input_pos_kJ - tire_output_pos_kJ + tire_output_neg_kJ - tire_input_neg_kJ;
            
            %% calculate kinetic energy change and roadload losses
            obj.energy_balance.sink.vehicle.gradient_kJ = obj.vehicle.gradient_drag_neg_kJ;
            obj.energy_balance.source.gradient_kJ = obj.vehicle.gradient_drag_pos_kJ;
            
            if obj.vehicle.final_use_abc_roadload
                obj.energy_balance.sink.vehicle.roadload_kJ   = obj.vehicle.ABC_drag_neg_kJ + obj.energy_balance.sink.vehicle.gradient_kJ;
            else
                obj.energy_balance.sink.vehicle.aerodynamic_drag_kJ  = obj.vehicle.aerodynamic_drag_neg_kJ;
                obj.energy_balance.sink.vehicle.roadload_kJ   = obj.energy_balance.sink.vehicle.aerodynamic_drag_kJ + obj.energy_balance.sink.vehicle.gradient_kJ + obj.energy_balance.sink.vehicle.rolling_resistance_kJ;
            end
            
            obj.energy_balance.sink.vehicle.ABC_drag_neg_kJ = obj.vehicle.ABC_drag_neg_kJ;
        end
        
    end
    
end

