classdef class_REVS_aftertreatment_SCR < class_REVS_aftertreatment_component
	%class_REVS_aftertreatment_DOC
	% Parameters for the REVS diesel oxidation cayalyst model
	
	properties

		fast_reaction_conversion_norm class_REVS_dynamic_lookup = class_REVS_dynamic_lookup;
		NO_reaction_conversion_norm class_REVS_dynamic_lookup = class_REVS_dynamic_lookup;
		NO2_reaction_conversion_norm class_REVS_dynamic_lookup = class_REVS_dynamic_lookup;
		
	end
	
	methods
		
		function obj = class_REVS_aftertreatment_SCR( )
			
			obj.fast_reaction_conversion_norm.axis_1.signal = 'exh_avg_temp_degC';
			obj.fast_reaction_conversion_norm.axis_1.breakpoints =	[	0,		200,	600,	1000];
			obj.fast_reaction_conversion_norm.table =				[	0,		0,		0,		0];	
			
			obj.NO_reaction_conversion_norm.axis_1.signal = 'exh_avg_temp_degC';
			obj.NO_reaction_conversion_norm.axis_1.breakpoints =	[	0,		200,	600,	1000];
			obj.NO_reaction_conversion_norm.table =                 [	0,		0,		0,		0];	
			
			obj.NO2_reaction_conversion_norm.axis_1.signal = 'exh_avg_temp_degC';
			obj.NO2_reaction_conversion_norm.axis_1.breakpoints =	[	0,		200,	600,	1000];
			obj.NO2_reaction_conversion_norm.table =				[	0,		0,		0,		0];	
			
		end
						
	end
end

