classdef class_REVS_audit
    %class_REVS_audit
    %   Definition of class_REVS_audit class
    
    properties
        
        phase;
        total;
        
    end
    
    methods
        
        function obj = class_REVS_audit(  )
            
            powertrain_type = evalin('caller', 'vehicle.powertrain_type');
            
            drive_cycle = evalin('caller','drive_cycle');
            
%             if isvector(drive_cycle.phase_name) && ~isscalar(drive_cycle.phase_name)
%                 audit_phase_names = [drive_cycle.phase_name(drive_cycle.phase > 0)];
%             else
                audit_phase_names = drive_cycle.phase_name;
%             end
            
            % Make phase and total appropriate format for model type
            if powertrain_type.is_conventional
                map_fuel = evalin('caller','engine.fuel');                
                
                obj.phase = class_REVS_CVM_audit(audit_phase_names, map_fuel);
                obj.total = class_REVS_CVM_audit({drive_cycle.name}, map_fuel);
            elseif powertrain_type.is_hybrid
                map_fuel = evalin('caller','engine.fuel');
                
                obj.phase = class_REVS_HVM_audit(audit_phase_names, map_fuel);
                obj.total = class_REVS_HVM_audit({drive_cycle.name}, map_fuel);
            elseif powertrain_type.is_P0
                map_fuel = evalin('caller','engine.fuel');
                
                obj.phase = class_REVS_HVM_audit(audit_phase_names, map_fuel);
                obj.total = class_REVS_HVM_audit({drive_cycle.name}, map_fuel);
            elseif powertrain_type.is_P2
                map_fuel = evalin('caller','engine.fuel');
                
                obj.phase = class_REVS_HVM_audit(audit_phase_names, map_fuel);
                obj.total = class_REVS_HVM_audit({drive_cycle.name}, map_fuel);
            elseif powertrain_type.is_bev
                obj.phase = class_REVS_EVM_audit(audit_phase_names);
                obj.total = class_REVS_EVM_audit({drive_cycle.name});
            else
                obj.phase = class_REVS_VM_audit(audit_phase_names);
                obj.total = class_REVS_VM_audit({drive_cycle.name});
                warning('Unknown powertrain type "%s" ',powertrain_type)
            end
            
            % Get list of maatching workspace variables
            ws_vars = sort(evalin('caller',['who(''audit__*'');']));
            
            for v = 1:length(ws_vars)
                
                % root field to work off - all
                working_p = obj.phase;
                working_t = obj.total;
                
                % Only load non-empty data
                if ~evalin('caller',['isempty(', ws_vars{v} ,');'] )
                    
                    var_fields = strsplit( ws_vars{v}, '__');
                    for f = 2:(length(var_fields)-1)
                        % Add nonexistent properties
                        if ~isprop( working_p,var_fields{f})
                            working_p.addprop(var_fields{f});
                            working_p.(var_fields{f}) = class_REVS_logging_object;
                            working_t.addprop(var_fields{f});
                            working_t.(var_fields{f}) = class_REVS_logging_object;
                            
                        end
                        % Move along tree
                        working_p = working_p.(var_fields{f});
                        working_t = working_t.(var_fields{f});
                    end
                    
                    if ~isprop( working_p,var_fields{end})
                        working_p.addprop(var_fields{end});
                        working_t.addprop(var_fields{end});
                    end
                    
                    % Add final field & Load data
                    data = evalin('caller',ws_vars{v});
                    working_t.( var_fields{end} ) = data(:,1);
                    
                    if size(data,2) > 1
                        working_p.( var_fields{end} ) = data(:,2:end);
                    end
                    
                end
                
                % cleanup workspace
                evalin('caller',['clear ', ws_vars{v}]);
            end
            
            %After data is loaded add calculated properties
            obj.total.add_calculated_properties;
            obj.phase.add_calculated_properties;
        end
        
        
        function calc_audit(obj, audit_type)
            
            if nargin == 1
                audit_type = evalin('caller','REVS.logging_config.audit_type');
            end
            
            if audit_type >= 2
                obj.phase.calc_audit;
            end
            
            if audit_type >= 1
                obj.total.calc_audit;
            end
            
        end
        
        function print( obj, audit_type, fid )
            
            if nargin == 1
                audit_type = evalin('caller','REVS.logging_config.audit_type');
            end
                        
            if nargin < 3 || isempty(fid)
                fid = 1;
            end
            
            if audit_type >= 2
                obj.phase.print(fid);
            end
            
            if audit_type >= 1
                obj.total.print(fid);
            else
                warning('No Audit Data Available');
            end
                        
        end
        
    end
    
end

