classdef class_REVS_battery_cell
    %class_REVS_battery_cell
    %   Definition of class_REVS_battery_cell class
    
    properties
        chemistry;									% Battery Chemistry from enum_battery_type
        initial_soc_norm;							% Initial cell state of charge [0-1]
        
        capacity_Coulombs;							% Battery charge capacity [Culombs]
        
        powerlimit_discharge_map_W class_REVS_dynamic_lookup;					% Discharging Power Limit [Watts]
        powerlimit_charge_map_W class_REVS_dynamic_lookup;                      % Charging Power Limit [Watts]
        
        open_circuit_voltage_map_discharge_V class_REVS_dynamic_lookup;		% Open Circuit Voltage Map while Discharging [V]
        open_circuit_voltage_map_charge_V class_REVS_dynamic_lookup;        % Open Circuit Voltage Map while Charging [V]
        
        use_average_open_circuit_Volts;				% Use Average Open Circut Voltage Map instead of charging & discharging maps
        
        transient_R_discharge_short_term_Ohms class_REVS_dynamic_lookup;		% Transient response short term RC resistance when discharging [Ohms]
        transient_R_charge_short_term_Ohms class_REVS_dynamic_lookup;			% Transient response short term RC resistance when charging [Ohms]
        transient_R_discharge_long_term_Ohms class_REVS_dynamic_lookup;         % Transient response long term RC resistance when discharging [Ohms]
        transient_R_charge_long_term_Ohms class_REVS_dynamic_lookup;			% Transient response long term RC resistance when charging [Ohms]
        
        resistance_map_discharge_Ohms class_REVS_dynamic_lookup;				% Internal Resistance map while discharging [Ohms]
        resistance_map_charge_Ohms class_REVS_dynamic_lookup;					% Internal Resistance map while charging [Ohms]
        
        transient_C_discharge_short_term_Farads class_REVS_dynamic_lookup;      % Transient response short term RC capacitance when discharging [Farads]
        transient_C_charge_short_term_Farads class_REVS_dynamic_lookup;         % Transient response short term RC capacitance when charging [Farads]
        transient_C_discharge_long_term_Farads class_REVS_dynamic_lookup;		% Transient response long term RC capacitance when discharging [Farads]
        transient_C_charge_long_term_Farads class_REVS_dynamic_lookup;          % Transient response long term RC capacitance when charging [Farads]
        
        charge_efficiency_map_norm class_REVS_dynamic_lookup;					% Charging efficiency map [0-1]
        
        temperature_power_derate_index_temp_degC;	% Power Limit Temperature Derate axis [degC]
        temperature_power_discharge_derate_norm;	% Power Limit Temperature Derate map when discharging [0-1]
        temperature_power_charge_derate_norm;		% Power Limit Temperature Derate map when charging [0-1]
        
    end
    
    properties (Dependent = true, Transient = true)
        capacity_nominal_Ah;						% Cell Nominal Capacity [Amp*Hours]
        
%         open_circuit_voltage_map_V;					% Open Circuit Voltage Combined [V] - for future use
%         transient_R_short_term_Ohms;				% Transient response short term RC resistance [Ohms] - for future use
%         transient_R_long_term_Ohms;					% Transient response long term RC resistance [Ohms] - for future use
%         transient_C_short_term_Fards;				% Transient response short term RC capacitance [Farads] - for future use
%         transient_C_long_term_Fards;				% Transient response long term RC capacitance [Farads] - for future use
%         resistance_map_Ohms;						% Internal Resistance Map [Ohms] - for future use
        
    end
    
    %%
    methods
        
        %Constructor
        function obj = class_REVS_battery_cell()
            obj.powerlimit_discharge_map_W              = class_REVS_dynamic_lookup;
            obj.powerlimit_charge_map_W                 = class_REVS_dynamic_lookup;
            
            obj.open_circuit_voltage_map_charge_V       = class_REVS_dynamic_lookup;
            obj.open_circuit_voltage_map_discharge_V    = class_REVS_dynamic_lookup;
            
            obj.transient_R_discharge_short_term_Ohms   = class_REVS_dynamic_lookup;
            obj.transient_R_charge_short_term_Ohms      = class_REVS_dynamic_lookup;
            obj.transient_R_discharge_long_term_Ohms    = class_REVS_dynamic_lookup;
            obj.transient_R_charge_long_term_Ohms       = class_REVS_dynamic_lookup;
            
            obj.resistance_map_discharge_Ohms           = class_REVS_dynamic_lookup;
            obj.resistance_map_charge_Ohms              = class_REVS_dynamic_lookup;
            
            obj.transient_C_discharge_short_term_Farads = class_REVS_dynamic_lookup;
            obj.transient_C_charge_short_term_Farads    = class_REVS_dynamic_lookup;
            obj.transient_C_discharge_long_term_Farads  = class_REVS_dynamic_lookup;
            obj.transient_C_charge_long_term_Farads     = class_REVS_dynamic_lookup;
            
            obj.charge_efficiency_map_norm              = class_REVS_dynamic_lookup;
        end
        
        function obj = set.capacity_nominal_Ah(obj,val)
            obj.capacity_Coulombs = val * 3600;
        end
        
        function val = get.capacity_nominal_Ah(obj)
            val = obj.capacity_Coulombs / 3600;
        end
        
    end
    
end

