classdef class_REVS_cycle_result < class_REVS_cycle_result_object
	%class_REVS_VM_result
	%   Definition of class_REVS_VM_result class
    
    
    
    
    properties 
        cycle_name
        phase_names
        
    end
       
    
    methods
        %% Constructor
        function obj = class_REVS_cycle_result( cycle_name, phase_data, phase_idx, aggregator )
            
            if nargin < 4
                aggregator = @default_aggregator; 
            elseif ~isa(aggregator,'function_handle')
                error('Aggregator must be a valid function handle');
            end
            
            obj@class_REVS_cycle_result_object(phase_data, phase_data, phase_idx, aggregator )

            obj.cycle_name = cycle_name;
            obj.phase_names = obj.phase_data.cycle_or_phase_name(obj.phase_idx);
                                   
        end
               
        
        %% Print Result - to screen or file
        function print( obj, fid )
            
            if nargin < 2 || isempty(fid)
                fid = 1;
            end
            
            for p = 1:length(obj.fuel_consumed_g)
                
                if ~isempty( obj.cycle_or_phase_name ) && p <= length(obj.cycle_or_phase_name )
                    name = obj.cycle_or_phase_name{p};
                else
                    name = '';
                end
                
                fprintf(fid,'   %s: %s\n',                                          name, repmat('-', 1,25-length(name)));
                if isprop(obj, 'driver') && isprop(obj.driver, 'error_time_secs')
                    fprintf(fid,'   Percent Time Missed by 2mph = %6.2f %%\n',          obj.driver.error_time_secs(p) ./ obj.time_secs(p) * 100);
                end
                fprintf(fid,'   Distance                    = %6.3f mi\n',			obj.distance_mi(p));
                fprintf(fid,'   Fuel Consumption            = %6.4f grams\n',		obj.fuel_consumed_g(p));
                fprintf(fid,'   Fuel Consumption            = %6.4f gallons\n',		obj.fuel_consumed_vol_gallons(p));
                fprintf(fid,'   Fuel Economy (Volumetric)   = %6.3f mpg\n',			obj.FE_vol_mpg(p));
                fprintf(fid,'   Fuel Economy (CFR)          = %6.3f mpg\n',			obj.FE_CFR_mpg(p));
                fprintf(fid,'   Fuel Consumption            = %6.3f g/mile\n',		obj.fuel_consumed_g(p) / obj.distance_mi(p));
                if ~isempty(obj.gCO2pmi)
                    fprintf(fid,'   CO2 Emission                = %6.2f g/mile\n',		obj.gCO2pmi(p));
                end
                fprintf(fid,'\n');
            end
        end
        
        
    end
    
end


function out = compute_cycle_result( obj, value_prop, harmonic )

    quantity = obj.phase_data.(value_prop)(obj.phase_idx);
    distance = obj.phase_data_root.distance_m(obj.phase_idx);
    
    if harmonic
       quantity = 1 ./ quantity;
    end
               
    out = obj.aggregator(quantity, distance);
    
    if harmonic
       out = 1 ./ out;
    end
    
end

function out = default_aggregator( quantity, distance)
    out = sum(quantity(:) .* distance(:)) ./ sum(distance(:));
end



