classdef class_REVS_cycle_result_object < class_REVS_logging_object
	%class_REVS_VM_result
	%   Definition of class_REVS_VM_result class
    
    
    properties ( Dependent= true, Transient = true )

    end
    
    properties ( Hidden)        
        aggregator;
    end
    
    
    methods
        %% Constructor
        function obj = class_REVS_cycle_result_object( phase_data,  phase_idx, aggregator_func, phase_data_root)
            
            if nargin < 3
               aggregator_func = @class_REVS_default_cycle_aggregator;
            end
            
            if nargin < 4 
                phase_data_root = phase_data;
            end
                
            obj.aggregator = aggregator_func( phase_data, phase_data_root, phase_idx);

            props = properties(phase_data);
            
            for p = 1:length(props)
                
                prop = props{p};                                
                data = phase_data.(prop);
                prop_meta = findprop(phase_data,prop);
                
               
                if isa(data,'class_REVS_logging_object')
                    meta = obj.addprop( prop);
                    obj.(prop) = class_REVS_cycle_result_object(data, phase_idx, aggregator_func, phase_data_root);                        
                        
                elseif isobject( data) && isscalar(data)
                    meta = obj.addprop( prop);
                    meta.Dependent = 1;
                    meta.GetMethod = @(obj) obj.aggregator.phase_data.(prop); 
                
                elseif ~isnumeric( data)
                    % skip
                elseif prop_meta.Dependent
                    meta = obj.addprop( prop);
                    meta.Dependent = 1;
                    meta.GetMethod = prop_meta.GetMethod;  
                else
                    meta = obj.addprop( prop);
                    meta.Dependent = 1;
                    
                    if startsWith(prop,'initial_')
                        meta.GetMethod = @(obj) obj.aggregator.initial(prop);  
                    elseif startsWith(prop,'final_')
                        meta.GetMethod = @(obj) obj.aggregator.final(prop);  
                    elseif startsWith(prop,'max_')
                        meta.GetMethod = @(obj) obj.aggregator.maximum(prop);  
                    elseif startsWith(prop,'min_')
                        meta.GetMethod = @(obj) obj.aggregator.minimum(prop);  
                    elseif startsWith(prop,'mean_')
                        meta.GetMethod = @(obj) obj.aggregator.mean(prop);                                  
                    elseif any(endsWith( prop, {'_Jpm','_gpmi'}))
                        meta.GetMethod = @(obj) obj.aggregator.quant_per_dist(prop); 
                    elseif any(endsWith( prop, {'_mpg'}))
                        meta.GetMethod = @(obj) obj.aggregator.quant_per_dist(prop);                         
                    else
                        meta.GetMethod = @(obj) obj.aggregator.sum(prop); 
                    end
           
                end
                
            end
            
            
                     
        end
        
          
    end
           
end

